/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.FCTSBackedLighterAST;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.util.CharTable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LighterAST {
    private final CharTable myCharTable;

    public LighterAST(CharTable charTable) {
        this.myCharTable = charTable;
    }

    @NotNull
    public CharTable getCharTable() {
        CharTable charTable = this.myCharTable;
        if (charTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LighterAST", "getCharTable"));
        }
        return charTable;
    }

    @NotNull
    public abstract LighterASTNode getRoot();

    @Nullable
    public abstract LighterASTNode getParent(@NotNull LighterASTNode var1);

    @NotNull
    public abstract List<LighterASTNode> getChildren(@NotNull LighterASTNode var1);

    @Nullable
    public static LighterAST getLighterASTFromFileAST(@NotNull FileASTNode node, @NotNull Language language) {
        LighterAST tree;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/LighterAST", "getLighterASTFromFileAST"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/LighterAST", "getLighterASTFromFileAST"));
        }
        IFileElementType contentType = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)).getFileNodeType();
        assert (contentType instanceof ILightStubFileElementType);
        if (!node.isParsed()) {
            ILightStubFileElementType type = (ILightStubFileElementType)contentType;
            tree = new FCTSBackedLighterAST(node.getCharTable(), type.parseContentsLight(node));
        } else {
            tree = new TreeBackedLighterAST(node);
        }
        return tree;
    }
}

