/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.extensions.PluginId;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class PluginClassCache {
    private static final Object ourLock = new Object();
    private final Map<String, PluginId> myMissingClasses = new THashMap<String, PluginId>();
    private final TObjectIntHashMap<PluginId> myClassCounts = new TObjectIntHashMap();

    PluginClassCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginClass(String className, PluginId pluginId, boolean loaded) {
        Object object2 = ourLock;
        synchronized (object2) {
            if (loaded) {
                this.myMissingClasses.remove(className);
                this.myClassCounts.put(pluginId, this.myClassCounts.get(pluginId) + 1);
            } else {
                this.myMissingClasses.put(className, pluginId);
            }
        }
    }

    @Nullable
    private static PluginId findLoadingPlugin(String className) {
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
            ClassLoader loader = descriptor.getPluginClassLoader();
            if (!(loader instanceof PluginClassLoader) || !((PluginClassLoader)loader).hasLoadedClass(className)) continue;
            return descriptor.getPluginId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PluginId getPluginByClassName(String className) {
        Object object2 = ourLock;
        synchronized (object2) {
            PluginId id = this.myMissingClasses.get(className);
            if (id != null) {
                return id;
            }
        }
        return PluginClassCache.findLoadingPlugin(className);
    }
}

