/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import com.google.dart.compiler.util.AstUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTry
extends SourceInfoAwareJsNode
implements JsStatement {
    private final List<JsCatch> catches;
    private JsBlock finallyBlock;
    private JsBlock tryBlock;

    public JsTry() {
        this.catches = new SmartList<JsCatch>();
    }

    public JsTry(JsBlock tryBlock, List<JsCatch> catches, @Nullable JsBlock finallyBlock) {
        this.tryBlock = tryBlock;
        this.catches = catches;
        this.finallyBlock = finallyBlock;
    }

    public JsTry(JsBlock tryBlock, @Nullable JsCatch jsCatch, @Nullable JsBlock finallyBlock) {
        this(tryBlock, new SmartList<JsCatch>(), finallyBlock);
        if (jsCatch != null) {
            this.catches.add(jsCatch);
        }
    }

    public List<JsCatch> getCatches() {
        return this.catches;
    }

    public JsBlock getFinallyBlock() {
        return this.finallyBlock;
    }

    public JsBlock getTryBlock() {
        return this.tryBlock;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitTry(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor) {
        visitor.accept(this.tryBlock);
        visitor.acceptWithInsertRemove(this.catches);
        if (this.finallyBlock != null) {
            visitor.accept(this.finallyBlock);
        }
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.tryBlock = v.accept(this.tryBlock);
            v.acceptList(this.catches);
            if (this.finallyBlock != null) {
                this.finallyBlock = v.accept(this.finallyBlock);
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsTry deepCopy() {
        JsBlock tryCopy = AstUtil.deepCopy(this.tryBlock);
        List<JsCatch> catchCopy = AstUtil.deepCopy(this.catches);
        JsBlock finallyCopy = AstUtil.deepCopy(this.finallyBlock);
        JsTry jsTry = new JsTry(tryCopy, catchCopy, finallyCopy).withMetadataFrom(this);
        if (jsTry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsTry", "deepCopy"));
        }
        return jsTry;
    }
}

