/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsRegExp;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsVisitor;

class JsPrecedenceVisitor
extends JsVisitor {
    private int answer = -1;

    private JsPrecedenceVisitor() {
    }

    public static int exec(JsExpression expression) {
        JsPrecedenceVisitor visitor = new JsPrecedenceVisitor();
        visitor.accept(expression);
        if (visitor.answer < 0) {
            throw new RuntimeException("Precedence must be >= 0!");
        }
        return visitor.answer;
    }

    @Override
    public void visitArrayAccess(JsArrayAccess x) {
        this.answer = 16;
    }

    @Override
    public void visitArray(JsArrayLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitBinaryExpression(JsBinaryOperation x) {
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitBoolean(JsLiteral.JsBooleanLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitConditional(JsConditional x) {
        this.answer = 3;
    }

    @Override
    public void visitFunction(JsFunction x) {
        this.answer = 17;
    }

    @Override
    public void visitInvocation(JsInvocation invocation) {
        this.answer = 16;
    }

    @Override
    public void visitNameRef(JsNameRef nameRef) {
        this.answer = nameRef.isLeaf() ? 17 : 16;
    }

    @Override
    public void visitNew(JsNew x) {
        this.answer = 15;
    }

    @Override
    public void visitNull(JsNullLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitInt(JsNumberLiteral.JsIntLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitDouble(JsNumberLiteral.JsDoubleLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitObjectLiteral(JsObjectLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitPostfixOperation(JsPostfixOperation x) {
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitPrefixOperation(JsPrefixOperation x) {
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitPropertyInitializer(JsPropertyInitializer x) {
        this.answer = 17;
    }

    @Override
    public void visitRegExp(JsRegExp x) {
        this.answer = 17;
    }

    @Override
    public void visitString(JsStringLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitThis(JsLiteral.JsThisRef x) {
        this.answer = 17;
    }

    @Override
    protected void visitElement(JsNode node) {
        throw new RuntimeException("Only expressions have precedence.");
    }
}

