/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.general;

import com.google.common.collect.Lists;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public class JetTestFunctionDetector {
    private JetTestFunctionDetector() {
    }

    private static boolean isTest(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/k2js/translate/general/JetTestFunctionDetector", "isTest"));
        }
        Annotations annotations = functionDescriptor.getAnnotations();
        for (AnnotationDescriptor annotation : annotations) {
            JetType type = annotation.getType();
            String name = type.toString();
            if (!name.equals("Test")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<FunctionDescriptor> getTestFunctionDescriptors(@NotNull BindingContext bindingContext, @NotNull Collection<JetFile> files) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/k2js/translate/general/JetTestFunctionDetector", "getTestFunctionDescriptors"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/translate/general/JetTestFunctionDetector", "getTestFunctionDescriptors"));
        }
        ArrayList<FunctionDescriptor> answer = Lists.newArrayList();
        for (JetFile file : files) {
            answer.addAll(JetTestFunctionDetector.getTestFunctions(bindingContext, file.getDeclarations()));
        }
        ArrayList<FunctionDescriptor> arrayList = answer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/general/JetTestFunctionDetector", "getTestFunctionDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    private static List<FunctionDescriptor> getTestFunctions(@NotNull BindingContext bindingContext, @NotNull List<JetDeclaration> declarations) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/k2js/translate/general/JetTestFunctionDetector", "getTestFunctions"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/k2js/translate/general/JetTestFunctionDetector", "getTestFunctions"));
        }
        ArrayList<FunctionDescriptor> answer = Lists.newArrayList();
        for (JetDeclaration declaration : declarations) {
            JetClass klass;
            ClassDescriptor classDescriptor;
            JetScope scope = null;
            if (declaration instanceof JetClass && (classDescriptor = BindingUtils.getClassDescriptor(bindingContext, klass = (JetClass)declaration)).getModality() != Modality.ABSTRACT) {
                scope = classDescriptor.getDefaultType().getMemberScope();
            }
            if (scope == null) continue;
            Collection<DeclarationDescriptor> allDescriptors = scope.getAllDescriptors();
            List<FunctionDescriptor> testFunctions = ContainerUtil.mapNotNull(allDescriptors, new Function<DeclarationDescriptor, FunctionDescriptor>(){

                @Override
                public FunctionDescriptor fun(DeclarationDescriptor descriptor) {
                    FunctionDescriptor functionDescriptor;
                    if (descriptor instanceof FunctionDescriptor && JetTestFunctionDetector.isTest(functionDescriptor = (FunctionDescriptor)descriptor)) {
                        return functionDescriptor;
                    }
                    return null;
                }
            });
            answer.addAll(testFunctions);
        }
        ArrayList<FunctionDescriptor> arrayList = answer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/general/JetTestFunctionDetector", "getTestFunctions"));
        }
        return arrayList;
    }
}

