/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsThrow;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.PatternTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

@KotlinClass(abiVersion=19, data={",\b)y1)\u0019;dQR\u0013\u0018M\\:mCR|'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\t-\u0014$n\u001d\u0006\niJ\fgn\u001d7bi\u0016T!\"\u001a=qe\u0016\u001c8/[8o\u0015I\t%m\u001d;sC\u000e$HK]1og2\fGo\u001c:\u000b\u000f\u001d,g.\u001a:bY*1A(\u001b8jizRqaY1uG\",7O\u0003\u0003MSN$(BB6pi2LgN\u0003\bKKR\u001c\u0015\r^2i\u00072\fWo]3\u000b\u0007),GO\u0003\u0003mC:<'b\u00019tS*91m\u001c8uKb$(B\u0005+sC:\u001cH.\u0019;j_:\u001cuN\u001c;fqRTAA[1wC*!Q\u000f^5m\u0015)9W\r^\"bi\u000eDWm\u001d\u0006\u0011\u0015\u0016$H+\u001f9f%\u00164WM]3oG\u0016T1\"[:UQJ|w/\u00192mK*9!i\\8mK\u0006t'BD4fi&\u001bH\u000b\u001b:po\u0006\u0014G.\u001a\u0006\b\u0015N\u001c\u0015\r^2i\u0015\r\u0019w.\u001c\u0006\u0007O>|w\r\\3\u000b\t\u0011\f'\u000f\u001e\u0006\tG>l\u0007/\u001b7fe*9!-Y2lK:$'B\u00016t\u0015\r\t7\u000f\u001e\u0006\u0013iJ\fgn\u001d7bi\u0016\u001c\u0015\r^2i\u0005>$\u0017PC\u0006dCR\u001c\u0007n\u00117bkN,'b\u0002&t\u00052|7m\u001b\u0006\u0011iJ\fgn\u001d7bi\u0016\u001c\u0015\r^2iKNTA\u0002]1sC6,G/\u001a:SK\u001aT\u0011BS:OC6,'+\u001a4\u000b\u0011%#XM]1u_JT1BS:Ti\u0006$X-\\3oi\u001a\u0015!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0003\t\u0007A9!B\u0002\u0005\u0007!\u0019A\u0002A\u0003\u0002\u0011\u0017)1\u0001\u0002\u0003\t\u000b1\u0001QA\u0001C\u0001\u0011\u001b)!\u0001B\u0003\t\u000f\u0015\u0011A1\u0002E\b\u000b\r!a\u0001\u0003\u0004\r\u0001\u0015\u0011A1\u0001\u0005\t\u000b\r!q\u0001#\u0005\r\u0001\u0015\t\u0001\"C\u0003\u0003\t!A\u0019\"\u0002\u0002\u0005\u0012!)QA\u0001\u0003\b\u0011#)1\u0001\u0002\u0004\t\u00161\u0001Qa\u0001\u0003\u0005\u0011/a\u0001!\u0002\u0002\u0005\r!UQ!\u0001\u0005\u000e\u000b\t!9\u0002c\u0007\u0006\u0005\u0011a\u0001BD\u0003\u0003\t3Ai\"\u0002\u0002\u0005\u001b!yQA\u0001C\u000e\u0011?)!\u0001\u0002\b\t!\u0015\u0019AQ\u0004E\r\u0019\u0001)!\u0001\"\b\t\u001a\u0015\u0019AQ\u0004E\u0012\u0019\u0001)!\u0001\"\b\t$\u0015\u0011AA\u0002\u0005\u0007\u000b\r!i\u0002C\n\r\u0001\u0015\u0019A\u0001\u0002E\u0014\u0019\u0001)1\u0001\"\b\t)1\u0001QA\u0001C\u000f\u0011Q)!\u0001\"\b\t'\u0015\u0011A\u0011\u0003E\u0014\t\u0001a)!\u0007\u0002\u0006\u0003!\u001dQf\u0005\u0003a\ta%\u0011EB\u0003\u0002\u0011\u0013I1!\u0003\u0002\u0006\u0003!5Qk\u0001\u0005\u0006\u0007\u0011%\u0011\"\u0001\u0005\n\u001b\r!!\"C\u0001\t\u00135\nB!\u0019\u0003\u0016\u0005\u0015\t\u0001B\u0003\r\fC\t)\u0011\u0001#\u0006%CU\u001ba!D\u0003\u0005\u0019%\tA\u0011A\u0007\u0002\u0011-i+\u0002B\u0002\u0019\u0005\u0005\u001aQ!\u0001\u0005\u0010\u0019\u0003\t6a\u0001\u0003\u0003\u0013\u0005Ay\",\u000f\u0005\u0003a\u0005RT\u0002\u0003\u0001\u0011!i!!B\u0001\t\u0010A\u001b\u0001!(\u0004\u0005\u0001!\tRBA\u0003\u0002\u0011\u001b\u00016\u0011A\u0011\u0003\u000b\u0005A\u0001#U\u0002\b\tCI\u0011\u0001#\t\u000e\u0003!MQ\"\u0001\u0005\u0012[\u0003\"\u0011\u0001\u0007\n\u001e\u000e\u0011\u0001\u0001RE\u0007\u0003\u000b\u0005A\u0019\u0003U\u0002\u0001;+!\u0001\u0001#\u0003\u000e\r\u0015\t\u0001BE\u0005\u0004\u0013\t)\u0011\u0001#\u0004Q\u0007\u0003\t#!B\u0001\t&E\u001bq\u0001\u0002\n\n\u0003!\u0019R\"\u0001E\u0014\u001b\u0005AA#\u000e\u0012\u0006C\u0011\u0019\u000f\u0001\u0007\u0003\u001e\u0016\u0011\u0001\u0001\u0012B\u0007\u0007\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u0001R\u0002)\u0004\u0001u5A\u0001\u0001\u0005\t\u001b\t)\u0011\u0001c\u0004Q\u0007\u0003\t#!B\u0001\t\u0006E\u001bq\u0001\u0002\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\n\u001b\u0005A\u0019\u0002"})
public final class CatchTranslator
extends AbstractTranslator
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    @NotNull
    private final List<? extends JetCatchClause> catches;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(CatchTranslator.class);
    }

    @Nullable
    public final JsCatch translate() {
        if (KotlinPackage.getEmpty((Collection<? extends Object>)this.catches)) {
            return null;
        }
        JetCatchClause jetCatchClause = KotlinPackage.getFirst(this.catches);
        if (jetCatchClause == null) {
            Intrinsics.throwNpe();
        }
        JetCatchClause firstCatch = jetCatchClause;
        JetParameter catchParameter = firstCatch.getCatchParameter();
        TranslationContext translationContext = this.context();
        JetParameter jetParameter = catchParameter;
        if (jetParameter == null) {
            Intrinsics.throwNpe();
        }
        JsName parameterName = translationContext.getNameForElement(jetParameter);
        JsNameRef parameterRef = parameterName.makeRef();
        JsScope jsScope = this.context().scope();
        String string = parameterRef.getIdent();
        JsNameRef jsNameRef = parameterRef;
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "parameterRef");
        return new JsCatch(jsScope, string, this.translateCatches(jsNameRef, this.catches.iterator()));
    }

    private final JsStatement translateCatches(@JetValueParameter(name="parameterRef") JsNameRef parameterRef, @JetValueParameter(name="catches") Iterator<? extends JetCatchClause> catches) {
        PatternTranslator patternTranslator;
        if (!catches.hasNext()) {
            return new JsThrow(parameterRef);
        }
        JetCatchClause jetCatchClause = catches.next();
        JetParameter jetParameter = jetCatchClause.getCatchParameter();
        if (jetParameter == null) {
            Intrinsics.throwNpe();
        }
        JetParameter param = jetParameter;
        JsName paramName = this.context().getNameForElement(param);
        JetTypeReference jetTypeReference = param.getTypeReference();
        if (jetTypeReference == null) {
            Intrinsics.throwNpe();
        }
        JetTypeReference paramType = jetTypeReference;
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        JsBlock thenBlock = this.translateCatchBody(translationContext, jetCatchClause);
        if (Intrinsics.areEqual(paramName.getIdent(), parameterRef.getIdent()) ^ true) {
            thenBlock.getStatements().add(0, JsAstUtils.newVar(paramName, parameterRef));
        }
        if (this.getIsThrowable(paramType)) {
            return thenBlock;
        }
        PatternTranslator $receiver = patternTranslator = Translation.patternTranslator(this.context());
        JsExpression typeCheck = $receiver.translateIsCheck(parameterRef, paramType);
        JsStatement elseBlock = this.translateCatches(parameterRef, catches);
        return new JsIf(typeCheck, thenBlock, elseBlock);
    }

    private final JsBlock translateCatchBody(@JetValueParameter(name="context") TranslationContext context2, @JetValueParameter(name="catchClause") JetCatchClause catchClause) {
        JetExpression catchBody = catchClause.getCatchBody();
        JsStatement jsCatchBody = catchBody != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(catchBody, context2) : context2.getEmptyExpression().makeStmt();
        JsBlock jsBlock = JsAstUtils.convertToBlock(jsCatchBody);
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "convertToBlock(jsCatchBody)");
        return jsBlock;
    }

    private final boolean getIsThrowable(@JetValueParameter(name="$receiver") JetTypeReference $receiver) {
        JetType jetType = (JetType)BindingContextUtils.getNotNull(this.bindingContext(), BindingContext.TYPE, $receiver);
        String jetTypeName = TranslationUtils.getJetTypeFqName(jetType, false);
        ClassDescriptor throwable = KotlinBuiltIns.getInstance().getThrowable();
        String throwableClassName = DescriptorUtils.getFqNameSafe(throwable).asString();
        return Intrinsics.areEqual(jetTypeName, throwableClassName);
    }

    @NotNull
    public final List<JetCatchClause> getCatches() {
        List<JetCatchClause> list = this.catches;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/CatchTranslator", "getCatches"));
        }
        return list;
    }

    public CatchTranslator(@JetValueParameter(name="catches") @NotNull List<? extends JetCatchClause> catches, @JetValueParameter(name="context") @NotNull TranslationContext context2) {
        if (catches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catches", "org/jetbrains/k2js/translate/expression/CatchTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/CatchTranslator", "<init>"));
        }
        Intrinsics.checkParameterIsNotNull(catches, "catches");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        super(context2);
        this.catches = catches;
    }
}

