/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.utils.UtilsPackage;

public class WrappedValues {
    private static final Object NULL_VALUE = new Object(){

        public String toString() {
            return "NULL_VALUE";
        }
    };

    private WrappedValues() {
    }

    @Nullable
    public static <V> V unescapeNull(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/utils/WrappedValues", "unescapeNull"));
        }
        if (value == NULL_VALUE) {
            return null;
        }
        return (V)value;
    }

    @NotNull
    public static <V> Object escapeNull(@Nullable V value) {
        if (value == null) {
            Object object2 = NULL_VALUE;
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/WrappedValues", "escapeNull"));
            }
            return object2;
        }
        V v = value;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/WrappedValues", "escapeNull"));
        }
        return v;
    }

    @NotNull
    public static Object escapeThrowable(@NotNull Throwable throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwable", "org/jetbrains/jet/utils/WrappedValues", "escapeThrowable"));
        }
        ThrowableWrapper throwableWrapper = new ThrowableWrapper(throwable);
        if (throwableWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/WrappedValues", "escapeThrowable"));
        }
        return throwableWrapper;
    }

    @Nullable
    public static <V> V unescapeExceptionOrNull(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/utils/WrappedValues", "unescapeExceptionOrNull"));
        }
        return WrappedValues.unescapeNull(WrappedValues.unescapeThrowable(value));
    }

    @Nullable
    public static <V> V unescapeThrowable(@Nullable Object value) {
        if (value instanceof ThrowableWrapper) {
            throw UtilsPackage.rethrow(((ThrowableWrapper)value).getThrowable());
        }
        return (V)value;
    }

    private static final class ThrowableWrapper {
        private final Throwable throwable;

        private ThrowableWrapper(@NotNull Throwable throwable) {
            if (throwable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwable", "org/jetbrains/jet/utils/WrappedValues$ThrowableWrapper", "<init>"));
            }
            this.throwable = throwable;
        }

        @NotNull
        public Throwable getThrowable() {
            Throwable throwable = this.throwable;
            if (throwable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/WrappedValues$ThrowableWrapper", "getThrowable"));
            }
            return throwable;
        }

        public String toString() {
            return this.throwable.toString();
        }
    }
}

