/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.types.AbstractClassTypeConstructor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;

public abstract class TypeConstructorImpl
extends AnnotatedImpl
implements TypeConstructor {
    private final List<TypeParameterDescriptor> parameters;
    private final Collection<JetType> supertypes;
    private final String debugName;
    private final boolean isFinal;
    private final ClassifierDescriptor classifierDescriptor;

    @NotNull
    public static TypeConstructorImpl createForClass(@NotNull ClassDescriptor classDescriptor, @NotNull Annotations annotations, boolean isFinal, @NotNull String debugName, @NotNull List<? extends TypeParameterDescriptor> parameters, @NotNull Collection<JetType> supertypes) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "createForClass"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "createForClass"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "createForClass"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "createForClass"));
        }
        if (supertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "createForClass"));
        }
        TypeConstructorImpl typeConstructorImpl = new TypeConstructorImpl((ClassifierDescriptor)classDescriptor, annotations, isFinal, debugName, (List)parameters, (Collection)supertypes){

            @Override
            public int hashCode() {
                return AbstractClassTypeConstructor.hashCode(this);
            }

            @Override
            public boolean equals(Object obj) {
                return AbstractClassTypeConstructor.equals(this, obj);
            }
        };
        if (typeConstructorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "createForClass"));
        }
        return typeConstructorImpl;
    }

    @NotNull
    public static TypeConstructorImpl createForTypeParameter(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull Annotations annotations, boolean isFinal, @NotNull String debugName, @NotNull List<? extends TypeParameterDescriptor> parameters, @NotNull Collection<JetType> supertypes) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        if (supertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        TypeConstructorImpl typeConstructorImpl = new TypeConstructorImpl((ClassifierDescriptor)typeParameterDescriptor, annotations, isFinal, debugName, (List)parameters, (Collection)supertypes){

            @Override
            public int hashCode() {
                return System.identityHashCode(this);
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        };
        if (typeConstructorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        return typeConstructorImpl;
    }

    private TypeConstructorImpl(@Nullable ClassifierDescriptor classifierDescriptor, @NotNull Annotations annotations, boolean isFinal, @NotNull String debugName, @NotNull List<? extends TypeParameterDescriptor> parameters, @NotNull Collection<JetType> supertypes) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "<init>"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "<init>"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "<init>"));
        }
        if (supertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "<init>"));
        }
        super(annotations);
        this.classifierDescriptor = classifierDescriptor;
        this.isFinal = isFinal;
        this.debugName = debugName;
        this.parameters = Collections.unmodifiableList(new ArrayList<TypeParameterDescriptor>(parameters));
        this.supertypes = Collections.unmodifiableCollection(supertypes);
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        List<TypeParameterDescriptor> list = this.parameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "getParameters"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<JetType> getSupertypes() {
        Collection<JetType> collection = this.supertypes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "getSupertypes"));
        }
        return collection;
    }

    public String toString() {
        return this.debugName;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isDenotable() {
        return true;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return this.classifierDescriptor;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

