/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import java.util.Collection;
import java.util.List;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.utils.Printer;

public class FilteringScope
implements JetScope {
    private final JetScope workerScope;
    private final Function1<DeclarationDescriptor, Boolean> predicate;

    public FilteringScope(@NotNull JetScope workerScope, @NotNull Function1<DeclarationDescriptor, Boolean> predicate) {
        if (workerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workerScope", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "<init>"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "<init>"));
        }
        this.workerScope = workerScope;
        this.predicate = predicate;
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getFunctions"));
        }
        List<DeclarationDescriptor> list = KotlinPackage.filter(this.workerScope.getFunctions(name), this.predicate);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getFunctions"));
        }
        return list;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.workerScope.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Nullable
    private <D extends DeclarationDescriptor> D filterDescriptor(@Nullable D descriptor) {
        return descriptor != null && this.predicate.invoke(descriptor) != false ? (D)descriptor : null;
    }

    @Override
    @Nullable
    public PackageViewDescriptor getPackage(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getPackage"));
        }
        return this.filterDescriptor(this.workerScope.getPackage(name));
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getClassifier"));
        }
        return this.filterDescriptor(this.workerScope.getClassifier(name));
    }

    @Override
    @NotNull
    public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getProperties"));
        }
        List<DeclarationDescriptor> list = KotlinPackage.filter(this.workerScope.getProperties(name), this.predicate);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getProperties"));
        }
        return list;
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getLocalVariable"));
        }
        return this.filterDescriptor(this.workerScope.getLocalVariable(name));
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        List<DeclarationDescriptor> list = KotlinPackage.filter(this.workerScope.getAllDescriptors(), this.predicate);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getAllDescriptors"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        List<ReceiverParameterDescriptor> list = this.workerScope.getImplicitReceiversHierarchy();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getImplicitReceiversHierarchy"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull Name labelName) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getDeclarationsByLabel"));
        }
        List<DeclarationDescriptor> list = KotlinPackage.filter(this.workerScope.getDeclarationsByLabel(labelName), this.predicate);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getDeclarationsByLabel"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        List<DeclarationDescriptor> list = KotlinPackage.filter(this.workerScope.getOwnDeclaredDescriptors(), this.predicate);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getOwnDeclaredDescriptors"));
        }
        return list;
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "printScopeStructure"));
        }
        p.println(this.getClass().getSimpleName(), " {");
        p.pushIndent();
        p.print("workerScope = ");
        this.workerScope.printScopeStructure(p.withholdIndentOnce());
        p.popIndent();
        p.println("}");
    }
}

