/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;

class PropagationHeuristics {
    static void checkArrayInReturnType(@NotNull SignaturesPropagationData data2, @NotNull JetType type, @NotNull List<SignaturesPropagationData.TypeAndVariance> typesFromSuper) {
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics", "checkArrayInReturnType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics", "checkArrayInReturnType"));
        }
        if (typesFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesFromSuper", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics", "checkArrayInReturnType"));
        }
        List<SignaturesPropagationData.TypeAndVariance> arrayTypesFromSuper = ContainerUtil.filter(typesFromSuper, new Condition<SignaturesPropagationData.TypeAndVariance>(){

            @Override
            public boolean value(SignaturesPropagationData.TypeAndVariance typeAndVariance) {
                return typeAndVariance.type.getConstructor().getDeclarationDescriptor() == KotlinBuiltIns.getInstance().getArray();
            }
        });
        if (KotlinBuiltIns.getInstance().getArray() == type.getConstructor().getDeclarationDescriptor() && !arrayTypesFromSuper.isEmpty()) {
            assert (type.getArguments().size() == 1);
            if (type.getArguments().get(0).getProjectionKind() == Variance.INVARIANT) {
                for (SignaturesPropagationData.TypeAndVariance typeAndVariance : arrayTypesFromSuper) {
                    JetType arrayTypeFromSuper = typeAndVariance.type;
                    assert (arrayTypeFromSuper.getArguments().size() == 1);
                    JetType elementTypeInSuper = arrayTypeFromSuper.getArguments().get(0).getType();
                    JetType elementType = type.getArguments().get(0).getType();
                    if (!JetTypeChecker.DEFAULT.isSubtypeOf(elementType, elementTypeInSuper) || JetTypeChecker.DEFAULT.equalTypes(elementType, elementTypeInSuper)) continue;
                    JetTypeImpl betterTypeInSuper = new JetTypeImpl(arrayTypeFromSuper.getAnnotations(), arrayTypeFromSuper.getConstructor(), arrayTypeFromSuper.isNullable(), Arrays.asList(new TypeProjectionImpl(Variance.OUT_VARIANCE, elementTypeInSuper)), JetScope.EMPTY);
                    data2.reportError("Return type is not a subtype of overridden method. To fix it, add annotation with Kotlin signature to super method with type " + DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(arrayTypeFromSuper) + " replaced with " + DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(betterTypeInSuper) + " in return type");
                }
            }
        }
    }

    @Nullable
    static ClassifierDescriptor tryToFixOverridingTWithRawType(@NotNull SignaturesPropagationData data2, @NotNull List<SignaturesPropagationData.TypeAndVariance> typesFromSuper) {
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics", "tryToFixOverridingTWithRawType"));
        }
        if (typesFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesFromSuper", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics", "tryToFixOverridingTWithRawType"));
        }
        ArrayList<TypeParameterDescriptor> typeParameterClassifiersFromSuper = Lists.newArrayList();
        for (SignaturesPropagationData.TypeAndVariance typeFromSuper : typesFromSuper) {
            ClassifierDescriptor classifierFromSuper = typeFromSuper.type.getConstructor().getDeclarationDescriptor();
            if (!(classifierFromSuper instanceof TypeParameterDescriptor)) continue;
            typeParameterClassifiersFromSuper.add((TypeParameterDescriptor)classifierFromSuper);
        }
        if (!typeParameterClassifiersFromSuper.isEmpty() && typeParameterClassifiersFromSuper.size() == typesFromSuper.size()) {
            for (TypeParameterDescriptor typeParameter : typeParameterClassifiersFromSuper) {
                if (typeParameter.getContainingDeclaration() != data2.containingClass) continue;
                return typeParameter;
            }
        }
        return null;
    }

    private PropagationHeuristics() {
    }
}

