/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.diagnostics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.jet.lang.diagnostics.rendering.DiagnosticFactoryToRendererMap;
import org.jetbrains.jet.lang.resolve.java.diagnostics.ConflictingJvmDeclarationsData;
import org.jetbrains.jet.lang.resolve.java.diagnostics.ErrorsJvm;
import org.jetbrains.jet.lang.resolve.java.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.jet.renderer.Renderer;

public class DefaultErrorMessagesJvm
implements DefaultErrorMessages.Extension {
    private static final Renderer<ConflictingJvmDeclarationsData> CONFLICTING_JVM_DECLARATIONS_DATA = new Renderer<ConflictingJvmDeclarationsData>(){

        @Override
        @NotNull
        public String render(@NotNull ConflictingJvmDeclarationsData data2) {
            if (data2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/jet/lang/resolve/java/diagnostics/DefaultErrorMessagesJvm$1", "render"));
            }
            StringBuilder sb = new StringBuilder();
            for (JvmDeclarationOrigin origin : data2.getSignatureOrigins()) {
                DeclarationDescriptor descriptor = origin.getDescriptor();
                if (descriptor == null) continue;
                sb.append("    ").append(DescriptorRenderer.COMPACT.render(descriptor)).append("\n");
            }
            String string = ("The following declarations have the same JVM signature (" + data2.getSignature().getName() + data2.getSignature().getDesc() + "):\n" + sb).trim();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/diagnostics/DefaultErrorMessagesJvm$1", "render"));
            }
            return string;
        }
    };
    public static final DiagnosticFactoryToRendererMap MAP = new DiagnosticFactoryToRendererMap();

    @Override
    @NotNull
    public DiagnosticFactoryToRendererMap getMap() {
        DiagnosticFactoryToRendererMap diagnosticFactoryToRendererMap = MAP;
        if (diagnosticFactoryToRendererMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/diagnostics/DefaultErrorMessagesJvm", "getMap"));
        }
        return diagnosticFactoryToRendererMap;
    }

    static {
        MAP.put(ErrorsJvm.CONFLICTING_JVM_DECLARATIONS, "Platform declaration clash: {0}", CONFLICTING_JVM_DECLARATIONS_DATA);
        MAP.put(ErrorsJvm.ACCIDENTAL_OVERRIDE, "Accidental override: {0}", CONFLICTING_JVM_DECLARATIONS_DATA);
        MAP.put(ErrorsJvm.PLATFORM_STATIC_NOT_IN_OBJECT, "Only functions in named objects and class objects of classes can be annotated with ''platformStatic''", DescriptorRenderer.SHORT_NAMES_IN_TYPES);
        MAP.put(ErrorsJvm.OVERRIDE_CANNOT_BE_STATIC, "Override cannot be ''platformStatic'' in object", DescriptorRenderer.SHORT_NAMES_IN_TYPES);
        MAP.put(ErrorsJvm.PLATFORM_STATIC_ILLEGAL_USAGE, "This declaration does not support ''platformStatic''", DescriptorRenderer.SHORT_NAMES_IN_TYPES);
    }
}

