/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JavaClassFinder;
import org.jetbrains.jet.lang.resolve.java.JavaPsiFacadeKotlinHacks;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaPackageImpl;
import org.jetbrains.jet.lang.resolve.name.ClassId;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.plugin.JetFileType;

public class JavaClassFinderImpl
implements JavaClassFinder {
    private Project project;
    private GlobalSearchScope baseScope;
    private GlobalSearchScope javaSearchScope;
    private JavaPsiFacadeKotlinHacks javaFacade;

    @Inject
    public void setProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/JavaClassFinderImpl", "setProject"));
        }
        this.project = project;
    }

    @Inject
    public void setScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/java/JavaClassFinderImpl", "setScope"));
        }
        this.baseScope = scope;
    }

    @PostConstruct
    public void initialize() {
        this.javaSearchScope = new DelegatingGlobalSearchScope(this.baseScope){

            @Override
            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/java/JavaClassFinderImpl$1", "contains"));
                }
                return this.myBaseScope.contains(file) && file.getFileType() != JetFileType.INSTANCE;
            }

            @Override
            @NotNull
            public Project getProject() {
                Project project = JavaClassFinderImpl.this.project;
                if (project == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JavaClassFinderImpl$1", "getProject"));
                }
                return project;
            }
        };
        this.javaFacade = new JavaPsiFacadeKotlinHacks(this.project);
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull ClassId classId) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/lang/resolve/java/JavaClassFinderImpl", "findClass"));
        }
        FqNameUnsafe fqName2 = classId.asSingleFqName();
        PsiClass psiClass = this.javaFacade.findClass(fqName2.asString(), this.javaSearchScope);
        if (psiClass == null) {
            return null;
        }
        JavaClassImpl javaClass = new JavaClassImpl(psiClass);
        if (!fqName2.equalsTo(javaClass.getFqName())) {
            throw new IllegalStateException("Requested " + fqName2 + ", got " + javaClass.getFqName());
        }
        if (javaClass.getOriginKind() == JavaClass.OriginKind.KOTLIN_LIGHT_CLASS) {
            throw new IllegalStateException("Kotlin light classes should not be found by JavaPsiFacade, resolving: " + fqName2);
        }
        return javaClass;
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/JavaClassFinderImpl", "findPackage"));
        }
        PsiPackage psiPackage = this.javaFacade.findPackage(fqName2.asString());
        return psiPackage == null ? null : new JavaPackageImpl(psiPackage);
    }
}

