/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.org.objectweb.asm.Type;

public class AsmTypeConstants {
    private static final Map<Class<?>, Type> TYPES_MAP = new HashMap();
    public static final Type OBJECT_TYPE = AsmTypeConstants.getType(Object.class);
    public static final Type JAVA_STRING_TYPE = AsmTypeConstants.getType(String.class);
    public static final Type JAVA_THROWABLE_TYPE = AsmTypeConstants.getType(Throwable.class);
    public static final Type UNIT_TYPE = Type.getObjectType(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "/Unit");
    public static final Type FUNCTION1_TYPE = Type.getObjectType(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "/Function1");
    public static final Type INT_RANGE_TYPE = Type.getObjectType(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "/IntRange");
    public static final Type PROPERTY_METADATA_TYPE = Type.getObjectType(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "/PropertyMetadata");
    public static final Type PROPERTY_METADATA_IMPL_TYPE = Type.getObjectType(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "/PropertyMetadataImpl");
    public static final Type K_MEMBER_PROPERTY_TYPE = Type.getObjectType("kotlin/reflect/KMemberProperty");
    public static final Type K_MUTABLE_MEMBER_PROPERTY_TYPE = Type.getObjectType("kotlin/reflect/KMutableMemberProperty");
    public static final Type K_CLASS_IMPL_TYPE = AsmTypeConstants.reflectInternal("KClassImpl");
    public static final Type K_PACKAGE_IMPL_TYPE = AsmTypeConstants.reflectInternal("KPackageImpl");
    public static final Type K_TOP_LEVEL_VARIABLE_IMPL_TYPE = AsmTypeConstants.reflectInternal("KTopLevelVariableImpl");
    public static final Type K_MUTABLE_TOP_LEVEL_VARIABLE_IMPL_TYPE = AsmTypeConstants.reflectInternal("KMutableTopLevelVariableImpl");
    public static final Type K_TOP_LEVEL_EXTENSION_PROPERTY_IMPL_TYPE = AsmTypeConstants.reflectInternal("KTopLevelExtensionPropertyImpl");
    public static final Type K_MUTABLE_TOP_LEVEL_EXTENSION_PROPERTY_IMPL_TYPE = AsmTypeConstants.reflectInternal("KMutableTopLevelExtensionPropertyImpl");
    public static final String REFLECTION_INTERNAL_PACKAGE = AsmTypeConstants.reflectInternal("InternalPackage").getInternalName();
    public static final Type OBJECT_REF_TYPE = Type.getObjectType("kotlin/jvm/internal/Ref$ObjectRef");

    @NotNull
    private static Type reflectInternal(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/java/AsmTypeConstants", "reflectInternal"));
        }
        Type type = Type.getObjectType("kotlin/reflect/jvm/internal/" + className);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AsmTypeConstants", "reflectInternal"));
        }
        return type;
    }

    @NotNull
    public static Type getType(@NotNull Class<?> javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/AsmTypeConstants", "getType"));
        }
        Type type = TYPES_MAP.get(javaClass);
        if (type == null) {
            type = Type.getType(javaClass);
            TYPES_MAP.put(javaClass, type);
        }
        Type type2 = type;
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AsmTypeConstants", "getType"));
        }
        return type2;
    }

    private AsmTypeConstants() {
    }
}

