/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueConstant;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class IntegerValueTypeConstant
extends IntegerValueConstant<Number> {
    private final IntegerValueTypeConstructor typeConstructor;

    public IntegerValueTypeConstant(@NotNull Number value, boolean canBeUsedInAnnotations, boolean usesVariableAsConstant) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstant", "<init>"));
        }
        super(value, canBeUsedInAnnotations, true, usesVariableAsConstant);
        this.typeConstructor = new IntegerValueTypeConstructor(value.longValue());
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstant", "getType"));
        }
        JetTypeImpl jetTypeImpl = new JetTypeImpl(Annotations.EMPTY, this.typeConstructor, false, Collections.emptyList(), ErrorUtils.createErrorScope("Scope for number value type (" + this.typeConstructor.toString() + ")", true));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstant", "getType"));
        }
        return jetTypeImpl;
    }

    @Override
    @Deprecated
    @Nullable
    public Number getValue() {
        throw new UnsupportedOperationException("Use IntegerValueTypeConstant.getValue(expectedType) instead");
    }

    @NotNull
    public JetType getType(@NotNull JetType expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstant", "getType"));
        }
        JetType jetType = TypeUtils.getPrimitiveNumberType(this.typeConstructor, expectedType);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstant", "getType"));
        }
        return jetType;
    }

    @NotNull
    public Number getValue(@NotNull JetType expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstant", "getValue"));
        }
        Long numberValue = this.typeConstructor.getValue();
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        JetType valueType = this.getType(expectedType);
        if (((Object)valueType).equals(builtIns.getIntType())) {
            Integer n = ((Number)numberValue).intValue();
            if (n == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstant", "getValue"));
            }
            return n;
        }
        if (((Object)valueType).equals(builtIns.getByteType())) {
            Byte by = ((Number)numberValue).byteValue();
            if (by == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstant", "getValue"));
            }
            return by;
        }
        if (((Object)valueType).equals(builtIns.getShortType())) {
            Short s = ((Number)numberValue).shortValue();
            if (s == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstant", "getValue"));
            }
            return s;
        }
        Long l = (long)numberValue;
        if (l == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstant", "getValue"));
        }
        return l;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitNumberTypeValue(this, data2);
    }

    public String toString() {
        return this.typeConstructor.toString();
    }
}

