/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.resolve.Diagnostics;

public class DiagnosticsElementsCache {
    private final Diagnostics diagnostics;
    private final AtomicNotNullLazyValue<MultiMap<PsiElement, Diagnostic>> elementToDiagnostic = new AtomicNotNullLazyValue<MultiMap<PsiElement, Diagnostic>>(){

        @Override
        @NotNull
        protected MultiMap<PsiElement, Diagnostic> compute() {
            MultiMap multiMap = DiagnosticsElementsCache.buildElementToDiagnosticCache(DiagnosticsElementsCache.this.diagnostics);
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsElementsCache$1", "compute"));
            }
            return multiMap;
        }
    };

    public DiagnosticsElementsCache(Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
    }

    @NotNull
    public Collection<Diagnostic> getDiagnostics(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/jet/lang/resolve/DiagnosticsElementsCache", "getDiagnostics"));
        }
        Collection<Diagnostic> collection = this.elementToDiagnostic.getValue().get(psiElement);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsElementsCache", "getDiagnostics"));
        }
        return collection;
    }

    private static MultiMap<PsiElement, Diagnostic> buildElementToDiagnosticCache(Diagnostics diagnostics) {
        ConcurrentMultiMap<PsiElement, Diagnostic> elementToDiagnostic = new ConcurrentMultiMap<PsiElement, Diagnostic>();
        for (Diagnostic diagnostic : diagnostics) {
            elementToDiagnostic.putValue(diagnostic.getPsiElement(), diagnostic);
        }
        return elementToDiagnostic;
    }
}

