/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetElementImplStub;
import org.jetbrains.jet.lang.psi.JetNameReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.stubs.PsiJetUserTypeStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lexer.JetTokens;

public class JetUserType
extends JetElementImplStub<PsiJetUserTypeStub>
implements JetTypeElement {
    public JetUserType(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetUserType", "<init>"));
        }
        super(node);
    }

    public JetUserType(@NotNull PsiJetUserTypeStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetUserType", "<init>"));
        }
        super(stub, JetStubElementTypes.USER_TYPE);
    }

    public boolean isAbsoluteInRootPackage() {
        PsiJetUserTypeStub stub = (PsiJetUserTypeStub)this.getStub();
        if (stub != null) {
            return stub.isAbsoluteInRootPackage();
        }
        return this.findChildByType(JetTokens.PACKAGE_KEYWORD) != null;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetUserType", "accept"));
        }
        return visitor.visitUserType(this, data2);
    }

    public JetTypeArgumentList getTypeArgumentList() {
        return (JetTypeArgumentList)this.getStubOrPsiChild(JetStubElementTypes.TYPE_ARGUMENT_LIST);
    }

    @NotNull
    public List<JetTypeProjection> getTypeArguments() {
        JetTypeArgumentList typeArgumentList = this.getTypeArgumentList();
        List<Object> list = typeArgumentList == null ? Collections.emptyList() : typeArgumentList.getArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetUserType", "getTypeArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetTypeReference> getTypeArgumentsAsTypes() {
        ArrayList<JetTypeReference> result2 = Lists.newArrayList();
        for (JetTypeProjection projection : this.getTypeArguments()) {
            result2.add(projection.getTypeReference());
        }
        ArrayList<JetTypeReference> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetUserType", "getTypeArgumentsAsTypes"));
        }
        return arrayList;
    }

    @IfNotParsed
    @Nullable
    public JetNameReferenceExpression getReferenceExpression() {
        return this.getStubOrPsiChild(JetStubElementTypes.REFERENCE_EXPRESSION);
    }

    @Nullable
    public JetUserType getQualifier() {
        return this.getStubOrPsiChild(JetStubElementTypes.USER_TYPE);
    }

    @Nullable
    public String getReferencedName() {
        JetNameReferenceExpression referenceExpression = this.getReferenceExpression();
        return referenceExpression == null ? null : referenceExpression.getReferencedName();
    }
}

