/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPropertyDelegate;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwnerStub;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVariableDeclaration;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.stubs.PsiJetPropertyStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.psi.typeRefHelpers.TypeRefHelpersPackage;
import org.jetbrains.jet.lexer.JetTokens;

public class JetProperty
extends JetTypeParameterListOwnerStub<PsiJetPropertyStub>
implements PsiModifiableCodeBlock,
JetVariableDeclaration {
    private static final Logger LOG = Logger.getInstance(JetProperty.class);

    public JetProperty(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetProperty", "<init>"));
        }
        super(node);
    }

    public JetProperty(@NotNull PsiJetPropertyStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetProperty", "<init>"));
        }
        super(stub, JetStubElementTypes.PROPERTY);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetProperty", "accept"));
        }
        return visitor.visitProperty(this, data2);
    }

    @Override
    public boolean isVar() {
        PsiJetPropertyStub stub = (PsiJetPropertyStub)this.getStub();
        if (stub != null) {
            return stub.isVar();
        }
        return this.getNode().findChildByType(JetTokens.VAR_KEYWORD) != null;
    }

    public boolean isLocal() {
        PsiElement parent = this.getParent();
        return !(parent instanceof JetFile) && !(parent instanceof JetClassBody);
    }

    public boolean isTopLevel() {
        PsiJetPropertyStub stub = (PsiJetPropertyStub)this.getStub();
        if (stub != null) {
            return stub.isTopLevel();
        }
        return this.getParent() instanceof JetFile;
    }

    @Override
    @Nullable
    public JetParameterList getValueParameterList() {
        return null;
    }

    @Override
    @Nullable
    public JetTypeReference getReceiverTypeReference() {
        PsiJetPropertyStub stub = (PsiJetPropertyStub)this.getStub();
        if (stub != null) {
            if (!stub.hasReceiverTypeRef()) {
                return null;
            }
            return (JetTypeReference)this.getStubOrPsiChild(JetStubElementTypes.TYPE_REFERENCE);
        }
        return this.getReceiverTypeRefByTree();
    }

    @Nullable
    private JetTypeReference getReceiverTypeRefByTree() {
        IElementType tt;
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null && (tt = node.getElementType()) != JetTokens.COLON; node = node.getTreeNext()) {
            if (tt != JetNodeTypes.TYPE_REFERENCE) continue;
            return (JetTypeReference)node.getPsi();
        }
        return null;
    }

    @Override
    @Nullable
    public JetTypeReference getTypeReference() {
        PsiJetPropertyStub stub = (PsiJetPropertyStub)this.getStub();
        if (stub != null) {
            int returnTypeRefPositionInPsi;
            if (!stub.hasReturnTypeRef()) {
                return null;
            }
            List typeReferences = this.getStubOrPsiChildrenAsList(JetStubElementTypes.TYPE_REFERENCE);
            int n = returnTypeRefPositionInPsi = stub.hasReceiverTypeRef() ? 1 : 0;
            if (typeReferences.size() <= returnTypeRefPositionInPsi) {
                LOG.error("Invalid stub structure built for property:\n" + this.getText());
                return null;
            }
            return (JetTypeReference)typeReferences.get(returnTypeRefPositionInPsi);
        }
        return TypeRefHelpersPackage.getTypeReference(this);
    }

    @Override
    @Nullable
    public JetTypeReference setTypeReference(@Nullable JetTypeReference typeRef) {
        return TypeRefHelpersPackage.setTypeReference(this, this.getNameIdentifier(), typeRef);
    }

    @NotNull
    public List<JetPropertyAccessor> getAccessors() {
        List<JetPropertyAccessor> list = this.getStubOrPsiChildrenAsList(JetStubElementTypes.PROPERTY_ACCESSOR);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetProperty", "getAccessors"));
        }
        return list;
    }

    @Nullable
    public JetPropertyAccessor getGetter() {
        for (JetPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isGetter()) continue;
            return accessor;
        }
        return null;
    }

    @Nullable
    public JetPropertyAccessor getSetter() {
        for (JetPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isSetter()) continue;
            return accessor;
        }
        return null;
    }

    public boolean hasDelegate() {
        PsiJetPropertyStub stub = (PsiJetPropertyStub)this.getStub();
        if (stub != null) {
            return stub.hasDelegate();
        }
        return this.getDelegate() != null;
    }

    @Nullable
    public JetPropertyDelegate getDelegate() {
        return (JetPropertyDelegate)this.findChildByType(JetNodeTypes.PROPERTY_DELEGATE);
    }

    public boolean hasDelegateExpression() {
        PsiJetPropertyStub stub = (PsiJetPropertyStub)this.getStub();
        if (stub != null) {
            return stub.hasDelegateExpression();
        }
        return this.getDelegateExpression() != null;
    }

    @Nullable
    public JetExpression getDelegateExpression() {
        JetPropertyDelegate delegate2 = this.getDelegate();
        if (delegate2 != null) {
            return delegate2.getExpression();
        }
        return null;
    }

    @Override
    public boolean hasInitializer() {
        PsiJetPropertyStub stub = (PsiJetPropertyStub)this.getStub();
        if (stub != null) {
            return stub.hasInitializer();
        }
        return this.getInitializer() != null;
    }

    @Override
    @Nullable
    public JetExpression getInitializer() {
        return PsiTreeUtil.getNextSiblingOfType(this.findChildByType(JetTokens.EQ), JetExpression.class);
    }

    public boolean hasDelegateExpressionOrInitializer() {
        return this.hasDelegateExpression() || this.hasInitializer();
    }

    @Nullable
    public JetExpression setInitializer(@Nullable JetExpression initializer) {
        JetExpression oldInitializer = this.getInitializer();
        if (oldInitializer != null) {
            if (initializer != null) {
                return (JetExpression)oldInitializer.replace(initializer);
            }
            this.deleteChildRange(this.findChildByType(JetTokens.EQ), oldInitializer);
            return null;
        }
        if (initializer != null) {
            PsiElement addAfter = this.getTypeReference();
            if (addAfter == null) {
                addAfter = this.getNameIdentifier();
            }
            PsiElement eq = this.addAfter(new JetPsiFactory(this.getProject()).createEQ(), addAfter);
            return (JetExpression)this.addAfter(initializer, eq);
        }
        return null;
    }

    @Nullable
    public JetExpression getDelegateExpressionOrInitializer() {
        JetExpression expression = this.getDelegateExpression();
        if (expression == null) {
            return this.getInitializer();
        }
        return expression;
    }

    @Override
    @NotNull
    public ASTNode getValOrVarNode() {
        ASTNode node = this.getNode().findChildByType(TokenSet.create(JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD));
        assert (node != null) : "Val or var should always exist for property";
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetProperty", "getValOrVarNode"));
        }
        return aSTNode;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public boolean shouldChangeModificationCount(PsiElement place) {
        return false;
    }
}

