/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.resolve.name.ClassId;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public class NameResolver {
    private final ProtoBuf.StringTable strings;
    private final ProtoBuf.QualifiedNameTable qualifiedNames;

    public NameResolver(@NotNull ProtoBuf.StringTable strings2, @NotNull ProtoBuf.QualifiedNameTable qualifiedNames) {
        if (strings2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "org/jetbrains/jet/descriptors/serialization/NameResolver", "<init>"));
        }
        if (qualifiedNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNames", "org/jetbrains/jet/descriptors/serialization/NameResolver", "<init>"));
        }
        this.strings = strings2;
        this.qualifiedNames = qualifiedNames;
    }

    @NotNull
    public ProtoBuf.StringTable getStringTable() {
        ProtoBuf.StringTable stringTable = this.strings;
        if (stringTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameResolver", "getStringTable"));
        }
        return stringTable;
    }

    @NotNull
    public ProtoBuf.QualifiedNameTable getQualifiedNameTable() {
        ProtoBuf.QualifiedNameTable qualifiedNameTable = this.qualifiedNames;
        if (qualifiedNameTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameResolver", "getQualifiedNameTable"));
        }
        return qualifiedNameTable;
    }

    @NotNull
    public String getString(int index) {
        String string = this.strings.getString(index);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameResolver", "getString"));
        }
        return string;
    }

    @NotNull
    public Name getName(int index) {
        String name = this.strings.getString(index);
        Name name2 = Name.guess(name);
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameResolver", "getName"));
        }
        return name2;
    }

    @NotNull
    public ClassId getClassId(int index) {
        FqName packageFqName;
        ProtoBuf.QualifiedNameTable.QualifiedName fqNameProto = this.qualifiedNames.getQualifiedName(index);
        assert (fqNameProto.getKind() == ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS) : "Not a class fqName: " + fqNameProto.getKind();
        StringBuilder relativeClassName = new StringBuilder();
        ProtoBuf.QualifiedNameTable.QualifiedName packageFqNameProto = this.renderFqName(relativeClassName, fqNameProto, ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS);
        if (packageFqNameProto != null) {
            StringBuilder sb = new StringBuilder();
            ProtoBuf.QualifiedNameTable.QualifiedName mustBeNull = this.renderFqName(sb, packageFqNameProto, ProtoBuf.QualifiedNameTable.QualifiedName.Kind.PACKAGE);
            assert (mustBeNull == null) : "Prefix of an fqName must be all of kind PACKAGE";
            packageFqName = new FqName(sb.toString());
        } else {
            packageFqName = FqName.ROOT;
        }
        ClassId classId = new ClassId(packageFqName, new FqNameUnsafe(relativeClassName.toString()));
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameResolver", "getClassId"));
        }
        return classId;
    }

    @Nullable
    private ProtoBuf.QualifiedNameTable.QualifiedName renderFqName(StringBuilder sb, ProtoBuf.QualifiedNameTable.QualifiedName fqNameProto, ProtoBuf.QualifiedNameTable.QualifiedName.Kind kind) {
        ProtoBuf.QualifiedNameTable.QualifiedName result2 = null;
        if (fqNameProto.hasParentQualifiedName()) {
            ProtoBuf.QualifiedNameTable.QualifiedName parentProto = this.qualifiedNames.getQualifiedName(fqNameProto.getParentQualifiedName());
            if (kind == null || parentProto.getKind() == kind) {
                result2 = this.renderFqName(sb, parentProto, kind);
                sb.append(".");
            } else {
                result2 = parentProto;
            }
        }
        sb.append(this.strings.getString(fqNameProto.getShortName()));
        return result2;
    }

    @NotNull
    public FqName getFqName(int index) {
        ProtoBuf.QualifiedNameTable.QualifiedName qualifiedName = this.qualifiedNames.getQualifiedName(index);
        Name shortName = this.getName(qualifiedName.getShortName());
        if (!qualifiedName.hasParentQualifiedName()) {
            FqName fqName2 = FqName.topLevel(shortName);
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameResolver", "getFqName"));
            }
            return fqName2;
        }
        FqName fqName3 = this.getFqName(qualifiedName.getParentQualifiedName()).child(shortName);
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameResolver", "getFqName"));
        }
        return fqName3;
    }
}

