/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.when;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.when.SwitchCodegenUtil;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public abstract class SwitchCodegen {
    protected final JetWhenExpression expression;
    protected final boolean isStatement;
    protected final ExpressionCodegen codegen;
    protected final BindingContext bindingContext;
    protected final Type subjectType;
    protected final Type resultType;
    protected final InstructionAdapter v;
    protected final NavigableMap<Integer, Label> transitionsTable;
    protected final List<Label> entryLabels;
    protected Label elseLabel;
    protected Label endLabel;
    protected Label defaultLabel;

    public SwitchCodegen(@NotNull JetWhenExpression expression, boolean isStatement, @NotNull ExpressionCodegen codegen) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/when/SwitchCodegen", "<init>"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/when/SwitchCodegen", "<init>"));
        }
        this.transitionsTable = new TreeMap<Integer, Label>();
        this.entryLabels = new ArrayList<Label>();
        this.elseLabel = new Label();
        this.endLabel = new Label();
        this.expression = expression;
        this.isStatement = isStatement;
        this.codegen = codegen;
        this.bindingContext = codegen.getBindingContext();
        this.subjectType = codegen.expressionType(expression.getSubjectExpression());
        this.resultType = isStatement ? Type.VOID_TYPE : codegen.expressionType(expression);
        this.v = codegen.v;
    }

    public void generate() {
        this.prepareConfiguration();
        boolean hasElse = this.expression.getElseExpression() != null;
        this.defaultLabel = hasElse || !this.isStatement ? this.elseLabel : this.endLabel;
        this.generateSubject();
        this.generateSwitchInstructionByTransitionsTable();
        this.generateEntries();
        if (!hasElse && !this.isStatement) {
            this.v.visitLabel(this.elseLabel);
            this.codegen.putUnitInstanceOntoStackForNonExhaustiveWhen(this.expression);
        }
        this.codegen.markLineNumber(this.expression);
        this.v.mark(this.endLabel);
    }

    private void prepareConfiguration() {
        for (JetWhenEntry entry : this.expression.getEntries()) {
            Label entryLabel = new Label();
            for (CompileTimeConstant constant : SwitchCodegenUtil.getConstantsFromEntry(entry, this.bindingContext)) {
                if (constant instanceof NullValue) continue;
                this.processConstant(constant, entryLabel);
            }
            if (entry.isElse()) {
                this.elseLabel = entryLabel;
            }
            this.entryLabels.add(entryLabel);
        }
    }

    protected abstract void processConstant(@NotNull CompileTimeConstant var1, @NotNull Label var2);

    protected void putTransitionOnce(int value, @NotNull Label entryLabel) {
        if (entryLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryLabel", "org/jetbrains/jet/codegen/when/SwitchCodegen", "putTransitionOnce"));
        }
        if (!this.transitionsTable.containsKey(value)) {
            this.transitionsTable.put(value, entryLabel);
        }
    }

    protected void generateSubject() {
        this.codegen.gen(this.expression.getSubjectExpression(), this.subjectType);
    }

    protected void generateNullCheckIfNeeded() {
        JetType subjectJetType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, this.expression.getSubjectExpression());
        assert (subjectJetType != null) : "subject type can't be null (i.e. void)";
        if (TypeUtils.isNullableType(subjectJetType)) {
            int nullEntryIndex = this.findNullEntryIndex(this.expression);
            Label nullLabel = nullEntryIndex == -1 ? this.defaultLabel : this.entryLabels.get(nullEntryIndex);
            Label notNullLabel = new Label();
            this.v.dup();
            this.v.ifnonnull(notNullLabel);
            this.v.pop();
            this.v.goTo(nullLabel);
            this.v.visitLabel(notNullLabel);
        }
    }

    private int findNullEntryIndex(@NotNull JetWhenExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/when/SwitchCodegen", "findNullEntryIndex"));
        }
        int entryIndex = 0;
        for (JetWhenEntry entry : expression.getEntries()) {
            for (CompileTimeConstant constant : SwitchCodegenUtil.getConstantsFromEntry(entry, this.bindingContext)) {
                if (!(constant instanceof NullValue)) continue;
                return entryIndex;
            }
            ++entryIndex;
        }
        return -1;
    }

    private void generateSwitchInstructionByTransitionsTable() {
        boolean useTableSwitch;
        int[] keys = new int[this.transitionsTable.size()];
        Label[] labels = new Label[this.transitionsTable.size()];
        int i = 0;
        for (Map.Entry transition : this.transitionsTable.entrySet()) {
            keys[i] = (Integer)transition.getKey();
            labels[i] = (Label)transition.getValue();
            ++i;
        }
        int nlabels = keys.length;
        int hi = keys[nlabels - 1];
        int lo = keys[0];
        long table_space_cost = 4L + ((long)hi - (long)lo + 1L);
        long table_time_cost = 3L;
        long lookup_space_cost = 3L + 2L * (long)nlabels;
        long lookup_time_cost = nlabels;
        boolean bl = useTableSwitch = nlabels > 0 && table_space_cost + 3L * table_time_cost <= lookup_space_cost + 3L * lookup_time_cost;
        if (!useTableSwitch) {
            this.v.lookupswitch(this.defaultLabel, keys, labels);
            return;
        }
        Object[] sparseLabels = new Label[hi - lo + 1];
        Arrays.fill(sparseLabels, this.defaultLabel);
        for (i = 0; i < keys.length; ++i) {
            sparseLabels[keys[i] - lo] = labels[i];
        }
        this.v.tableswitch(lo, hi, this.defaultLabel, (Label[])sparseLabels);
    }

    protected void generateEntries() {
        Iterator<Label> entryLabelsIterator = this.entryLabels.iterator();
        for (JetWhenEntry entry : this.expression.getEntries()) {
            this.v.visitLabel(entryLabelsIterator.next());
            FrameMap.Mark mark = this.codegen.myFrameMap.mark();
            this.codegen.gen(entry.getExpression(), this.resultType);
            mark.dropTo();
            if (entry.isElse()) continue;
            this.v.goTo(this.endLabel);
        }
    }
}

