/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.CallGenerator;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.DefaultParameterValueLoader;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.JvmCodegenUtil;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.context.PackageContext;
import org.jetbrains.jet.codegen.inline.CapturedParamDesc;
import org.jetbrains.jet.codegen.inline.FieldRemapper;
import org.jetbrains.jet.codegen.inline.InlineCodegenUtil;
import org.jetbrains.jet.codegen.inline.InlineException;
import org.jetbrains.jet.codegen.inline.InlineResult;
import org.jetbrains.jet.codegen.inline.InliningInstructionAdapter;
import org.jetbrains.jet.codegen.inline.LabelOwner;
import org.jetbrains.jet.codegen.inline.LambdaInfo;
import org.jetbrains.jet.codegen.inline.LocalVarRemapper;
import org.jetbrains.jet.codegen.inline.MethodInliner;
import org.jetbrains.jet.codegen.inline.ParameterInfo;
import org.jetbrains.jet.codegen.inline.Parameters;
import org.jetbrains.jet.codegen.inline.ParametersBuilder;
import org.jetbrains.jet.codegen.inline.RootInliningContext;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetLabeledExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodSignature;
import org.jetbrains.jet.lang.types.lang.InlineStrategy;
import org.jetbrains.jet.lang.types.lang.InlineUtil;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class InlineCodegen
implements CallGenerator {
    private final GenerationState state;
    private final JetTypeMapper typeMapper;
    private final SimpleFunctionDescriptor functionDescriptor;
    private final JvmMethodSignature jvmSignature;
    private final JetElement callElement;
    private final MethodContext context;
    private final ExpressionCodegen codegen;
    private final boolean asFunctionInline;
    private final int initialFrameSize;
    private final boolean isSameModule;
    protected final ParametersBuilder invocationParamBuilder;
    protected final Map<Integer, LambdaInfo> expressionMap;
    private LambdaInfo activeLambda;

    public InlineCodegen(@NotNull ExpressionCodegen codegen, @NotNull GenerationState state, @NotNull SimpleFunctionDescriptor functionDescriptor, @NotNull JetElement callElement) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/inline/InlineCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/inline/InlineCodegen", "<init>"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/inline/InlineCodegen", "<init>"));
        }
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/jet/codegen/inline/InlineCodegen", "<init>"));
        }
        this.invocationParamBuilder = ParametersBuilder.newBuilder();
        this.expressionMap = new HashMap<Integer, LambdaInfo>();
        assert (functionDescriptor.getInlineStrategy().isInline()) : "InlineCodegen could inline only inline function but " + functionDescriptor;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.codegen = codegen;
        this.callElement = callElement;
        this.functionDescriptor = functionDescriptor.getOriginal();
        this.initialFrameSize = codegen.getFrameMap().getCurrentSize();
        this.context = (MethodContext)InlineCodegen.getContext(functionDescriptor, state);
        this.jvmSignature = this.typeMapper.mapSignature(functionDescriptor, this.context.getContextKind());
        InlineStrategy inlineStrategy = codegen.getContext().isInlineFunction() ? InlineStrategy.IN_PLACE : functionDescriptor.getInlineStrategy();
        this.asFunctionInline = false;
        this.isSameModule = JvmCodegenUtil.isCallInsideSameModuleAsDeclared(functionDescriptor, codegen.getContext(), state.getOutDirectory());
    }

    @Override
    public void genCallWithoutAssertions(@NotNull CallableMethod callableMethod, @NotNull ExpressionCodegen codegen) {
        if (callableMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/jet/codegen/inline/InlineCodegen", "genCallWithoutAssertions"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/inline/InlineCodegen", "genCallWithoutAssertions"));
        }
        this.genCall(callableMethod, null, false, codegen);
    }

    @Override
    public void genCall(@NotNull CallableMethod callableMethod, @Nullable ResolvedCall<?> resolvedCall, boolean callDefault, @NotNull ExpressionCodegen codegen) {
        if (callableMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/jet/codegen/inline/InlineCodegen", "genCall"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/inline/InlineCodegen", "genCall"));
        }
        MethodNode node = null;
        try {
            node = this.createMethodNode(callDefault);
            this.endCall(this.inlineCall(node));
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (Exception e) {
            boolean generateNodeText = !(e instanceof InlineException);
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(this.codegen.getContext().getContextDescriptor());
            throw new CompilationException("Couldn't inline method call '" + this.functionDescriptor.getName() + "' into \n" + (element != null ? element.getText() : "null psi element " + this.codegen.getContext().getContextDescriptor()) + (generateNodeText ? "\ncause: " + InlineCodegenUtil.getNodeText(node) : ""), e, this.callElement);
        }
    }

    private void endCall(@NotNull InlineResult result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/codegen/inline/InlineCodegen", "endCall"));
        }
        this.leaveTemps();
        this.state.getFactory().removeInlinedClasses(result2.getClassesToRemove());
    }

    @NotNull
    private MethodNode createMethodNode(boolean callDefault) throws ClassNotFoundException, IOException {
        MethodNode node;
        JvmMethodSignature jvmSignature = this.typeMapper.mapSignature(this.functionDescriptor, this.context.getContextKind());
        Method asmMethod = callDefault ? this.typeMapper.mapDefaultMethod(this.functionDescriptor, this.context.getContextKind(), this.context) : jvmSignature.getAsmMethod();
        if (this.functionDescriptor instanceof DeserializedSimpleFunctionDescriptor) {
            VirtualFile file = InlineCodegenUtil.getVirtualFileForCallable((DeserializedSimpleFunctionDescriptor)this.functionDescriptor, this.state);
            node = InlineCodegenUtil.getMethodNode(file.contentsToByteArray(), asmMethod.getName(), asmMethod.getDescriptor());
            if (node == null) {
                throw new RuntimeException("Couldn't obtain compiled function body for " + InlineCodegen.descriptorName(this.functionDescriptor));
            }
        } else {
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(this.functionDescriptor);
            if (element == null) {
                throw new RuntimeException("Couldn't find declaration for function " + InlineCodegen.descriptorName(this.functionDescriptor));
            }
            node = new MethodNode(327680, AsmUtil.getMethodAsmFlags(this.functionDescriptor, this.context.getContextKind()) | (callDefault ? 8 : 0), asmMethod.getName(), asmMethod.getDescriptor(), jvmSignature.getGenericsSignature(), null);
            MethodVisitor maxCalcAdapter = InlineCodegenUtil.wrapWithMaxLocalCalc(node);
            MethodContext methodContext = this.context.getParentContext().intoFunction(this.functionDescriptor);
            MemberCodegen<?> parentCodegen = this.codegen.getParentCodegen();
            if (callDefault) {
                boolean isStatic = AsmUtil.isStaticMethod(this.context.getContextKind(), this.functionDescriptor);
                FunctionCodegen.generateDefaultImplBody(methodContext, jvmSignature, this.functionDescriptor, isStatic, maxCalcAdapter, DefaultParameterValueLoader.DEFAULT, (JetNamedFunction)element, parentCodegen, this.state);
            } else {
                FunctionCodegen.generateMethodBody(maxCalcAdapter, this.functionDescriptor, methodContext, jvmSignature, new FunctionGenerationStrategy.FunctionDefault(this.state, this.functionDescriptor, (JetDeclarationWithBody)element), parentCodegen);
            }
            maxCalcAdapter.visitMaxs(-1, -1);
            maxCalcAdapter.visitEnd();
        }
        MethodNode methodNode = node;
        if (methodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/InlineCodegen", "createMethodNode"));
        }
        return methodNode;
    }

    private InlineResult inlineCall(MethodNode node) {
        this.generateClosuresBodies();
        this.putClosureParametersOnStack();
        InlineCodegenUtil.addInlineMarker(this.codegen.v, true);
        Parameters parameters = this.invocationParamBuilder.buildParameters();
        RootInliningContext info = new RootInliningContext(this.expressionMap, this.state, this.codegen.getInlineNameGenerator().subGenerator(this.functionDescriptor.getName().asString()), this.codegen.getContext(), this.callElement, this.codegen.getParentCodegen().getClassName());
        MethodInliner inliner = new MethodInliner(node, parameters, info, new FieldRemapper(null, null, parameters), this.isSameModule, "Method inlining " + this.callElement.getText());
        LocalVarRemapper remapper = new LocalVarRemapper(parameters, this.initialFrameSize);
        MethodNode adapter = InlineCodegenUtil.createEmptyMethodNode();
        InlineResult result2 = inliner.doInline(adapter, remapper, true, LabelOwner.SKIP_ALL);
        LabelOwner labelOwner = new LabelOwner(){
            final CallableMemberDescriptor descriptor;
            final boolean isLambda;
            {
                this.descriptor = (CallableMemberDescriptor)InlineCodegen.this.codegen.getContext().getContextDescriptor();
                this.isLambda = CodegenBinding.isLocalFunOrLambda(this.descriptor) && this.descriptor.getName().isSpecial();
            }

            @Override
            public boolean isMyLabel(@NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/inline/InlineCodegen$1", "isMyLabel"));
                }
                if ("$$$$$ROOT$$$$$".equals(name)) {
                    return !this.isLambda;
                }
                return this.descriptor.getName().asString().equals(name);
            }
        };
        List<MethodInliner.ExternalFinallyBlockInfo> infos = MethodInliner.processReturns(adapter, labelOwner, true, null);
        this.generateAndInsertFinallyBlocks(adapter, infos);
        adapter.accept(new InliningInstructionAdapter(this.codegen.v));
        InlineCodegenUtil.addInlineMarker(this.codegen.v, false);
        return result2;
    }

    private void generateClosuresBodies() {
        for (LambdaInfo info : this.expressionMap.values()) {
            info.setNode(this.generateLambdaBody(info));
        }
    }

    private MethodNode generateLambdaBody(LambdaInfo info) {
        JetFunctionLiteral declaration = info.getFunctionLiteral();
        FunctionDescriptor descriptor = info.getFunctionDescriptor();
        MethodContext parentContext = this.codegen.getContext();
        MethodContext context2 = parentContext.intoClosure(descriptor, this.codegen, this.typeMapper).intoInlinedLambda(descriptor);
        JvmMethodSignature jvmMethodSignature = this.typeMapper.mapSignature(descriptor);
        Method asmMethod = jvmMethodSignature.getAsmMethod();
        MethodNode methodNode = new MethodNode(327680, AsmUtil.getMethodAsmFlags(descriptor, context2.getContextKind()), asmMethod.getName(), asmMethod.getDescriptor(), jvmMethodSignature.getGenericsSignature(), null);
        MethodVisitor adapter = InlineCodegenUtil.wrapWithMaxLocalCalc(methodNode);
        FunctionCodegen.generateMethodBody(adapter, descriptor, context2, jvmMethodSignature, new FunctionGenerationStrategy.FunctionDefault(this.state, descriptor, declaration), this.codegen.getParentCodegen());
        adapter.visitMaxs(-1, -1);
        return methodNode;
    }

    @Override
    public void afterParameterPut(@NotNull Type type, @Nullable StackValue stackValue, @Nullable ValueParameterDescriptor valueParameterDescriptor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/inline/InlineCodegen", "afterParameterPut"));
        }
        this.putCapturedInLocal(type, stackValue, valueParameterDescriptor, -1);
    }

    private void putCapturedInLocal(@NotNull Type type, @Nullable StackValue stackValue, @Nullable ValueParameterDescriptor valueParameterDescriptor, int capturedParamIndex) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/inline/InlineCodegen", "putCapturedInLocal"));
        }
        if (!this.asFunctionInline && Type.VOID_TYPE != type) {
            ParameterInfo info;
            StackValue remappedIndex;
            boolean couldBeRemapped = !this.shouldPutValue(type, stackValue, valueParameterDescriptor);
            StackValue stackValue2 = remappedIndex = couldBeRemapped ? stackValue : null;
            if (capturedParamIndex >= 0) {
                CapturedParamDesc capturedParamInfoInLambda = this.activeLambda.getCapturedVars().get(capturedParamIndex);
                info = this.invocationParamBuilder.addCapturedParam(capturedParamInfoInLambda, capturedParamInfoInLambda.getFieldName());
                info.setRemapValue(remappedIndex);
            } else {
                info = this.invocationParamBuilder.addNextParameter(type, false, remappedIndex);
            }
            this.putParameterOnStack(info);
        }
    }

    public boolean shouldPutValue(@NotNull Type type, @Nullable StackValue stackValue, @Nullable ValueParameterDescriptor descriptor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/inline/InlineCodegen", "shouldPutValue"));
        }
        if (stackValue == null) {
            return true;
        }
        if (AsmUtil.isPrimitive(type) != AsmUtil.isPrimitive(stackValue.type)) {
            return true;
        }
        if (stackValue instanceof StackValue.Local) {
            return false;
        }
        return !(stackValue instanceof StackValue.Composed) || !this.codegen.getContext().isInliningLambda() || !(this.codegen.getContext().getContextDescriptor() instanceof AnonymousFunctionDescriptor) || descriptor == null || InlineUtil.hasNoinlineAnnotation(descriptor);
    }

    private void putParameterOnStack(ParameterInfo ... infos) {
        ParameterInfo info;
        int i;
        int[] index = new int[infos.length];
        for (i = 0; i < infos.length; ++i) {
            info = infos[i];
            index[i] = !info.isSkippedOrRemapped() ? this.codegen.getFrameMap().enterTemp(info.getType()) : -1;
        }
        for (i = infos.length - 1; i >= 0; --i) {
            info = infos[i];
            if (info.isSkippedOrRemapped()) continue;
            Type type = info.type;
            StackValue.local(index[i], type).store(type, this.codegen.v);
        }
    }

    @Override
    public void putHiddenParams() {
        List<JvmMethodParameterSignature> valueParameters = this.jvmSignature.getValueParameters();
        if (!InlineCodegen.isStaticMethod(this.functionDescriptor, this.context)) {
            this.invocationParamBuilder.addNextParameter(AsmTypeConstants.OBJECT_TYPE, false, null);
        }
        for (JvmMethodParameterSignature param : valueParameters) {
            if (param.getKind() == JvmMethodParameterKind.VALUE) break;
            this.invocationParamBuilder.addNextParameter(param.getAsmType(), false, null);
        }
        List<ParameterInfo> infos = this.invocationParamBuilder.listNotCaptured();
        this.putParameterOnStack(infos.toArray(new ParameterInfo[infos.size()]));
    }

    public void leaveTemps() {
        FrameMap frameMap = this.codegen.getFrameMap();
        List<ParameterInfo> infos = this.invocationParamBuilder.listAllParams();
        ListIterator<ParameterInfo> iterator2 = infos.listIterator(infos.size());
        while (iterator2.hasPrevious()) {
            ParameterInfo param = iterator2.previous();
            if (param.isSkippedOrRemapped()) continue;
            frameMap.leaveTemp(param.type);
        }
    }

    public static boolean isInliningClosure(JetExpression expression, ValueParameterDescriptor valueParameterDescriptora) {
        JetExpression deparenthesize = JetPsiUtil.deparenthesize(expression);
        return deparenthesize instanceof JetFunctionLiteralExpression && !InlineUtil.hasNoinlineAnnotation(valueParameterDescriptora);
    }

    public void rememberClosure(JetExpression expression, Type type) {
        JetFunctionLiteralExpression lambda = (JetFunctionLiteralExpression)JetPsiUtil.deparenthesize(expression);
        assert (lambda != null) : "Couldn't find lambda in " + expression.getText();
        String labelNameIfPresent = null;
        PsiElement parent = lambda.getParent();
        if (parent instanceof JetLabeledExpression) {
            labelNameIfPresent = ((JetLabeledExpression)parent).getLabelName();
        }
        LambdaInfo info = new LambdaInfo(lambda, this.typeMapper, labelNameIfPresent);
        ParameterInfo closureInfo = this.invocationParamBuilder.addNextParameter(type, true, null);
        closureInfo.setLambda(info);
        this.expressionMap.put(closureInfo.getIndex(), info);
    }

    private void putClosureParametersOnStack() {
        Iterator<LambdaInfo> i$ = this.expressionMap.values().iterator();
        while (i$.hasNext()) {
            LambdaInfo next;
            this.activeLambda = next = i$.next();
            this.codegen.pushClosureOnStack(next.getClassDescriptor(), true, this);
        }
        this.activeLambda = null;
    }

    public static CodegenContext getContext(DeclarationDescriptor descriptor, GenerationState state) {
        if (descriptor instanceof PackageFragmentDescriptor) {
            return new PackageContext((PackageFragmentDescriptor)descriptor, null, null);
        }
        CodegenContext parent = InlineCodegen.getContext(descriptor.getContainingDeclaration(), state);
        if (descriptor instanceof ClassDescriptor) {
            OwnerKind kind = DescriptorUtils.isTrait(descriptor) ? OwnerKind.TRAIT_IMPL : OwnerKind.IMPLEMENTATION;
            return parent.intoClass((ClassDescriptor)descriptor, kind, state);
        }
        if (descriptor instanceof FunctionDescriptor) {
            return parent.intoFunction((FunctionDescriptor)descriptor);
        }
        throw new IllegalStateException("Couldn't build context for " + InlineCodegen.descriptorName(descriptor));
    }

    private static boolean isStaticMethod(FunctionDescriptor functionDescriptor, MethodContext context2) {
        return (AsmUtil.getMethodAsmFlags(functionDescriptor, context2.getContextKind()) & 8) != 0;
    }

    private static String descriptorName(DeclarationDescriptor descriptor) {
        return DescriptorRenderer.SHORT_NAMES_IN_TYPES.render(descriptor);
    }

    @Override
    public void genValueAndPut(@NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull JetExpression argumentExpression, @NotNull Type parameterType) {
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/jet/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (argumentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpression", "org/jetbrains/jet/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/jet/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (InlineCodegen.isInliningClosure(argumentExpression, valueParameterDescriptor)) {
            this.rememberClosure(argumentExpression, parameterType);
        } else {
            StackValue value = this.codegen.gen(argumentExpression);
            this.putValueIfNeeded(valueParameterDescriptor, parameterType, value);
        }
    }

    @Override
    public void putValueIfNeeded(@Nullable ValueParameterDescriptor valueParameterDescriptor, @NotNull Type parameterType, @NotNull StackValue value) {
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/jet/codegen/inline/InlineCodegen", "putValueIfNeeded"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/codegen/inline/InlineCodegen", "putValueIfNeeded"));
        }
        if (this.shouldPutValue(parameterType, value, valueParameterDescriptor)) {
            value.put(parameterType, this.codegen.v);
        }
        this.afterParameterPut(parameterType, value, valueParameterDescriptor);
    }

    @Override
    public void putCapturedValueOnStack(@NotNull StackValue stackValue, @NotNull Type valueType, int paramIndex) {
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/jet/codegen/inline/InlineCodegen", "putCapturedValueOnStack"));
        }
        if (valueType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "org/jetbrains/jet/codegen/inline/InlineCodegen", "putCapturedValueOnStack"));
        }
        if (this.shouldPutValue(stackValue.type, stackValue, null)) {
            stackValue.put(stackValue.type, this.codegen.v);
        }
        this.putCapturedInLocal(stackValue.type, stackValue, null, paramIndex);
    }

    public void generateAndInsertFinallyBlocks(MethodNode intoNode, List<MethodInliner.ExternalFinallyBlockInfo> insertPoints) {
        if (!this.codegen.hasFinallyBlocks()) {
            return;
        }
        for (MethodInliner.ExternalFinallyBlockInfo insertPoint : insertPoints) {
            MethodNode finallyNode = InlineCodegenUtil.createEmptyMethodNode();
            ExpressionCodegen finallyCodegen = new ExpressionCodegen(finallyNode, this.codegen.getFrameMap(), this.codegen.getReturnType(), this.codegen.getContext(), this.codegen.getState(), this.codegen.getParentCodegen());
            finallyCodegen.addBlockStackElementsForNonLocalReturns(this.codegen.getBlockStackElements());
            finallyCodegen.generateFinallyBlocksIfNeeded(insertPoint.returnType);
            InlineCodegenUtil.insertNodeBefore(finallyNode, intoNode, insertPoint.beforeIns);
        }
    }
}

