/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.resolve.java.descriptor.SamAdapterDescriptor;

public class SamCodegenUtil {
    @Nullable
    public static FunctionDescriptor getOriginalIfSamAdapter(@NotNull FunctionDescriptor fun) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/jet/codegen/SamCodegenUtil", "getOriginalIfSamAdapter"));
        }
        FunctionDescriptor original = fun.getOriginal();
        if (original instanceof SamAdapterDescriptor) {
            return ((SamAdapterDescriptor)original).getOriginForSam();
        }
        if (original.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            for (FunctionDescriptor functionDescriptor : original.getOverriddenDescriptors()) {
                FunctionDescriptor originalIfSamAdapter = SamCodegenUtil.getOriginalIfSamAdapter(functionDescriptor);
                if (originalIfSamAdapter == null) continue;
                return originalIfSamAdapter;
            }
        }
        return null;
    }

    private SamCodegenUtil() {
    }
}

