/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.CallGenerator;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.DefaultParameterValueLoader;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.JvmSerializationBindings;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.ParentCodegenAware;
import org.jetbrains.jet.codegen.PlatformStaticGenerator;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.bridges.Bridge;
import org.jetbrains.jet.codegen.bridges.BridgesPackage;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.context.PackageFacadeContext;
import org.jetbrains.jet.codegen.optimization.OptimizationMethodVisitor;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.annotations.AnnotationsPackage;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.JavaClassValue;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.diagnostics.DiagnosticsPackage;
import org.jetbrains.jet.lang.resolve.java.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodSignature;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.Approximation;
import org.jetbrains.jet.lang.types.TypesPackage;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class FunctionCodegen
extends ParentCodegenAware {
    private final CodegenContext owner;
    private final ClassBuilder v;

    public FunctionCodegen(@NotNull CodegenContext owner, @NotNull ClassBuilder v, @NotNull GenerationState state, MemberCodegen<?> parentCodegen) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/codegen/FunctionCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/FunctionCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/FunctionCodegen", "<init>"));
        }
        super(state, parentCodegen);
        this.owner = owner;
        this.v = v;
    }

    public void gen(@NotNull JetNamedFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/FunctionCodegen", "gen"));
        }
        SimpleFunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, function);
        assert (functionDescriptor != null) : "No descriptor for function " + function.getText() + "\n" + "in " + function.getContainingFile().getVirtualFile();
        OwnerKind kind = this.owner.getContextKind();
        JvmMethodSignature method = this.typeMapper.mapSignature(functionDescriptor, kind);
        if (kind != OwnerKind.TRAIT_IMPL || function.hasBody()) {
            this.generateMethod(DiagnosticsPackage.OtherOrigin(function, functionDescriptor), method, functionDescriptor, new FunctionGenerationStrategy.FunctionDefault(this.state, functionDescriptor, function));
        }
        this.generateDefaultIfNeeded(this.owner.intoFunction(functionDescriptor), method, functionDescriptor, kind, DefaultParameterValueLoader.DEFAULT, function);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull JvmMethodSignature jvmSignature, @NotNull FunctionDescriptor functionDescriptor, @NotNull FunctionGenerationStrategy strategy) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        this.generateMethod(origin, jvmSignature, functionDescriptor, this.owner.intoFunction(functionDescriptor), strategy);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull JvmMethodSignature jvmSignature, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext methodContext, @NotNull FunctionGenerationStrategy strategy) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        OwnerKind methodContextKind = methodContext.getContextKind();
        Method asmMethod = jvmSignature.getAsmMethod();
        MethodVisitor mv = this.v.newMethod(origin, AsmUtil.getMethodAsmFlags(functionDescriptor, methodContextKind), asmMethod.getName(), asmMethod.getDescriptor(), jvmSignature.getGenericsSignature(), FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper));
        if (this.owner instanceof PackageFacadeContext) {
            Type ownerType = ((PackageFacadeContext)this.owner).getDelegateToClassType();
            this.v.getSerializationBindings().put(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, functionDescriptor, AsmUtil.shortNameByAsmType(ownerType));
        } else {
            this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, functionDescriptor, asmMethod);
        }
        AnnotationCodegen.forMethod(mv, this.typeMapper).genAnnotations(functionDescriptor, asmMethod.getReturnType());
        this.generateParameterAnnotations(functionDescriptor, mv, jvmSignature);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.LIGHT_CLASSES) {
            FunctionCodegen.generateJetValueParameterAnnotations(mv, functionDescriptor, jvmSignature);
        }
        this.generateBridges(functionDescriptor);
        if (AnnotationsPackage.isPlatformStaticInClassObject(functionDescriptor)) {
            MemberCodegen<?> codegen = this.getParentCodegen().getParentCodegen();
            ((ImplementationBodyCodegen)codegen).addAdditionalTask(new PlatformStaticGenerator(functionDescriptor, origin, this.state));
        }
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES || AsmUtil.isAbstractMethod(functionDescriptor, methodContextKind)) {
            FunctionCodegen.generateLocalVariableTable(mv, jvmSignature, functionDescriptor, FunctionCodegen.getThisTypeForFunction(functionDescriptor, methodContext, this.typeMapper), new Label(), new Label(), methodContextKind);
            mv.visitEnd();
            return;
        }
        FunctionCodegen.generateMethodBody(mv, functionDescriptor, methodContext, jvmSignature, strategy, this.getParentCodegen());
        FunctionCodegen.endVisit(mv, null, origin.getElement());
        methodContext.recordSyntheticAccessorIfNeeded(functionDescriptor, this.bindingContext);
    }

    private void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        Iterator<ValueParameterDescriptor> iterator2 = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getValueParameters();
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            JvmMethodParameterSignature parameterSignature = kotlinParameterTypes.get(i);
            JvmMethodParameterKind kind = parameterSignature.getKind();
            if (kind.isSkippedInGenericSignature()) {
                this.markEnumOrInnerConstructorParameterAsSynthetic(mv, i);
                continue;
            }
            if (kind != JvmMethodParameterKind.VALUE) continue;
            ValueParameterDescriptor parameter = iterator2.next();
            this.v.getSerializationBindings().put(JvmSerializationBindings.INDEX_FOR_VALUE_PARAMETER, parameter, i);
            AnnotationCodegen.forParameter(i, mv, this.typeMapper).genAnnotations(parameter, parameterSignature.getAsmType());
        }
    }

    private static void generateJetValueParameterAnnotations(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull JvmMethodSignature jvmSignature) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateJetValueParameterAnnotations"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateJetValueParameterAnnotations"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateJetValueParameterAnnotations"));
        }
        Iterator<ValueParameterDescriptor> descriptors = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getValueParameters();
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            boolean nullableType;
            String name;
            JvmMethodParameterKind kind = kotlinParameterTypes.get(i).getKind();
            if (kind.isSkippedInGenericSignature()) continue;
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor descriptor = descriptors.next();
                name = descriptor.getName().asString();
                nullableType = descriptor.getType().isNullable();
            } else {
                ReceiverParameterDescriptor receiver;
                String lowercaseKind = kind.name().toLowerCase();
                name = FunctionCodegen.needIndexForVar(kind) ? "$" + lowercaseKind + "$" + i : "$" + lowercaseKind;
                nullableType = kind == JvmMethodParameterKind.RECEIVER ? (receiver = functionDescriptor.getExtensionReceiverParameter()) == null || receiver.getType().isNullable() : true;
            }
            AnnotationVisitor av = mv.visitParameterAnnotation(i, AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_JET_VALUE_PARAMETER_ANNOTATION), true);
            if (av == null) continue;
            av.visit("name", name);
            if (nullableType) {
                av.visit("type", "?");
            }
            av.visitEnd();
        }
    }

    private void markEnumOrInnerConstructorParameterAsSynthetic(MethodVisitor mv, int i) {
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        AnnotationVisitor av = mv.visitParameterAnnotation(i, "Ljava/lang/Synthetic;", true);
        if (av != null) {
            av.visitEnd();
        }
    }

    @Nullable
    private static Type getThisTypeForFunction(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context2, @NotNull JetTypeMapper typeMapper) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        ReceiverParameterDescriptor dispatchReceiver = functionDescriptor.getDispatchReceiverParameter();
        if (functionDescriptor instanceof ConstructorDescriptor) {
            return typeMapper.mapType(functionDescriptor);
        }
        if (dispatchReceiver != null) {
            return typeMapper.mapType(dispatchReceiver.getType());
        }
        if (DescriptorUtils.isFunctionLiteral(functionDescriptor) || CodegenBinding.isLocalNamedFun(functionDescriptor)) {
            return typeMapper.mapType(context2.getThisDescriptor());
        }
        return null;
    }

    public static void generateMethodBody(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context2, @NotNull JvmMethodSignature signature, @NotNull FunctionGenerationStrategy strategy, @NotNull MemberCodegen<?> parentCodegen) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        mv.visitCode();
        Label methodBegin = new Label();
        mv.visitLabel(methodBegin);
        JetTypeMapper typeMapper = parentCodegen.typeMapper;
        if (context2.getParentContext() instanceof PackageFacadeContext) {
            FunctionCodegen.generateStaticDelegateMethodBody(mv, signature.getAsmMethod(), (PackageFacadeContext)context2.getParentContext());
        } else {
            FrameMap frameMap = FunctionCodegen.createFrameMap(parentCodegen.state, functionDescriptor, signature, AsmUtil.isStaticMethod(context2.getContextKind(), functionDescriptor));
            Label methodEntry = new Label();
            mv.visitLabel(methodEntry);
            context2.setMethodStartLabel(methodEntry);
            if (!JetTypeMapper.isAccessor(functionDescriptor)) {
                AsmUtil.genNotNullAssertionsForParameters(new InstructionAdapter(mv), parentCodegen.state, functionDescriptor, frameMap);
            }
            strategy.generateBody(mv, frameMap, signature, context2, parentCodegen);
        }
        Label methodEnd = new Label();
        mv.visitLabel(methodEnd);
        Type thisType = FunctionCodegen.getThisTypeForFunction(functionDescriptor, context2, typeMapper);
        FunctionCodegen.generateLocalVariableTable(mv, signature, functionDescriptor, thisType, methodBegin, methodEnd, context2.getContextKind());
    }

    private static void generateLocalVariableTable(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @NotNull FunctionDescriptor functionDescriptor, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, @NotNull OwnerKind ownerKind) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (jvmMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmMethodSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (methodBegin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodBegin", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (methodEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodEnd", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (ownerKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerKind", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        Iterator<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> params = jvmMethodSignature.getValueParameters();
        int shift = 0;
        boolean isStatic = AsmUtil.isStaticMethod(ownerKind, functionDescriptor);
        if (!isStatic) {
            if (thisType != null) {
                mv.visitLocalVariable("this", thisType.getDescriptor(), null, methodBegin, methodEnd, shift);
            }
            ++shift;
        }
        for (int i = 0; i < params.size(); ++i) {
            String parameterName;
            JvmMethodParameterSignature param = params.get(i);
            JvmMethodParameterKind kind = param.getKind();
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor parameter = valueParameters.next();
                parameterName = parameter.getName().asString();
            } else {
                String lowercaseKind = kind.name().toLowerCase();
                parameterName = FunctionCodegen.needIndexForVar(kind) ? "$" + lowercaseKind + "$" + i : "$" + lowercaseKind;
            }
            Type type = param.getAsmType();
            mv.visitLocalVariable(parameterName, type.getDescriptor(), null, methodBegin, methodEnd, shift);
            shift += type.getSize();
        }
    }

    private static void generateStaticDelegateMethodBody(@NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull PackageFacadeContext context2) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateStaticDelegateMethodBody"));
        }
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/jet/codegen/FunctionCodegen", "generateStaticDelegateMethodBody"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/FunctionCodegen", "generateStaticDelegateMethodBody"));
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        Type[] argTypes = asmMethod.getArgumentTypes();
        Label label = new Label();
        iv.visitLabel(label);
        iv.visitLineNumber(1, label);
        int k = 0;
        for (Type argType : argTypes) {
            iv.load(k, argType);
            k += argType.getSize();
        }
        iv.invokestatic(context2.getDelegateToClassType().getInternalName(), asmMethod.getName(), asmMethod.getDescriptor(), false);
        iv.areturn(asmMethod.getReturnType());
    }

    private static boolean needIndexForVar(JvmMethodParameterKind kind) {
        return kind == JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE || kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || kind == JvmMethodParameterKind.SUPER_CALL_PARAM;
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description, @Nullable PsiElement method) {
        try {
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            String bytecode = FunctionCodegen.renderByteCodeIfAvailable(mv);
            throw new CompilationException("wrong code generated" + (description != null ? " for " + description : "") + t.getClass().getName() + " " + t.getMessage() + (bytecode != null ? "\nbytecode:\n" + bytecode : ""), t, method);
        }
    }

    private static String renderByteCodeIfAvailable(MethodVisitor mv) {
        String bytecode = null;
        if (mv instanceof OptimizationMethodVisitor) {
            mv = ((OptimizationMethodVisitor)mv).getTraceMethodVisitorIfPossible();
        }
        if (mv instanceof TraceMethodVisitor) {
            TraceMethodVisitor traceMethodVisitor = (TraceMethodVisitor)mv;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            traceMethodVisitor.p.print(pw);
            pw.close();
            bytecode = sw.toString();
        }
        return bytecode;
    }

    public void generateBridges(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateBridges"));
        }
        if (descriptor instanceof ConstructorDescriptor) {
            return;
        }
        if (this.owner.getContextKind() == OwnerKind.TRAIT_IMPL) {
            return;
        }
        if (DescriptorUtils.isTrait(descriptor.getContainingDeclaration())) {
            return;
        }
        if (FunctionCodegen.isMethodOfAny(descriptor)) {
            return;
        }
        if (CallResolverUtil.isOrOverridesSynthesized(descriptor)) {
            return;
        }
        Set<Bridge<Method>> bridgesToGenerate = BridgesPackage.generateBridgesForFunctionDescriptor(descriptor, new Function1<FunctionDescriptor, Method>(){

            @Override
            public Method invoke(FunctionDescriptor descriptor) {
                return FunctionCodegen.this.typeMapper.mapSignature(descriptor).getAsmMethod();
            }
        });
        if (!bridgesToGenerate.isEmpty()) {
            PsiElement origin = descriptor.getKind() == CallableMemberDescriptor.Kind.DECLARATION ? DescriptorToSourceUtils.callableDescriptorToDeclaration(descriptor) : null;
            for (Bridge<Method> bridge : bridgesToGenerate) {
                this.generateBridge(origin, descriptor, bridge.getFrom(), bridge.getTo());
            }
        }
    }

    private static boolean isMethodOfAny(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "isMethodOfAny"));
        }
        String name = descriptor.getName().asString();
        List<ValueParameterDescriptor> parameters = descriptor.getValueParameters();
        if (parameters.isEmpty()) {
            return name.equals("hashCode") || name.equals("toString");
        }
        if (parameters.size() == 1 && name.equals("equals")) {
            ValueParameterDescriptor parameter = parameters.get(0);
            return ((Object)parameter.getType()).equals(KotlinBuiltIns.getInstance().getNullableAnyType());
        }
        return false;
    }

    @NotNull
    private static String[] getThrownExceptions(@NotNull FunctionDescriptor function, final @NotNull JetTypeMapper mapper) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "org/jetbrains/jet/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        AnnotationDescriptor annotation = function.getAnnotations().findAnnotation(new FqName("kotlin.throws"));
        if (annotation == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Collection<CompileTimeConstant<?>> values = annotation.getAllValueArguments().values();
        if (values.isEmpty()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        CompileTimeConstant<?> value = values.iterator().next();
        if (!(value instanceof ArrayValue)) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayValue arrayValue = (ArrayValue)value;
        List<String> strings2 = ContainerUtil.mapNotNull(arrayValue.getValue(), new Function<CompileTimeConstant<?>, String>(){

            @Override
            public String fun(CompileTimeConstant<?> constant) {
                if (constant instanceof JavaClassValue) {
                    JavaClassValue classValue = (JavaClassValue)constant;
                    ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType(classValue.getValue());
                    return mapper.mapClass(classDescriptor).getInternalName();
                }
                return null;
            }
        });
        String[] stringArray = ArrayUtil.toStringArray(strings2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        return stringArray;
    }

    static void generateConstructorWithoutParametersIfNeeded(@NotNull GenerationState state, @NotNull CallableMethod method, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull ClassBuilder classBuilder, @NotNull JetClassOrObject classOrObject) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilder", "org/jetbrains/jet/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (!FunctionCodegen.isEmptyConstructorNeeded(state.getBindingContext(), constructorDescriptor, classOrObject)) {
            return;
        }
        int flags = AsmUtil.getVisibilityAccessFlag(constructorDescriptor);
        MethodVisitor mv = classBuilder.newMethod(DiagnosticsPackage.OtherOrigin(constructorDescriptor), flags, "<init>", "()V", null, FunctionCodegen.getThrownExceptions(constructorDescriptor, state.getTypeMapper()));
        if (state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        InstructionAdapter v = new InstructionAdapter(mv);
        mv.visitCode();
        Type methodOwner = method.getOwner();
        v.load(0, methodOwner);
        int mask = 0;
        ArrayList<Integer> masks = new ArrayList<Integer>(1);
        for (ValueParameterDescriptor parameterDescriptor : constructorDescriptor.getValueParameters()) {
            Type paramType = state.getTypeMapper().mapType(parameterDescriptor.getType());
            AsmUtil.pushDefaultValueOnStack(paramType, v);
            int i = parameterDescriptor.getIndex();
            if (i != 0 && i % 32 == 0) {
                masks.add(mask);
                mask = 0;
            }
            mask |= 1 << i % 32;
        }
        masks.add(mask);
        Iterator<ValueParameterDescriptor> i$ = masks.iterator();
        while (i$.hasNext()) {
            int m = (Integer)((Object)i$.next());
            v.iconst(m);
        }
        String desc = JetTypeMapper.getDefaultDescriptor(method.getAsmMethod(), false);
        v.invokespecial(methodOwner.getInternalName(), "<init>", desc, false);
        v.areturn(Type.VOID_TYPE);
        FunctionCodegen.endVisit(mv, "default constructor for " + methodOwner.getInternalName(), classOrObject);
    }

    void generateDefaultIfNeeded(@NotNull MethodContext owner, @NotNull JvmMethodSignature signature, @NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable JetNamedFunction function) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (loadStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadStrategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        DeclarationDescriptor contextClass = ((CallableMemberDescriptor)owner.getContextDescriptor()).getContainingDeclaration();
        if (kind != OwnerKind.TRAIT_IMPL && contextClass instanceof ClassDescriptor && ((ClassDescriptor)contextClass).getKind() == ClassKind.TRAIT) {
            return;
        }
        if (!FunctionCodegen.isDefaultNeeded(functionDescriptor)) {
            return;
        }
        Method jvmSignature = signature.getAsmMethod();
        int flags = AsmUtil.getVisibilityAccessFlag(functionDescriptor) | AsmUtil.getDeprecatedAccessFlag(functionDescriptor);
        boolean isConstructor = "<init>".equals(jvmSignature.getName());
        Method defaultMethod = this.typeMapper.mapDefaultMethod(functionDescriptor, kind, owner);
        MethodVisitor mv = this.v.newMethod(DiagnosticsPackage.Synthetic(function, functionDescriptor), flags | (isConstructor ? 0 : 8), defaultMethod.getName(), defaultMethod.getDescriptor(), null, FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper));
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            if (this.owner instanceof PackageFacadeContext) {
                mv.visitCode();
                FunctionCodegen.generateStaticDelegateMethodBody(mv, defaultMethod, (PackageFacadeContext)this.owner);
                FunctionCodegen.endVisit(mv, "default method delegation", DescriptorToSourceUtils.callableDescriptorToDeclaration(functionDescriptor));
            } else {
                this.generateDefaultImpl(owner, signature, functionDescriptor, AsmUtil.isStaticMethod(kind, functionDescriptor), mv, loadStrategy, function);
            }
        }
    }

    private void generateDefaultImpl(@NotNull MethodContext methodContext, @NotNull JvmMethodSignature signature, @NotNull FunctionDescriptor functionDescriptor, boolean isStatic, @NotNull MethodVisitor mv, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable JetNamedFunction function) {
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        if (loadStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadStrategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        mv.visitCode();
        FunctionCodegen.generateDefaultImplBody(methodContext, signature, functionDescriptor, isStatic, mv, loadStrategy, function, this.getParentCodegen(), this.state);
        FunctionCodegen.endVisit(mv, "default method", DescriptorToSourceUtils.callableDescriptorToDeclaration(functionDescriptor));
    }

    public static void generateDefaultImplBody(@NotNull MethodContext methodContext, @NotNull JvmMethodSignature signature, @NotNull FunctionDescriptor functionDescriptor, boolean isStatic, @NotNull MethodVisitor mv, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable JetNamedFunction function, @NotNull MemberCodegen<?> parentCodegen, @NotNull GenerationState state) {
        int capturedArgumentsCount;
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (loadStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadStrategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        FrameMap frameMap = FunctionCodegen.createFrameMap(state, functionDescriptor, signature, isStatic);
        ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, signature.getReturnType(), methodContext, state, parentCodegen);
        CallGenerator generator = codegen.getOrCreateCallGenerator(functionDescriptor, function);
        FunctionCodegen.loadExplicitArgumentsOnStack(AsmTypeConstants.OBJECT_TYPE, isStatic, signature, generator);
        List<JvmMethodParameterSignature> mappedParameters = signature.getValueParameters();
        for (capturedArgumentsCount = 0; capturedArgumentsCount < mappedParameters.size() && mappedParameters.get(capturedArgumentsCount).getKind() != JvmMethodParameterKind.VALUE; ++capturedArgumentsCount) {
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        int maskIndex = 0;
        List<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters();
        for (int index = 0; index < valueParameters.size(); ++index) {
            if (index % 32 == 0) {
                maskIndex = frameMap.enterTemp(Type.INT_TYPE);
            }
            ValueParameterDescriptor parameterDescriptor = valueParameters.get(index);
            Type type = mappedParameters.get(capturedArgumentsCount + index).getAsmType();
            int parameterIndex = frameMap.getIndex(parameterDescriptor);
            if (parameterDescriptor.declaresDefaultValue()) {
                iv.load(maskIndex, Type.INT_TYPE);
                iv.iconst(1 << index % 32);
                iv.and(Type.INT_TYPE);
                Label loadArg = new Label();
                iv.ifeq(loadArg);
                loadStrategy.putValueOnStack(parameterDescriptor, codegen);
                iv.store(parameterIndex, type);
                iv.mark(loadArg);
            }
            generator.putValueIfNeeded(parameterDescriptor, type, StackValue.local(parameterIndex, type));
        }
        CallableMethod method = functionDescriptor instanceof ConstructorDescriptor ? state.getTypeMapper().mapToCallableMethod((ConstructorDescriptor)functionDescriptor) : state.getTypeMapper().mapToCallableMethod(functionDescriptor, false, methodContext);
        generator.genCallWithoutAssertions(method, codegen);
        iv.areturn(signature.getReturnType());
    }

    @NotNull
    private static FrameMap createFrameMap(@NotNull GenerationState state, @NotNull FunctionDescriptor function, @NotNull JvmMethodSignature signature, boolean isStatic) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/FunctionCodegen", "createFrameMap"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/FunctionCodegen", "createFrameMap"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "createFrameMap"));
        }
        FrameMap frameMap = new FrameMap();
        if (!isStatic) {
            frameMap.enterTemp(AsmTypeConstants.OBJECT_TYPE);
        }
        for (JvmMethodParameterSignature jvmMethodParameterSignature : signature.getValueParameters()) {
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            frameMap.enterTemp(jvmMethodParameterSignature.getAsmType());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function.getValueParameters()) {
            frameMap.enter(valueParameterDescriptor, state.getTypeMapper().mapType(valueParameterDescriptor));
        }
        FrameMap frameMap2 = frameMap;
        if (frameMap2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionCodegen", "createFrameMap"));
        }
        return frameMap2;
    }

    private static void loadExplicitArgumentsOnStack(@NotNull Type ownerType, boolean isStatic, @NotNull JvmMethodSignature signature, @NotNull CallGenerator callGenerator) {
        if (ownerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerType", "org/jetbrains/jet/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        if (callGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callGenerator", "org/jetbrains/jet/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        int var = 0;
        if (!isStatic) {
            callGenerator.putValueIfNeeded(null, ownerType, StackValue.local(var, ownerType));
            var += ownerType.getSize();
        }
        for (JvmMethodParameterSignature parameterSignature : signature.getValueParameters()) {
            if (parameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            Type type = parameterSignature.getAsmType();
            callGenerator.putValueIfNeeded(null, type, StackValue.local(var, type));
            var += type.getSize();
        }
    }

    private static boolean isDefaultNeeded(FunctionDescriptor functionDescriptor) {
        boolean needed = false;
        if (functionDescriptor != null) {
            for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
                if (!parameterDescriptor.declaresDefaultValue()) continue;
                needed = true;
                break;
            }
        }
        return needed;
    }

    private static boolean isEmptyConstructorNeeded(@NotNull BindingContext context2, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull JetClassOrObject classOrObject) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/FunctionCodegen", "isEmptyConstructorNeeded"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "isEmptyConstructorNeeded"));
        }
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/codegen/FunctionCodegen", "isEmptyConstructorNeeded"));
        }
        ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
        if (classOrObject.isLocal()) {
            return false;
        }
        if (CodegenBinding.canHaveOuter(context2, classDescriptor)) {
            return false;
        }
        if (classDescriptor.getVisibility() == Visibilities.PRIVATE || constructorDescriptor.getVisibility() == Visibilities.PRIVATE) {
            return false;
        }
        if (constructorDescriptor.getValueParameters().isEmpty()) {
            return false;
        }
        for (ValueParameterDescriptor parameterDescriptor : constructorDescriptor.getValueParameters()) {
            if (parameterDescriptor.declaresDefaultValue()) continue;
            return false;
        }
        return true;
    }

    private void generateBridge(@Nullable PsiElement origin, @NotNull FunctionDescriptor descriptor, @NotNull Method bridge, @NotNull Method delegateTo) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateBridge"));
        }
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "org/jetbrains/jet/codegen/FunctionCodegen", "generateBridge"));
        }
        if (delegateTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateTo", "org/jetbrains/jet/codegen/FunctionCodegen", "generateBridge"));
        }
        int flags = 4161;
        MethodVisitor mv = this.v.newMethod(DiagnosticsPackage.OtherOrigin(descriptor), flags, delegateTo.getName(), bridge.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        Type[] argTypes = bridge.getArgumentTypes();
        Type[] originalArgTypes = delegateTo.getArgumentTypes();
        InstructionAdapter iv = new InstructionAdapter(mv);
        iv.load(0, AsmTypeConstants.OBJECT_TYPE);
        int reg = 1;
        for (int i = 0; i < argTypes.length; ++i) {
            StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
            reg += argTypes[i].getSize();
        }
        iv.invokevirtual(this.v.getThisName(), delegateTo.getName(), delegateTo.getDescriptor());
        StackValue.coerce(delegateTo.getReturnType(), bridge.getReturnType(), iv);
        iv.areturn(bridge.getReturnType());
        FunctionCodegen.endVisit(mv, "bridge method", origin);
    }

    public void genDelegate(FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenDescriptor, StackValue field) {
        this.genDelegate(functionDescriptor, overriddenDescriptor.getOriginal(), (ClassDescriptor)overriddenDescriptor.getContainingDeclaration(), field);
    }

    public void genDelegate(final FunctionDescriptor delegateFunction, final FunctionDescriptor delegatedTo, final ClassDescriptor toClass, final StackValue field) {
        final JvmMethodSignature jvmDelegateMethodSignature = this.typeMapper.mapSignature(delegateFunction);
        final JvmMethodSignature jvmDelegateToMethodSignature = this.typeMapper.mapSignature(delegatedTo);
        this.generateMethod(DiagnosticsPackage.OtherOrigin(delegateFunction), jvmDelegateMethodSignature, delegateFunction, new FunctionGenerationStrategy(){

            @Override
            public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context2, @NotNull MemberCodegen<?> parentCodegen) {
                if (mv == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen$3", "generateBody"));
                }
                if (frameMap == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/jet/codegen/FunctionCodegen$3", "generateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen$3", "generateBody"));
                }
                if (context2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/FunctionCodegen$3", "generateBody"));
                }
                if (parentCodegen == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/jet/codegen/FunctionCodegen$3", "generateBody"));
                }
                Method delegateToMethod = jvmDelegateToMethodSignature.getAsmMethod();
                Method delegateMethod = jvmDelegateMethodSignature.getAsmMethod();
                Type[] argTypes = delegateMethod.getArgumentTypes();
                Type[] originalArgTypes = delegateToMethod.getArgumentTypes();
                InstructionAdapter iv = new InstructionAdapter(mv);
                iv.load(0, AsmTypeConstants.OBJECT_TYPE);
                field.put(field.type, iv);
                int reg = 1;
                for (int i = 0; i < argTypes.length; ++i) {
                    StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
                    reg += argTypes[i].getSize();
                }
                String internalName = FunctionCodegen.this.typeMapper.mapType(toClass).getInternalName();
                if (toClass.getKind() == ClassKind.TRAIT) {
                    iv.invokeinterface(internalName, delegateToMethod.getName(), delegateToMethod.getDescriptor());
                } else {
                    iv.invokevirtual(internalName, delegateToMethod.getName(), delegateToMethod.getDescriptor());
                }
                StackValue stackValue = AsmUtil.genNotNullAssertions(FunctionCodegen.this.state, StackValue.onStack(delegateToMethod.getReturnType()), TypesPackage.getApproximationTo(delegatedTo.getReturnType(), delegateFunction.getReturnType(), new Approximation.DataFlowExtras.OnlyMessage(delegatedTo.getName() + "(...)")));
                stackValue.put(delegateMethod.getReturnType(), iv);
                iv.areturn(delegateMethod.getReturnType());
            }
        });
    }
}

