/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.psi.PsiElement;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.JvmCodegenUtil;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotated;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.constants.AnnotationValue;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.BooleanValue;
import org.jetbrains.jet.lang.resolve.constants.ByteValue;
import org.jetbrains.jet.lang.resolve.constants.CharValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.DoubleValue;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.constants.FloatValue;
import org.jetbrains.jet.lang.resolve.constants.IntValue;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.jet.lang.resolve.constants.JavaClassValue;
import org.jetbrains.jet.lang.resolve.constants.LongValue;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.resolve.constants.ShortValue;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public abstract class AnnotationCodegen {
    public static final List<JvmFlagAnnotation> FIELD_FLAGS = Arrays.asList(new JvmFlagAnnotation("kotlin.jvm.volatile", 64), new JvmFlagAnnotation("kotlin.jvm.transient", 128));
    public static final List<JvmFlagAnnotation> METHOD_FLAGS = Arrays.asList(new JvmFlagAnnotation("kotlin.jvm.strictfp", 2048), new JvmFlagAnnotation("kotlin.jvm.synchronized", 32));
    private static final AnnotationVisitor NO_ANNOTATION_VISITOR = new AnnotationVisitor(327680){};
    private final JetTypeMapper typeMapper;
    private final BindingContext bindingContext;

    private AnnotationCodegen(JetTypeMapper mapper) {
        this.typeMapper = mapper;
        this.bindingContext = this.typeMapper.getBindingContext();
    }

    public void genAnnotations(@Nullable Annotated annotated, @Nullable Type returnType) {
        if (annotated == null) {
            return;
        }
        if (!(annotated instanceof DeclarationDescriptor)) {
            return;
        }
        PsiElement psiElement = annotated instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)annotated).getKind() == CallableMemberDescriptor.Kind.DELEGATION ? null : DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)annotated);
        JetModifierList modifierList = null;
        if (annotated instanceof ConstructorDescriptor && psiElement instanceof JetClass) {
            modifierList = ((JetClass)psiElement).getPrimaryConstructorModifierList();
        } else if (psiElement instanceof JetModifierListOwner) {
            modifierList = ((JetModifierListOwner)psiElement).getModifierList();
        }
        HashSet<String> annotationDescriptorsAlreadyPresent = new HashSet<String>();
        if (modifierList == null) {
            if (annotated instanceof CallableMemberDescriptor && JvmCodegenUtil.getDirectMember((CallableMemberDescriptor)annotated) instanceof DeserializedCallableMemberDescriptor) {
                for (AnnotationDescriptor annotation : annotated.getAnnotations()) {
                    String descriptor = this.genAnnotation(annotation);
                    if (descriptor == null) continue;
                    annotationDescriptorsAlreadyPresent.add(descriptor);
                }
            }
        } else {
            List<JetAnnotationEntry> annotationEntries = modifierList.getAnnotationEntries();
            for (JetAnnotationEntry annotationEntry : annotationEntries) {
                String descriptor;
                AnnotationDescriptor annotationDescriptor;
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(annotationEntry, this.bindingContext);
                if (resolvedCall == null || (annotationDescriptor = this.bindingContext.get(BindingContext.ANNOTATION, annotationEntry)) == null || (descriptor = this.genAnnotation(annotationDescriptor)) == null) continue;
                annotationDescriptorsAlreadyPresent.add(descriptor);
            }
        }
        this.generateAdditionalAnnotations(annotated, returnType, annotationDescriptorsAlreadyPresent);
    }

    private void generateAdditionalAnnotations(@NotNull Annotated annotated, @Nullable Type returnType, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/codegen/AnnotationCodegen", "generateAdditionalAnnotations"));
        }
        if (annotationDescriptorsAlreadyPresent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptorsAlreadyPresent", "org/jetbrains/jet/codegen/AnnotationCodegen", "generateAdditionalAnnotations"));
        }
        if (annotated instanceof CallableDescriptor) {
            CallableDescriptor descriptor = (CallableDescriptor)annotated;
            if (AnnotationCodegen.isInvisibleFromTheOutside(descriptor)) {
                return;
            }
            if (descriptor instanceof ValueParameterDescriptor && AnnotationCodegen.isInvisibleFromTheOutside(descriptor.getContainingDeclaration())) {
                return;
            }
            if (returnType != null && !AsmUtil.isPrimitive(returnType)) {
                this.generateNullabilityAnnotation(descriptor.getReturnType(), annotationDescriptorsAlreadyPresent);
            }
        }
    }

    private static boolean isInvisibleFromTheOutside(@Nullable DeclarationDescriptor descriptor) {
        if (descriptor instanceof CallableMemberDescriptor && JetTypeMapper.isAccessor((CallableMemberDescriptor)descriptor)) {
            return false;
        }
        if (descriptor instanceof MemberDescriptor) {
            return AsmUtil.getVisibilityAccessFlag((MemberDescriptor)descriptor) == 2;
        }
        return false;
    }

    private void generateNullabilityAnnotation(@Nullable JetType type, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        if (annotationDescriptorsAlreadyPresent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptorsAlreadyPresent", "org/jetbrains/jet/codegen/AnnotationCodegen", "generateNullabilityAnnotation"));
        }
        if (type == null) {
            return;
        }
        if (AnnotationCodegen.isBareTypeParameterWithNullableUpperBound(type)) {
            return;
        }
        boolean isNullableType = TypeUtils.isNullableType(type);
        Class annotationClass = isNullableType ? Nullable.class : NotNull.class;
        String descriptor = Type.getType(annotationClass).getDescriptor();
        if (!annotationDescriptorsAlreadyPresent.contains(descriptor)) {
            this.visitAnnotation(descriptor, false).visitEnd();
        }
    }

    private static boolean isBareTypeParameterWithNullableUpperBound(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/AnnotationCodegen", "isBareTypeParameterWithNullableUpperBound"));
        }
        ClassifierDescriptor classifier2 = type.getConstructor().getDeclarationDescriptor();
        return !type.isNullable() && classifier2 instanceof TypeParameterDescriptor && TypeUtils.hasNullableSuperType(type);
    }

    public void generateAnnotationDefaultValue(@NotNull CompileTimeConstant value, @NotNull JetType expectedType) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/codegen/AnnotationCodegen", "generateAnnotationDefaultValue"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/codegen/AnnotationCodegen", "generateAnnotationDefaultValue"));
        }
        AnnotationVisitor visitor = this.visitAnnotation(null, false);
        this.genCompileTimeValue(null, value, expectedType, visitor);
        visitor.visitEnd();
    }

    @Nullable
    private String genAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        if (annotationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptor", "org/jetbrains/jet/codegen/AnnotationCodegen", "genAnnotation"));
        }
        ClassifierDescriptor classifierDescriptor = annotationDescriptor.getType().getConstructor().getDeclarationDescriptor();
        assert (classifierDescriptor != null) : "Annotation descriptor has no class: " + annotationDescriptor;
        RetentionPolicy rp = this.getRetentionPolicy(classifierDescriptor);
        if (rp == RetentionPolicy.SOURCE) {
            return null;
        }
        String descriptor = this.typeMapper.mapType(annotationDescriptor.getType()).getDescriptor();
        AnnotationVisitor annotationVisitor = this.visitAnnotation(descriptor, rp == RetentionPolicy.RUNTIME);
        this.genAnnotationArguments(annotationDescriptor, annotationVisitor);
        annotationVisitor.visitEnd();
        return descriptor;
    }

    private void genAnnotationArguments(AnnotationDescriptor annotationDescriptor, AnnotationVisitor annotationVisitor) {
        for (Map.Entry<ValueParameterDescriptor, CompileTimeConstant<?>> entry : annotationDescriptor.getAllValueArguments().entrySet()) {
            ValueParameterDescriptor descriptor = entry.getKey();
            String name = descriptor.getName().asString();
            this.genCompileTimeValue(name, entry.getValue(), descriptor.getType(), annotationVisitor);
        }
    }

    private void genCompileTimeValue(final @Nullable String name, @NotNull CompileTimeConstant<?> value, final @NotNull JetType expectedType, final @NotNull AnnotationVisitor annotationVisitor) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/codegen/AnnotationCodegen", "genCompileTimeValue"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/codegen/AnnotationCodegen", "genCompileTimeValue"));
        }
        if (annotationVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationVisitor", "org/jetbrains/jet/codegen/AnnotationCodegen", "genCompileTimeValue"));
        }
        AnnotationArgumentVisitor<Void, Void> argumentVisitor = new AnnotationArgumentVisitor<Void, Void>(){

            @Override
            public Void visitLongValue(@NotNull LongValue value, Void data2) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/codegen/AnnotationCodegen$2", "visitLongValue"));
                }
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitIntValue(IntValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitShortValue(ShortValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitByteValue(ByteValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitDoubleValue(DoubleValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitFloatValue(FloatValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitBooleanValue(BooleanValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitCharValue(CharValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitStringValue(StringValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitEnumValue(EnumValue value, Void data2) {
                String propertyName = value.getValue().getName().asString();
                annotationVisitor.visitEnum(name, AnnotationCodegen.this.typeMapper.mapType(value.getType(KotlinBuiltIns.getInstance())).getDescriptor(), propertyName);
                return null;
            }

            @Override
            public Void visitArrayValue(ArrayValue value, Void data2) {
                AnnotationVisitor visitor = annotationVisitor.visitArray(name);
                Iterator i$ = value.getValue().iterator();
                while (i$.hasNext()) {
                    CompileTimeConstant argument = (CompileTimeConstant)i$.next();
                    AnnotationCodegen.this.genCompileTimeValue(null, argument, value.getType(KotlinBuiltIns.getInstance()), visitor);
                }
                visitor.visitEnd();
                return null;
            }

            @Override
            public Void visitAnnotationValue(AnnotationValue value, Void data2) {
                String internalAnnName = AnnotationCodegen.this.typeMapper.mapType(value.getValue().getType()).getDescriptor();
                AnnotationVisitor visitor = annotationVisitor.visitAnnotation(name, internalAnnName);
                AnnotationCodegen.this.genAnnotationArguments(value.getValue(), visitor);
                visitor.visitEnd();
                return null;
            }

            @Override
            public Void visitJavaClassValue(JavaClassValue value, Void data2) {
                annotationVisitor.visit(name, AnnotationCodegen.this.typeMapper.mapType(value.getValue()));
                return null;
            }

            @Override
            public Void visitNumberTypeValue(IntegerValueTypeConstant value, Void data2) {
                Number numberType = value.getValue(expectedType);
                annotationVisitor.visit(name, numberType);
                return null;
            }

            private Void visitSimpleValue(CompileTimeConstant value) {
                annotationVisitor.visit(name, value.getValue());
                return null;
            }

            @Override
            public Void visitErrorValue(ErrorValue value, Void data2) {
                return this.visitUnsupportedValue(value);
            }

            @Override
            public Void visitNullValue(NullValue value, Void data2) {
                return this.visitUnsupportedValue(value);
            }

            private Void visitUnsupportedValue(CompileTimeConstant value) {
                throw new IllegalStateException("Don't know how to compile annotation value " + value);
            }
        };
        value.accept(argumentVisitor, null);
    }

    @NotNull
    private RetentionPolicy getRetentionPolicy(@NotNull Annotated descriptor) {
        ClassDescriptor enumEntry;
        JetType classObjectType;
        CompileTimeConstant<?> compileTimeConstant;
        Collection<CompileTimeConstant<?>> valueArguments2;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/AnnotationCodegen", "getRetentionPolicy"));
        }
        AnnotationDescriptor retentionAnnotation = descriptor.getAnnotations().findAnnotation(new FqName(Retention.class.getName()));
        if (retentionAnnotation != null && !(valueArguments2 = retentionAnnotation.getAllValueArguments().values()).isEmpty() && (compileTimeConstant = valueArguments2.iterator().next()) instanceof EnumValue && (classObjectType = (enumEntry = ((EnumValue)compileTimeConstant).getValue()).getClassObjectType()) != null && "java/lang/annotation/RetentionPolicy".equals(this.typeMapper.mapType(classObjectType).getInternalName())) {
            RetentionPolicy retentionPolicy = RetentionPolicy.valueOf(enumEntry.getName().asString());
            if (retentionPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AnnotationCodegen", "getRetentionPolicy"));
            }
            return retentionPolicy;
        }
        RetentionPolicy retentionPolicy = RetentionPolicy.CLASS;
        if (retentionPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AnnotationCodegen", "getRetentionPolicy"));
        }
        return retentionPolicy;
    }

    @NotNull
    abstract AnnotationVisitor visitAnnotation(String var1, boolean var2);

    public static AnnotationCodegen forClass(final ClassVisitor cv, JetTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(cv.visitAnnotation(descr, visible));
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AnnotationCodegen$3", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    public static AnnotationCodegen forMethod(final MethodVisitor mv, JetTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv.visitAnnotation(descr, visible));
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AnnotationCodegen$4", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    public static AnnotationCodegen forField(final FieldVisitor fv, JetTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(fv.visitAnnotation(descr, visible));
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AnnotationCodegen$5", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    public static AnnotationCodegen forParameter(final int parameter, final MethodVisitor mv, JetTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv.visitParameterAnnotation(parameter, descr, visible));
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AnnotationCodegen$6", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    public static AnnotationCodegen forAnnotationDefaultValue(final MethodVisitor mv, JetTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv.visitAnnotationDefault());
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AnnotationCodegen$7", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    @NotNull
    private static AnnotationVisitor safe(@Nullable AnnotationVisitor av) {
        AnnotationVisitor annotationVisitor = av == null ? NO_ANNOTATION_VISITOR : av;
        if (annotationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AnnotationCodegen", "safe"));
        }
        return annotationVisitor;
    }

    public static final class JvmFlagAnnotation {
        private final FqName fqName;
        private final int jvmFlag;

        public JvmFlagAnnotation(@NotNull String fqName2, int jvmFlag) {
            if (fqName2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/codegen/AnnotationCodegen$JvmFlagAnnotation", "<init>"));
            }
            this.fqName = new FqName(fqName2);
            this.jvmFlag = jvmFlag;
        }

        public boolean hasAnnotation(@NotNull Annotated annotated) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/codegen/AnnotationCodegen$JvmFlagAnnotation", "hasAnnotation"));
            }
            return annotated.getAnnotations().findAnnotation(this.fqName) != null;
        }

        public int getJvmFlag() {
            return this.jvmFlag;
        }
    }
}

