/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import org.jetbrains.annotations.Nullable;

public class CompilerMessageLocation {
    public static final CompilerMessageLocation NO_LOCATION = new CompilerMessageLocation(null, -1, -1);
    private final String path;
    private final int line;
    private final int column;

    public static CompilerMessageLocation create(@Nullable String path, int line, int column) {
        if (path == null) {
            return NO_LOCATION;
        }
        return new CompilerMessageLocation(path, line, column);
    }

    private CompilerMessageLocation(@Nullable String path, int line, int column) {
        this.path = path;
        this.line = line;
        this.column = column;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompilerMessageLocation location = (CompilerMessageLocation)o;
        if (this.column != location.column) {
            return false;
        }
        if (this.line != location.line) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(location.path) : location.path != null);
    }

    public int hashCode() {
        int result2 = this.path != null ? this.path.hashCode() : 0;
        result2 = 31 * result2 + this.line;
        result2 = 31 * result2 + this.column;
        return result2;
    }

    public String toString() {
        return this.path + (this.line != -1 || this.column != -1 ? " (" + this.line + ":" + this.column + ")" : "");
    }
}

