/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.backend.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.bridges.BridgesPackage;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class CodegenUtil {
    public static final String EQUALS_METHOD_NAME = "equals";
    public static final String TO_STRING_METHOD_NAME = "toString";
    public static final String HASH_CODE_METHOD_NAME = "hashCode";

    private CodegenUtil() {
    }

    @Nullable
    public static FunctionDescriptor getDeclaredFunctionByRawSignature(@NotNull ClassDescriptor owner, @NotNull Name name, @NotNull ClassifierDescriptor returnedClassifier, ClassifierDescriptor ... valueParameterClassifiers) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/backend/common/CodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/backend/common/CodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (returnedClassifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnedClassifier", "org/jetbrains/jet/backend/common/CodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (valueParameterClassifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterClassifiers", "org/jetbrains/jet/backend/common/CodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        Collection<FunctionDescriptor> functions2 = owner.getDefaultType().getMemberScope().getFunctions(name);
        for (FunctionDescriptor function : functions2) {
            if (CallResolverUtil.isOrOverridesSynthesized(function) || !function.getTypeParameters().isEmpty() || !CodegenUtil.valueParameterClassesMatch(function.getValueParameters(), Arrays.asList(valueParameterClassifiers)) || !CodegenUtil.rawTypeMatches(function.getReturnType(), returnedClassifier)) continue;
            return function;
        }
        return null;
    }

    public static FunctionDescriptor getAnyEqualsMethod() {
        ClassDescriptor anyClass = KotlinBuiltIns.getInstance().getAny();
        FunctionDescriptor function = CodegenUtil.getDeclaredFunctionByRawSignature(anyClass, Name.identifier(EQUALS_METHOD_NAME), KotlinBuiltIns.getInstance().getBoolean(), anyClass);
        assert (function != null);
        return function;
    }

    public static FunctionDescriptor getAnyToStringMethod() {
        ClassDescriptor anyClass = KotlinBuiltIns.getInstance().getAny();
        FunctionDescriptor function = CodegenUtil.getDeclaredFunctionByRawSignature(anyClass, Name.identifier(TO_STRING_METHOD_NAME), KotlinBuiltIns.getInstance().getString(), new ClassifierDescriptor[0]);
        assert (function != null);
        return function;
    }

    public static FunctionDescriptor getAnyHashCodeMethod() {
        ClassDescriptor anyClass = KotlinBuiltIns.getInstance().getAny();
        FunctionDescriptor function = CodegenUtil.getDeclaredFunctionByRawSignature(anyClass, Name.identifier(HASH_CODE_METHOD_NAME), KotlinBuiltIns.getInstance().getInt(), new ClassifierDescriptor[0]);
        assert (function != null);
        return function;
    }

    @Nullable
    public static PropertyDescriptor getDelegatePropertyIfAny(JetExpression expression, ClassDescriptor classDescriptor, BindingContext bindingContext) {
        ValueParameterDescriptor valueParameterDescriptor;
        CallableDescriptor callResultingDescriptor;
        ResolvedCall<? extends CallableDescriptor> call;
        PropertyDescriptor propertyDescriptor = null;
        if (expression instanceof JetSimpleNameExpression && (call = CallUtilPackage.getResolvedCall(expression, bindingContext)) != null && (callResultingDescriptor = call.getResultingDescriptor()) instanceof ValueParameterDescriptor && (valueParameterDescriptor = (ValueParameterDescriptor)callResultingDescriptor).getContainingDeclaration() instanceof ConstructorDescriptor && valueParameterDescriptor.getContainingDeclaration().getContainingDeclaration() == classDescriptor) {
            propertyDescriptor = bindingContext.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameterDescriptor);
        }
        return propertyDescriptor;
    }

    public static boolean isFinalPropertyWithBackingField(PropertyDescriptor propertyDescriptor, BindingContext bindingContext) {
        return propertyDescriptor != null && !propertyDescriptor.isVar() && Boolean.TRUE.equals(bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor));
    }

    @NotNull
    public static Map<FunctionDescriptor, FunctionDescriptor> getTraitMethods(ClassDescriptor descriptor) {
        LinkedHashMap<FunctionDescriptor, FunctionDescriptor> result2 = new LinkedHashMap<FunctionDescriptor, FunctionDescriptor>();
        for (DeclarationDescriptor declaration : descriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
            CallableMemberDescriptor inheritedMember;
            CallableMemberDescriptor traitMember;
            if (!(declaration instanceof CallableMemberDescriptor) || (traitMember = BridgesPackage.findTraitImplementation(inheritedMember = (CallableMemberDescriptor)declaration)) == null) continue;
            assert (traitMember.getModality() != Modality.ABSTRACT) : "Cannot delegate to abstract trait method: " + inheritedMember;
            CallableMemberDescriptor copy = inheritedMember.copy(inheritedMember.getContainingDeclaration(), traitMember.getModality(), Visibilities.PUBLIC, CallableMemberDescriptor.Kind.DECLARATION, true);
            if (traitMember instanceof SimpleFunctionDescriptor) {
                result2.put((FunctionDescriptor)traitMember, (FunctionDescriptor)copy);
                continue;
            }
            if (!(traitMember instanceof PropertyDescriptor)) continue;
            for (PropertyAccessorDescriptor traitAccessor : ((PropertyDescriptor)traitMember).getAccessors()) {
                for (PropertyAccessorDescriptor inheritedAccessor : ((PropertyDescriptor)copy).getAccessors()) {
                    if (inheritedAccessor.getClass() != traitAccessor.getClass()) continue;
                    result2.put(traitAccessor, inheritedAccessor);
                }
            }
        }
        LinkedHashMap<FunctionDescriptor, FunctionDescriptor> linkedHashMap = result2;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/backend/common/CodegenUtil", "getTraitMethods"));
        }
        return linkedHashMap;
    }

    @NotNull
    public static ClassDescriptor getSuperClassByDelegationSpecifier(@NotNull JetDelegationSpecifier specifier, @NotNull BindingContext bindingContext) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/jet/backend/common/CodegenUtil", "getSuperClassByDelegationSpecifier"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/backend/common/CodegenUtil", "getSuperClassByDelegationSpecifier"));
        }
        JetType superType = bindingContext.get(BindingContext.TYPE, specifier.getTypeReference());
        assert (superType != null) : "superType should not be null: " + specifier.getText();
        ClassDescriptor superClassDescriptor = (ClassDescriptor)superType.getConstructor().getDeclarationDescriptor();
        assert (superClassDescriptor != null) : "superClassDescriptor should not be null: " + specifier.getText();
        ClassDescriptor classDescriptor = superClassDescriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/backend/common/CodegenUtil", "getSuperClassByDelegationSpecifier"));
        }
        return classDescriptor;
    }

    private static boolean valueParameterClassesMatch(@NotNull List<ValueParameterDescriptor> parameters, @NotNull List<ClassifierDescriptor> classifiers) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/jet/backend/common/CodegenUtil", "valueParameterClassesMatch"));
        }
        if (classifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifiers", "org/jetbrains/jet/backend/common/CodegenUtil", "valueParameterClassesMatch"));
        }
        if (parameters.size() != classifiers.size()) {
            return false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            ValueParameterDescriptor parameterDescriptor = parameters.get(i);
            ClassifierDescriptor classDescriptor = classifiers.get(i);
            if (CodegenUtil.rawTypeMatches(parameterDescriptor.getType(), classDescriptor)) continue;
            return false;
        }
        return true;
    }

    private static boolean rawTypeMatches(JetType type, ClassifierDescriptor classifier2) {
        return type.getConstructor().equals(classifier2.getTypeConstructor());
    }

    public static boolean isEnumValueOfMethod(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/backend/common/CodegenUtil", "isEnumValueOfMethod"));
        }
        List<ValueParameterDescriptor> methodTypeParameters = functionDescriptor.getValueParameters();
        JetType nullableString = TypeUtils.makeNullable(KotlinBuiltIns.getInstance().getStringType());
        return DescriptorUtils.ENUM_VALUE_OF.equals(functionDescriptor.getName()) && methodTypeParameters.size() == 1 && JetTypeChecker.DEFAULT.isSubtypeOf(methodTypeParameters.get(0).getType(), nullableString);
    }

    public static boolean isEnumValuesMethod(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/backend/common/CodegenUtil", "isEnumValuesMethod"));
        }
        List<ValueParameterDescriptor> methodTypeParameters = functionDescriptor.getValueParameters();
        return DescriptorUtils.ENUM_VALUES.equals(functionDescriptor.getName()) && methodTypeParameters.isEmpty();
    }
}

