/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Tag;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.Nullable;

class TagBinding
extends BasePrimitiveBinding {
    private final Tag myTagAnnotation;

    public TagBinding(Accessor accessor, Tag tagAnnotation) {
        super(accessor, tagAnnotation.value(), null);
        this.myTagAnnotation = tagAnnotation;
    }

    @Override
    @Nullable
    public Object deserialize(Object o, Object ... nodes) {
        Object[] children;
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/util/xmlb/TagBinding", "deserialize"));
        }
        assert (nodes.length > 0);
        if (nodes.length == 1) {
            children = JDOMUtil.getContent((Element)nodes[0]);
        } else {
            String name = ((Element)nodes[0]).getName();
            SmartList<Content> childrenList = new SmartList<Content>();
            for (Object node : nodes) {
                assert (((Element)node).getName().equals(name));
                childrenList.addAll(((Element)node).getContent());
            }
            children = ArrayUtil.toObjectArray(childrenList);
        }
        if (children.length == 0) {
            children = new Object[]{new Text(this.myTagAnnotation.textIfEmpty())};
        }
        assert (this.myBinding != null);
        Object v = this.myBinding.deserialize(this.myAccessor.read(o), children);
        Object value = XmlSerializerImpl.convert(v, this.myAccessor.getValueClass());
        this.myAccessor.write(o, value);
        return o;
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myName);
    }
}

