/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.ClassTypePointerFactory;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.smartPointers.TypePointerBase;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartTypePointerManagerImpl
extends SmartTypePointerManager {
    private static final SmartTypePointer NULL_POINTER = new SmartTypePointer(){

        @Override
        public PsiType getType() {
            return null;
        }
    };
    private final SmartPointerManager myPsiPointerManager;
    private final Project myProject;

    public SmartTypePointerManagerImpl(SmartPointerManager psiPointerManager, Project project) {
        this.myPsiPointerManager = psiPointerManager;
        this.myProject = project;
    }

    @Override
    @NotNull
    public SmartTypePointer createSmartTypePointer(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl", "createSmartTypePointer"));
        }
        SmartTypePointer pointer = type.accept(new SmartTypeCreatingVisitor());
        SmartTypePointer smartTypePointer = pointer != null ? pointer : NULL_POINTER;
        if (smartTypePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl", "createSmartTypePointer"));
        }
        return smartTypePointer;
    }

    @NotNull
    private SmartTypePointer createClassReferenceTypePointer(@NotNull PsiClassType classType) {
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl", "createClassReferenceTypePointer"));
        }
        for (ClassTypePointerFactory factory2 : ClassTypePointerFactory.EP_NAME.getExtensions()) {
            SmartTypePointer pointer = factory2.createClassTypePointer(classType, this.myProject);
            if (pointer == null) continue;
            SmartTypePointer smartTypePointer = pointer;
            if (smartTypePointer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl", "createClassReferenceTypePointer"));
            }
            return smartTypePointer;
        }
        SimpleTypePointer simpleTypePointer = new SimpleTypePointer(classType);
        if (simpleTypePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl", "createClassReferenceTypePointer"));
        }
        return simpleTypePointer;
    }

    private class SmartTypeCreatingVisitor
    extends PsiTypeVisitor<SmartTypePointer> {
        private SmartTypeCreatingVisitor() {
        }

        @Override
        public SmartTypePointer visitPrimitiveType(PsiPrimitiveType primitiveType) {
            return new SimpleTypePointer(primitiveType);
        }

        @Override
        public SmartTypePointer visitArrayType(PsiArrayType arrayType) {
            SmartTypePointer componentTypePointer = arrayType.getComponentType().accept(this);
            return componentTypePointer != null ? new ArrayTypePointer(arrayType, componentTypePointer) : null;
        }

        @Override
        public SmartTypePointer visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            SmartTypePointer boundPointer = bound == null ? null : bound.accept(this);
            return new WildcardTypePointer(wildcardType, boundPointer);
        }

        @Override
        public SmartTypePointer visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                return SmartTypePointerManagerImpl.this.createClassReferenceTypePointer(classType);
            }
            if (classType instanceof PsiClassReferenceType) {
                classType = ((PsiClassReferenceType)classType).createImmediateCopy();
            }
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            HashMap<SmartPsiElementPointer, SmartTypePointer> map = new HashMap<SmartPsiElementPointer, SmartTypePointer>();
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                PsiType substitutionResult = substitutor.substitute(typeParameter);
                if (substitutionResult == null) continue;
                SmartPsiElementPointer<PsiTypeParameter> pointer = SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer(typeParameter);
                map.put(pointer, substitutionResult.accept(this));
            }
            return new ClassTypePointer(classType, SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer(aClass), map);
        }

        @Override
        public SmartTypePointer visitDisjunctionType(PsiDisjunctionType disjunctionType) {
            return new DisjunctionTypePointer(disjunctionType);
        }
    }

    private class DisjunctionTypePointer
    extends TypePointerBase<PsiDisjunctionType> {
        private final List<SmartTypePointer> myPointers;

        private DisjunctionTypePointer(@NotNull PsiDisjunctionType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$DisjunctionTypePointer", "<init>"));
            }
            super(type);
            this.myPointers = ContainerUtil.map(type.getDisjunctions(), new Function<PsiType, SmartTypePointer>(){

                @Override
                public SmartTypePointer fun(PsiType psiType) {
                    return SmartTypePointerManagerImpl.this.createSmartTypePointer(psiType);
                }
            });
        }

        @Override
        protected PsiDisjunctionType calcType() {
            List<PsiType> types = ContainerUtil.map(this.myPointers, new NullableFunction<SmartTypePointer, PsiType>(){

                @Override
                public PsiType fun(SmartTypePointer typePointer) {
                    return typePointer.getType();
                }
            });
            return new PsiDisjunctionType(types, PsiManager.getInstance(SmartTypePointerManagerImpl.this.myProject));
        }
    }

    private static class ClassTypePointer
    extends TypePointerBase<PsiClassType> {
        private final SmartPsiElementPointer myClass;
        private final Map<SmartPsiElementPointer, SmartTypePointer> myMap;

        public ClassTypePointer(@NotNull PsiClassType type, @NotNull SmartPsiElementPointer aClass, @NotNull Map<SmartPsiElementPointer, SmartTypePointer> map) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ClassTypePointer", "<init>"));
            }
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ClassTypePointer", "<init>"));
            }
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ClassTypePointer", "<init>"));
            }
            super(type);
            this.myClass = aClass;
            this.myMap = map;
        }

        @Override
        protected PsiClassType calcType() {
            Object classElement = this.myClass.getElement();
            if (!(classElement instanceof PsiClass)) {
                return null;
            }
            HashMap<PsiTypeParameter, PsiType> resurrected = new HashMap<PsiTypeParameter, PsiType>();
            Set<Map.Entry<SmartPsiElementPointer, SmartTypePointer>> set = this.myMap.entrySet();
            for (Map.Entry<SmartPsiElementPointer, SmartTypePointer> entry : set) {
                Object element = entry.getKey().getElement();
                if (!(element instanceof PsiTypeParameter)) continue;
                SmartTypePointer typePointer = entry.getValue();
                resurrected.put((PsiTypeParameter)element, typePointer == null ? null : typePointer.getType());
            }
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiClass)classElement)) {
                if (resurrected.containsKey(typeParameter)) continue;
                resurrected.put(typeParameter, null);
            }
            PsiSubstitutor resurrectedSubstitutor = PsiSubstitutorImpl.createSubstitutor(resurrected);
            return new PsiImmediateClassType((PsiClass)classElement, resurrectedSubstitutor);
        }
    }

    private static class WildcardTypePointer
    extends TypePointerBase<PsiWildcardType> {
        private final PsiManager myManager;
        private final SmartTypePointer myBoundPointer;
        private final boolean myIsExtending;

        public WildcardTypePointer(@NotNull PsiWildcardType type, @Nullable SmartTypePointer boundPointer) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$WildcardTypePointer", "<init>"));
            }
            super(type);
            this.myManager = type.getManager();
            this.myBoundPointer = boundPointer;
            this.myIsExtending = type.isExtends();
        }

        @Override
        protected PsiWildcardType calcType() {
            if (this.myBoundPointer == null) {
                return PsiWildcardType.createUnbounded(this.myManager);
            }
            PsiType type = this.myBoundPointer.getType();
            assert (type != null) : this.myBoundPointer;
            if (this.myIsExtending) {
                return PsiWildcardType.createExtends(this.myManager, type);
            }
            return PsiWildcardType.createSuper(this.myManager, type);
        }
    }

    private static class ArrayTypePointer
    extends TypePointerBase<PsiArrayType> {
        private final SmartTypePointer myComponentTypePointer;

        public ArrayTypePointer(@NotNull PsiArrayType type, @NotNull SmartTypePointer componentTypePointer) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ArrayTypePointer", "<init>"));
            }
            if (componentTypePointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTypePointer", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ArrayTypePointer", "<init>"));
            }
            super(type);
            this.myComponentTypePointer = componentTypePointer;
        }

        @Override
        @Nullable
        protected PsiArrayType calcType() {
            PsiType type = this.myComponentTypePointer.getType();
            return type == null ? null : new PsiArrayType(type);
        }
    }

    private static class SimpleTypePointer
    implements SmartTypePointer {
        private final PsiType myType;

        private SimpleTypePointer(@NotNull PsiType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$SimpleTypePointer", "<init>"));
            }
            this.myType = type;
        }

        @Override
        public PsiType getType() {
            return this.myType;
        }
    }
}

