/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ConcurrentFactoryMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtil {
    public static final Set<String> ALL_ANNOTATIONS;
    @NonNls
    private static final String[] SIMPLE_NAMES;

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        if (annotationNames.length == 0) {
            return null;
        }
        Set<String> set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : new HashSet<String>(Arrays.asList(annotationNames));
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        if (listOwner == null) {
            return null;
        }
        PsiAnnotation annotation = AnnotationUtil.findOwnAnnotation(listOwner, annotationNames);
        if (annotation != null) {
            return annotation;
        }
        return skipExternal ? null : AnnotationUtil.findNonCodeAnnotation(listOwner, annotationNames);
    }

    private static PsiAnnotation findOwnAnnotation(final PsiModifierListOwner listOwner, Collection<String> annotationNames) {
        ConcurrentFactoryMap<Collection<String>, PsiAnnotation> map = CachedValuesManager.getCachedValue(listOwner, new CachedValueProvider<ConcurrentFactoryMap<Collection<String>, PsiAnnotation>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<ConcurrentFactoryMap<Collection<String>, PsiAnnotation>> compute() {
                ConcurrentFactoryMap<Collection<String>, PsiAnnotation> value = new ConcurrentFactoryMap<Collection<String>, PsiAnnotation>(){

                    @Override
                    @Nullable
                    protected PsiAnnotation create(Collection<String> annotationNames) {
                        PsiModifierList list = listOwner.getModifierList();
                        if (list == null) {
                            return null;
                        }
                        for (PsiAnnotation annotation : list.getAnnotations()) {
                            if (!annotationNames.contains(annotation.getQualifiedName())) continue;
                            return annotation;
                        }
                        return null;
                    }
                };
                return CachedValueProvider.Result.create(value, PsiModificationTracker.MODIFICATION_COUNT);
            }
        });
        return (PsiAnnotation)map.get(annotationNames);
    }

    private static PsiAnnotation findNonCodeAnnotation(final PsiModifierListOwner listOwner, Collection<String> annotationNames) {
        ConcurrentFactoryMap<Collection<String>, PsiAnnotation> map = CachedValuesManager.getCachedValue(listOwner, new CachedValueProvider<ConcurrentFactoryMap<Collection<String>, PsiAnnotation>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<ConcurrentFactoryMap<Collection<String>, PsiAnnotation>> compute() {
                ConcurrentFactoryMap<Collection<String>, PsiAnnotation> value = new ConcurrentFactoryMap<Collection<String>, PsiAnnotation>(){

                    @Override
                    @Nullable
                    protected PsiAnnotation create(Collection<String> annotationNames) {
                        Project project = listOwner.getProject();
                        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance(project);
                        for (String annotationName : annotationNames) {
                            PsiAnnotation annotation = annotationsManager.findExternalAnnotation(listOwner, annotationName);
                            if (annotation == null) continue;
                            return annotation;
                        }
                        InferredAnnotationsManager inferredAnnotationsManager = InferredAnnotationsManager.getInstance(project);
                        for (String annotationName : annotationNames) {
                            PsiAnnotation annotation = inferredAnnotationsManager.findInferredAnnotation(listOwner, annotationName);
                            if (annotation == null) continue;
                            return annotation;
                        }
                        return null;
                    }
                };
                return CachedValueProvider.Result.create(value, PsiModificationTracker.MODIFICATION_COUNT);
            }
        });
        return (PsiAnnotation)map.get(annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(final @NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        PsiAnnotation directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames);
        if (directAnnotation != null) {
            return directAnnotation;
        }
        ConcurrentFactoryMap<Set<String>, PsiAnnotation> map = CachedValuesManager.getCachedValue(listOwner, new CachedValueProvider<ConcurrentFactoryMap<Set<String>, PsiAnnotation>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<ConcurrentFactoryMap<Set<String>, PsiAnnotation>> compute() {
                ConcurrentFactoryMap<Set<String>, PsiAnnotation> value = new ConcurrentFactoryMap<Set<String>, PsiAnnotation>(){

                    @Override
                    @Nullable
                    protected PsiAnnotation create(Set<String> annotationNames) {
                        if (listOwner instanceof PsiMethod) {
                            PsiMethod method = (PsiMethod)listOwner;
                            PsiClass aClass = method.getContainingClass();
                            if (aClass == null) {
                                return null;
                            }
                            HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
                            return AnnotationUtil.findAnnotationInHierarchy(methodSignature, annotationNames, method, null, JavaPsiFacade.getInstance(method.getProject()).getResolveHelper());
                        }
                        if (listOwner instanceof PsiClass) {
                            return AnnotationUtil.findAnnotationInHierarchy((PsiClass)listOwner, annotationNames, null);
                        }
                        if (listOwner instanceof PsiParameter) {
                            PsiParameter parameter = (PsiParameter)listOwner;
                            return AnnotationUtil.doFindAnnotationInHierarchy(parameter, annotationNames, null);
                        }
                        return null;
                    }
                };
                return CachedValueProvider.Result.create(value, PsiModificationTracker.MODIFICATION_COUNT);
            }
        });
        return (PsiAnnotation)map.get(annotationNames);
    }

    @Nullable
    private static PsiAnnotation doFindAnnotationInHierarchy(@NotNull PsiParameter parameter, @NotNull Set<String> annotationNames, @Nullable Set<PsiModifierListOwner> visited) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/AnnotationUtil", "doFindAnnotationInHierarchy"));
        }
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "doFindAnnotationInHierarchy"));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, annotationNames);
        if (annotation != null) {
            return annotation;
        }
        PsiElement scope = parameter.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)scope;
        PsiClass aClass = method.getContainingClass();
        PsiElement parent = parameter.getParent();
        if (aClass == null || !(parent instanceof PsiParameterList)) {
            return null;
        }
        int index = ((PsiParameterList)parent).getParameterIndex(parameter);
        HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
        List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
        PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance(aClass.getProject());
        for (HierarchicalMethodSignature superSignature : superSignatures) {
            PsiAnnotation insuper;
            PsiParameter[] superParameters;
            PsiMethod superMethod = superSignature.getMethod();
            if (visited == null) {
                visited = new THashSet<PsiModifierListOwner>();
            }
            if (!visited.add(superMethod) || !resolveHelper.isAccessible(superMethod, parameter, null) || index >= (superParameters = superMethod.getParameterList().getParameters()).length || (insuper = AnnotationUtil.doFindAnnotationInHierarchy(superParameters[index], annotationNames, visited)) == null) continue;
            return insuper;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiClass psiClass, @NotNull Set<String> annotationNames, @Nullable Set<PsiClass> processed) {
        PsiClass[] superClasses;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        for (PsiClass superClass : superClasses = psiClass.getSupers()) {
            if (processed == null) {
                processed = new THashSet<PsiClass>();
            }
            if (!processed.add(superClass)) {
                return null;
            }
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)superClass, annotationNames);
            if (annotation != null) {
                return annotation;
            }
            PsiAnnotation annotationInHierarchy = AnnotationUtil.findAnnotationInHierarchy(superClass, annotationNames, processed);
            if (annotationInHierarchy == null) continue;
            return annotationInHierarchy;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findAnnotationInHierarchy(@NotNull HierarchicalMethodSignature signature, @NotNull Set<String> annotationNames, @NotNull PsiElement place, @Nullable Set<PsiMethod> processed, @NotNull PsiResolveHelper resolveHelper) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        List<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : superSignatures) {
            PsiMethod superMethod = superSignature.getMethod();
            if (processed == null) {
                processed = new THashSet<PsiMethod>();
            }
            if (!processed.add(superMethod) || !resolveHelper.isAccessible(superMethod, place, null)) continue;
            PsiAnnotation direct = AnnotationUtil.findAnnotation((PsiModifierListOwner)superMethod, annotationNames);
            if (direct != null) {
                return direct;
            }
            PsiAnnotation superResult = AnnotationUtil.findAnnotationInHierarchy(superSignature, annotationNames, place, processed, resolveHelper);
            if (superResult == null) continue;
            return superResult;
        }
        return null;
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        for (String annotation : annotations) {
            if (!AnnotationUtil.isAnnotated(listOwner, annotation, checkHierarchy, skipExternal)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls @NotNull String annotationFQN, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, checkHierarchy, skipExternal, null);
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls @NotNull String annotationFQN, boolean checkHierarchy, boolean skipExternal, @Nullable Set<PsiMember> processed) {
        block12: {
            PsiClass[] superClasses;
            block13: {
                PsiMethod[] superMethods;
                Project project;
                if (listOwner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
                }
                if (annotationFQN == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
                }
                if (!listOwner.isValid()) {
                    return false;
                }
                PsiModifierList modifierList = listOwner.getModifierList();
                if (modifierList == null) {
                    return false;
                }
                PsiAnnotation annotation = modifierList.findAnnotation(annotationFQN);
                if (annotation != null) {
                    return true;
                }
                if (!(skipExternal || ExternalAnnotationsManager.getInstance(project = listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) == null && InferredAnnotationsManager.getInstance(project).findInferredAnnotation(listOwner, annotationFQN) == null)) {
                    return true;
                }
                if (!checkHierarchy) break block12;
                if (!(listOwner instanceof PsiMethod)) break block13;
                PsiMethod method = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new THashSet<PsiMember>();
                }
                if (!processed.add(method)) {
                    return false;
                }
                for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated(superMethod, annotationFQN, checkHierarchy, skipExternal, processed)) continue;
                    return true;
                }
                break block12;
            }
            if (!(listOwner instanceof PsiClass)) break block12;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new THashSet<PsiMember>();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : superClasses = clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated(superClass, annotationFQN, checkHierarchy, skipExternal, processed)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        SIMPLE_NAMES = new String[]{"NotNull", "Nullable", "NonNls", "PropertyKey", "TestOnly", "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};
        ALL_ANNOTATIONS = new HashSet<String>(2);
        ALL_ANNOTATIONS.add("org.jetbrains.annotations.Nullable");
        ALL_ANNOTATIONS.add("org.jetbrains.annotations.NotNull");
    }
}

