/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.operation.AssignmentTranslator;
import org.jetbrains.k2js.translate.operation.OperatorTable;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class IntrinsicAssignmentTranslator
extends AssignmentTranslator {
    @NotNull
    public static JsExpression doTranslate(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "doTranslate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "doTranslate"));
        }
        JsExpression jsExpression = new IntrinsicAssignmentTranslator(expression, context).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "doTranslate"));
        }
        return jsExpression;
    }

    private IntrinsicAssignmentTranslator(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "<init>"));
        }
        super(expression, context);
    }

    @NotNull
    private JsExpression translate() {
        if (PsiUtils.isAssignment(PsiUtils.getOperationToken(this.expression))) {
            JsExpression jsExpression = this.translateAsPlainAssignment();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.translateAsAssignmentOperation();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "translate"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateAsAssignmentOperation() {
        if (this.expression.getLeft() instanceof JetSimpleNameExpression) {
            JsExpression jsExpression = this.translateAsPlainAssignmentOperation();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "translateAsAssignmentOperation"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.translateAsAssignToCounterpart();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "translateAsAssignmentOperation"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateAsAssignToCounterpart() {
        JsBinaryOperator operator = this.getCounterpartOperator();
        JsBinaryOperation counterpartOperation = new JsBinaryOperation(operator, this.accessTranslator.translateAsGet(), this.right);
        JsExpression jsExpression = this.accessTranslator.translateAsSet(counterpartOperation);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "translateAsAssignToCounterpart"));
        }
        return jsExpression;
    }

    @NotNull
    private JsBinaryOperator getCounterpartOperator() {
        JetToken assignmentOperationToken = PsiUtils.getOperationToken(this.expression);
        assert (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(assignmentOperationToken));
        JetToken counterpartToken = (JetToken)OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.get(assignmentOperationToken);
        assert (OperatorTable.hasCorrespondingBinaryOperator(counterpartToken)) : "Unsupported token encountered: " + counterpartToken.toString();
        JsBinaryOperator jsBinaryOperator = OperatorTable.getBinaryOperator(counterpartToken);
        if (jsBinaryOperator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "getCounterpartOperator"));
        }
        return jsBinaryOperator;
    }

    @NotNull
    private JsExpression translateAsPlainAssignmentOperation() {
        JsBinaryOperator operator = this.getAssignmentOperator();
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(operator, this.accessTranslator.translateAsGet(), this.right);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "translateAsPlainAssignmentOperation"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    private JsBinaryOperator getAssignmentOperator() {
        JetToken token = PsiUtils.getOperationToken(this.expression);
        assert (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(token));
        assert (OperatorTable.hasCorrespondingBinaryOperator(token)) : "Unsupported token encountered: " + token.toString();
        JsBinaryOperator jsBinaryOperator = OperatorTable.getBinaryOperator(token);
        if (jsBinaryOperator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "getAssignmentOperator"));
        }
        return jsBinaryOperator;
    }

    @NotNull
    private JsExpression translateAsPlainAssignment() {
        JsExpression jsExpression = this.accessTranslator.translateAsSet(this.right);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/IntrinsicAssignmentTranslator", "translateAsPlainAssignment"));
        }
        return jsExpression;
    }
}

