/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lexer;

import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.kdoc.lexer.KDocTokens;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetModifierKeywordToken;
import org.jetbrains.jet.lexer.JetSingleValueToken;
import org.jetbrains.jet.lexer.JetToken;

public interface JetTokens {
    public static final JetToken EOF = new JetToken("EOF");
    public static final JetToken BLOCK_COMMENT = new JetToken("BLOCK_COMMENT");
    public static final JetToken EOL_COMMENT = new JetToken("EOL_COMMENT");
    public static final JetToken SHEBANG_COMMENT = new JetToken("SHEBANG_COMMENT");
    public static final IElementType DOC_COMMENT = KDocTokens.KDOC;
    public static final IElementType WHITE_SPACE = TokenType.WHITE_SPACE;
    public static final JetToken INTEGER_LITERAL = new JetToken("INTEGER_LITERAL");
    public static final JetToken FLOAT_LITERAL = new JetToken("FLOAT_CONSTANT");
    public static final JetToken CHARACTER_LITERAL = new JetToken("CHARACTER_LITERAL");
    public static final JetToken CLOSING_QUOTE = new JetToken("CLOSING_QUOTE");
    public static final JetToken OPEN_QUOTE = new JetToken("OPEN_QUOTE");
    public static final JetToken REGULAR_STRING_PART = new JetToken("REGULAR_STRING_PART");
    public static final JetToken ESCAPE_SEQUENCE = new JetToken("ESCAPE_SEQUENCE");
    public static final JetToken SHORT_TEMPLATE_ENTRY_START = new JetToken("SHORT_TEMPLATE_ENTRY_START");
    public static final JetToken LONG_TEMPLATE_ENTRY_START = new JetToken("LONG_TEMPLATE_ENTRY_START");
    public static final JetToken LONG_TEMPLATE_ENTRY_END = new JetToken("LONG_TEMPLATE_ENTRY_END");
    public static final JetToken DANGLING_NEWLINE = new JetToken("DANGLING_NEWLINE");
    public static final JetKeywordToken PACKAGE_KEYWORD = JetKeywordToken.keyword("package");
    public static final JetKeywordToken AS_KEYWORD = JetKeywordToken.keyword("as");
    public static final JetKeywordToken TYPE_KEYWORD = JetKeywordToken.keyword("type");
    public static final JetKeywordToken CLASS_KEYWORD = JetKeywordToken.keyword("class");
    public static final JetKeywordToken THIS_KEYWORD = JetKeywordToken.keyword("this");
    public static final JetKeywordToken SUPER_KEYWORD = JetKeywordToken.keyword("super");
    public static final JetKeywordToken VAL_KEYWORD = JetKeywordToken.keyword("val");
    public static final JetKeywordToken VAR_KEYWORD = JetKeywordToken.keyword("var");
    public static final JetKeywordToken FUN_KEYWORD = JetKeywordToken.keyword("fun");
    public static final JetKeywordToken FOR_KEYWORD = JetKeywordToken.keyword("for");
    public static final JetKeywordToken NULL_KEYWORD = JetKeywordToken.keyword("null");
    public static final JetKeywordToken TRUE_KEYWORD = JetKeywordToken.keyword("true");
    public static final JetKeywordToken FALSE_KEYWORD = JetKeywordToken.keyword("false");
    public static final JetKeywordToken IS_KEYWORD = JetKeywordToken.keyword("is");
    public static final JetModifierKeywordToken IN_KEYWORD = JetModifierKeywordToken.keywordModifier("in");
    public static final JetKeywordToken THROW_KEYWORD = JetKeywordToken.keyword("throw");
    public static final JetKeywordToken RETURN_KEYWORD = JetKeywordToken.keyword("return");
    public static final JetKeywordToken BREAK_KEYWORD = JetKeywordToken.keyword("break");
    public static final JetKeywordToken CONTINUE_KEYWORD = JetKeywordToken.keyword("continue");
    public static final JetKeywordToken OBJECT_KEYWORD = JetKeywordToken.keyword("object");
    public static final JetKeywordToken IF_KEYWORD = JetKeywordToken.keyword("if");
    public static final JetKeywordToken TRY_KEYWORD = JetKeywordToken.keyword("try");
    public static final JetKeywordToken ELSE_KEYWORD = JetKeywordToken.keyword("else");
    public static final JetKeywordToken WHILE_KEYWORD = JetKeywordToken.keyword("while");
    public static final JetKeywordToken DO_KEYWORD = JetKeywordToken.keyword("do");
    public static final JetKeywordToken WHEN_KEYWORD = JetKeywordToken.keyword("when");
    public static final JetKeywordToken TRAIT_KEYWORD = JetKeywordToken.keyword("trait");
    public static final JetKeywordToken CAPITALIZED_THIS_KEYWORD = JetKeywordToken.keyword("This");
    public static final JetToken AS_SAFE = JetKeywordToken.keyword("AS_SAFE");
    public static final JetToken IDENTIFIER = new JetToken("IDENTIFIER");
    public static final JetToken LABEL_IDENTIFIER = new JetToken("LABEL_IDENTIFIER");
    public static final JetToken FIELD_IDENTIFIER = new JetToken("FIELD_IDENTIFIER");
    public static final JetSingleValueToken LBRACKET = new JetSingleValueToken("LBRACKET", "[");
    public static final JetSingleValueToken RBRACKET = new JetSingleValueToken("RBRACKET", "]");
    public static final JetSingleValueToken LBRACE = new JetSingleValueToken("LBRACE", "{");
    public static final JetSingleValueToken RBRACE = new JetSingleValueToken("RBRACE", "}");
    public static final JetSingleValueToken LPAR = new JetSingleValueToken("LPAR", "(");
    public static final JetSingleValueToken RPAR = new JetSingleValueToken("RPAR", ")");
    public static final JetSingleValueToken DOT = new JetSingleValueToken("DOT", ".");
    public static final JetSingleValueToken PLUSPLUS = new JetSingleValueToken("PLUSPLUS", "++");
    public static final JetSingleValueToken MINUSMINUS = new JetSingleValueToken("MINUSMINUS", "--");
    public static final JetSingleValueToken MUL = new JetSingleValueToken("MUL", "*");
    public static final JetSingleValueToken PLUS = new JetSingleValueToken("PLUS", "+");
    public static final JetSingleValueToken MINUS = new JetSingleValueToken("MINUS", "-");
    public static final JetSingleValueToken EXCL = new JetSingleValueToken("EXCL", "!");
    public static final JetSingleValueToken DIV = new JetSingleValueToken("DIV", "/");
    public static final JetSingleValueToken PERC = new JetSingleValueToken("PERC", "%");
    public static final JetSingleValueToken LT = new JetSingleValueToken("LT", "<");
    public static final JetSingleValueToken GT = new JetSingleValueToken("GT", ">");
    public static final JetSingleValueToken LTEQ = new JetSingleValueToken("LTEQ", "<=");
    public static final JetSingleValueToken GTEQ = new JetSingleValueToken("GTEQ", ">=");
    public static final JetSingleValueToken EQEQEQ = new JetSingleValueToken("EQEQEQ", "===");
    public static final JetSingleValueToken ARROW = new JetSingleValueToken("ARROW", "->");
    public static final JetSingleValueToken DOUBLE_ARROW = new JetSingleValueToken("DOUBLE_ARROW", "=>");
    public static final JetSingleValueToken EXCLEQEQEQ = new JetSingleValueToken("EXCLEQEQEQ", "!==");
    public static final JetSingleValueToken EQEQ = new JetSingleValueToken("EQEQ", "==");
    public static final JetSingleValueToken EXCLEQ = new JetSingleValueToken("EXCLEQ", "!=");
    public static final JetSingleValueToken EXCLEXCL = new JetSingleValueToken("EXCLEXCL", "!!");
    public static final JetSingleValueToken ANDAND = new JetSingleValueToken("ANDAND", "&&");
    public static final JetSingleValueToken OROR = new JetSingleValueToken("OROR", "||");
    public static final JetSingleValueToken SAFE_ACCESS = new JetSingleValueToken("SAFE_ACCESS", "?.");
    public static final JetSingleValueToken ELVIS = new JetSingleValueToken("ELVIS", "?:");
    public static final JetSingleValueToken QUEST = new JetSingleValueToken("QUEST", "?");
    public static final JetSingleValueToken COLONCOLON = new JetSingleValueToken("COLONCOLON", "::");
    public static final JetSingleValueToken COLON = new JetSingleValueToken("COLON", ":");
    public static final JetSingleValueToken SEMICOLON = new JetSingleValueToken("SEMICOLON", ";");
    public static final JetSingleValueToken RANGE = new JetSingleValueToken("RANGE", "..");
    public static final JetSingleValueToken EQ = new JetSingleValueToken("EQ", "=");
    public static final JetSingleValueToken MULTEQ = new JetSingleValueToken("MULTEQ", "*=");
    public static final JetSingleValueToken DIVEQ = new JetSingleValueToken("DIVEQ", "/=");
    public static final JetSingleValueToken PERCEQ = new JetSingleValueToken("PERCEQ", "%=");
    public static final JetSingleValueToken PLUSEQ = new JetSingleValueToken("PLUSEQ", "+=");
    public static final JetSingleValueToken MINUSEQ = new JetSingleValueToken("MINUSEQ", "-=");
    public static final JetKeywordToken NOT_IN = JetKeywordToken.keyword("NOT_IN", "!in");
    public static final JetKeywordToken NOT_IS = JetKeywordToken.keyword("NOT_IS", "!is");
    public static final JetSingleValueToken HASH = new JetSingleValueToken("HASH", "#");
    public static final JetSingleValueToken COMMA = new JetSingleValueToken("COMMA", ",");
    public static final JetToken EOL_OR_SEMICOLON = new JetToken("EOL_OR_SEMICOLON");
    public static final JetKeywordToken IMPORT_KEYWORD = JetKeywordToken.softKeyword("import");
    public static final JetKeywordToken WHERE_KEYWORD = JetKeywordToken.softKeyword("where");
    public static final JetKeywordToken BY_KEYWORD = JetKeywordToken.softKeyword("by");
    public static final JetKeywordToken GET_KEYWORD = JetKeywordToken.softKeyword("get");
    public static final JetKeywordToken SET_KEYWORD = JetKeywordToken.softKeyword("set");
    public static final JetModifierKeywordToken ABSTRACT_KEYWORD = JetModifierKeywordToken.softKeywordModifier("abstract");
    public static final JetModifierKeywordToken ENUM_KEYWORD = JetModifierKeywordToken.softKeywordModifier("enum");
    public static final JetModifierKeywordToken OPEN_KEYWORD = JetModifierKeywordToken.softKeywordModifier("open");
    public static final JetModifierKeywordToken INNER_KEYWORD = JetModifierKeywordToken.softKeywordModifier("inner");
    public static final JetModifierKeywordToken ANNOTATION_KEYWORD = JetModifierKeywordToken.softKeywordModifier("annotation");
    public static final JetModifierKeywordToken OVERRIDE_KEYWORD = JetModifierKeywordToken.softKeywordModifier("override");
    public static final JetModifierKeywordToken PRIVATE_KEYWORD = JetModifierKeywordToken.softKeywordModifier("private");
    public static final JetModifierKeywordToken PUBLIC_KEYWORD = JetModifierKeywordToken.softKeywordModifier("public");
    public static final JetModifierKeywordToken INTERNAL_KEYWORD = JetModifierKeywordToken.softKeywordModifier("internal");
    public static final JetModifierKeywordToken PROTECTED_KEYWORD = JetModifierKeywordToken.softKeywordModifier("protected");
    public static final JetKeywordToken CATCH_KEYWORD = JetKeywordToken.softKeyword("catch");
    public static final JetModifierKeywordToken OUT_KEYWORD = JetModifierKeywordToken.softKeywordModifier("out");
    public static final JetModifierKeywordToken VARARG_KEYWORD = JetModifierKeywordToken.softKeywordModifier("vararg");
    public static final JetModifierKeywordToken REIFIED_KEYWORD = JetModifierKeywordToken.softKeywordModifier("reified");
    public static final JetKeywordToken FINALLY_KEYWORD = JetKeywordToken.softKeyword("finally");
    public static final JetModifierKeywordToken FINAL_KEYWORD = JetModifierKeywordToken.softKeywordModifier("final");
    public static final TokenSet KEYWORDS = TokenSet.create(PACKAGE_KEYWORD, AS_KEYWORD, TYPE_KEYWORD, CLASS_KEYWORD, TRAIT_KEYWORD, THIS_KEYWORD, SUPER_KEYWORD, VAL_KEYWORD, VAR_KEYWORD, FUN_KEYWORD, FOR_KEYWORD, NULL_KEYWORD, TRUE_KEYWORD, FALSE_KEYWORD, IS_KEYWORD, IN_KEYWORD, THROW_KEYWORD, RETURN_KEYWORD, BREAK_KEYWORD, CONTINUE_KEYWORD, OBJECT_KEYWORD, IF_KEYWORD, ELSE_KEYWORD, WHILE_KEYWORD, DO_KEYWORD, TRY_KEYWORD, WHEN_KEYWORD, NOT_IN, NOT_IS, CAPITALIZED_THIS_KEYWORD, AS_SAFE);
    public static final TokenSet SOFT_KEYWORDS = TokenSet.create(IMPORT_KEYWORD, WHERE_KEYWORD, BY_KEYWORD, GET_KEYWORD, SET_KEYWORD, ABSTRACT_KEYWORD, ENUM_KEYWORD, OPEN_KEYWORD, INNER_KEYWORD, ANNOTATION_KEYWORD, OVERRIDE_KEYWORD, PRIVATE_KEYWORD, PUBLIC_KEYWORD, INTERNAL_KEYWORD, PROTECTED_KEYWORD, CATCH_KEYWORD, FINALLY_KEYWORD, OUT_KEYWORD, FINAL_KEYWORD, VARARG_KEYWORD, REIFIED_KEYWORD);
    public static final JetModifierKeywordToken[] MODIFIER_KEYWORDS_ARRAY = new JetModifierKeywordToken[]{ABSTRACT_KEYWORD, ENUM_KEYWORD, OPEN_KEYWORD, INNER_KEYWORD, ANNOTATION_KEYWORD, OVERRIDE_KEYWORD, PRIVATE_KEYWORD, PUBLIC_KEYWORD, INTERNAL_KEYWORD, PROTECTED_KEYWORD, OUT_KEYWORD, IN_KEYWORD, FINAL_KEYWORD, VARARG_KEYWORD, REIFIED_KEYWORD};
    public static final TokenSet MODIFIER_KEYWORDS = TokenSet.create(MODIFIER_KEYWORDS_ARRAY);
    public static final TokenSet VISIBILITY_MODIFIERS = TokenSet.create(PRIVATE_KEYWORD, PUBLIC_KEYWORD, INTERNAL_KEYWORD, PROTECTED_KEYWORD);
    public static final TokenSet WHITESPACES = TokenSet.create(TokenType.WHITE_SPACE);
    public static final TokenSet COMMENTS = TokenSet.create(EOL_COMMENT, BLOCK_COMMENT, DOC_COMMENT, SHEBANG_COMMENT);
    public static final TokenSet WHITE_SPACE_OR_COMMENT_BIT_SET = TokenSet.orSet(COMMENTS, TokenSet.create(WHITE_SPACE));
    public static final TokenSet STRINGS = TokenSet.create(CHARACTER_LITERAL, REGULAR_STRING_PART);
    public static final TokenSet OPERATIONS = TokenSet.create(AS_KEYWORD, AS_SAFE, IS_KEYWORD, IN_KEYWORD, DOT, PLUSPLUS, MINUSMINUS, EXCLEXCL, MUL, PLUS, MINUS, EXCL, DIV, PERC, LT, GT, LTEQ, GTEQ, EQEQEQ, EXCLEQEQEQ, EQEQ, EXCLEQ, ANDAND, OROR, SAFE_ACCESS, ELVIS, COLON, RANGE, EQ, MULTEQ, DIVEQ, PERCEQ, PLUSEQ, MINUSEQ, NOT_IN, NOT_IS, IDENTIFIER, LABEL_IDENTIFIER);
    public static final TokenSet AUGMENTED_ASSIGNMENTS = TokenSet.create(PLUSEQ, MINUSEQ, MULTEQ, PERCEQ, DIVEQ);
    public static final TokenSet ALL_ASSIGNMENTS = TokenSet.create(EQ, PLUSEQ, MINUSEQ, MULTEQ, PERCEQ, DIVEQ);
}

