/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.utils.DFS;

public class BoundsSubstitutor {
    private static final Function<TypeProjection, JetType> PROJECTIONS_TO_TYPES = new Function<TypeProjection, JetType>(){

        @Override
        public JetType apply(TypeProjection projection) {
            return projection.getType();
        }
    };

    private BoundsSubstitutor() {
    }

    @NotNull
    public static <D extends CallableDescriptor> D substituteBounds(@NotNull D functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/types/BoundsSubstitutor", "substituteBounds"));
        }
        List<TypeParameterDescriptor> typeParameters = functionDescriptor.getTypeParameters();
        if (typeParameters.isEmpty()) {
            D d = functionDescriptor;
            if (d == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/BoundsSubstitutor", "substituteBounds"));
            }
            return d;
        }
        CallableDescriptor substitutedFunction = functionDescriptor.substitute(BoundsSubstitutor.createUpperBoundsSubstitutor(typeParameters));
        assert (substitutedFunction != null) : "Substituting upper bounds should always be legal";
        CallableDescriptor callableDescriptor = substitutedFunction;
        if (callableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/BoundsSubstitutor", "substituteBounds"));
        }
        return (D)callableDescriptor;
    }

    @NotNull
    private static TypeSubstitutor createUpperBoundsSubstitutor(@NotNull List<TypeParameterDescriptor> typeParameters) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/types/BoundsSubstitutor", "createUpperBoundsSubstitutor"));
        }
        HashMap<TypeConstructor, TypeProjection> mutableSubstitution = new HashMap<TypeConstructor, TypeProjection>();
        TypeSubstitutor substitutor = TypeSubstitutor.create(mutableSubstitution);
        for (TypeParameterDescriptor descriptor : BoundsSubstitutor.topologicallySortTypeParameters(typeParameters)) {
            JetType upperBoundsAsType = descriptor.getUpperBoundsAsType();
            JetType substitutedUpperBoundsAsType = substitutor.substitute(upperBoundsAsType, Variance.INVARIANT);
            mutableSubstitution.put(descriptor.getTypeConstructor(), new TypeProjectionImpl(substitutedUpperBoundsAsType));
        }
        TypeSubstitutor typeSubstitutor = substitutor;
        if (typeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/BoundsSubstitutor", "createUpperBoundsSubstitutor"));
        }
        return typeSubstitutor;
    }

    @NotNull
    private static List<TypeParameterDescriptor> topologicallySortTypeParameters(final @NotNull List<TypeParameterDescriptor> typeParameters) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/types/BoundsSubstitutor", "topologicallySortTypeParameters"));
        }
        List<TypeParameterDescriptor> topOrder = DFS.topologicalOrder(typeParameters, new DFS.Neighbors<TypeParameterDescriptor>(){

            @Override
            @NotNull
            public Iterable<TypeParameterDescriptor> getNeighbors(TypeParameterDescriptor current) {
                List list = BoundsSubstitutor.getTypeParametersFromUpperBounds(current, typeParameters);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/BoundsSubstitutor$2", "getNeighbors"));
                }
                return list;
            }
        });
        assert (topOrder.size() == typeParameters.size()) : "All type parameters must be visited, but only " + topOrder + " were";
        Collections.reverse(topOrder);
        List<TypeParameterDescriptor> list = topOrder;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/BoundsSubstitutor", "topologicallySortTypeParameters"));
        }
        return list;
    }

    @NotNull
    private static List<TypeParameterDescriptor> getTypeParametersFromUpperBounds(@NotNull TypeParameterDescriptor current, final @NotNull List<TypeParameterDescriptor> typeParameters) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/jet/lang/types/BoundsSubstitutor", "getTypeParametersFromUpperBounds"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/types/BoundsSubstitutor", "getTypeParametersFromUpperBounds"));
        }
        List list = DFS.dfs(current.getUpperBounds(), new DFS.Neighbors<JetType>(){

            @Override
            @NotNull
            public Iterable<JetType> getNeighbors(JetType current) {
                Collection<JetType> collection = Collections2.transform(current.getArguments(), PROJECTIONS_TO_TYPES);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/BoundsSubstitutor$3", "getNeighbors"));
                }
                return collection;
            }
        }, new DFS.NodeHandlerWithListResult<JetType, TypeParameterDescriptor>(){

            @Override
            public boolean beforeChildren(JetType current) {
                ClassifierDescriptor declarationDescriptor = current.getConstructor().getDeclarationDescriptor();
                if (typeParameters.contains(declarationDescriptor)) {
                    ((LinkedList)this.result).add((TypeParameterDescriptor)declarationDescriptor);
                }
                return true;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/BoundsSubstitutor", "getTypeParametersFromUpperBounds"));
        }
        return list;
    }
}

