/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin.incremental;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.kotlin.incremental.IncrementalCache;
import org.jetbrains.jet.lang.resolve.name.FqName;

@KotlinSyntheticClass(abiVersion=17, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class IncrementalPackage-IncrementalCache-f1dd80fe {
    @NotNull
    public static final Collection<FqName> getPackagesWithRemovedFiles(@JetValueParameter(name="$receiver") IncrementalCache $receiver, @JetValueParameter(name="moduleId") @NotNull String moduleId, @JetValueParameter(name="compiledSourceFiles") @NotNull Collection<? extends JetFile> compiledSourceFiles) {
        Iterable iterable;
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/jet/lang/resolve/kotlin/incremental/IncrementalPackage-IncrementalCache-f1dd80fe", "getPackagesWithRemovedFiles"));
        }
        if (compiledSourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiledSourceFiles", "org/jetbrains/jet/lang/resolve/kotlin/incremental/IncrementalPackage-IncrementalCache-f1dd80fe", "getPackagesWithRemovedFiles"));
        }
        Intrinsics.checkParameterIsNotNull(moduleId, "moduleId");
        Intrinsics.checkParameterIsNotNull(compiledSourceFiles, "compiledSourceFiles");
        Iterable iterable2 = iterable = (Iterable)IncrementalPackage-IncrementalCache-f1dd80fe.getRemovedPackageParts($receiver, moduleId, compiledSourceFiles);
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            JvmClassName it = (JvmClassName)t;
            FqName fqName = it.getFqNameForClassNameWithoutDollars();
            Intrinsics.checkReturnedValueIsNotNull(fqName, "JvmClassName", "getFqNameForClassNameWithoutDollars");
            FqName fqName2 = fqName.parent();
            Intrinsics.checkReturnedValueIsNotNull(fqName2, "FqName", "parent");
            collection.add(fqName2);
        }
        Collection collection2 = (ArrayList)collection;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/incremental/IncrementalPackage-IncrementalCache-f1dd80fe", "getPackagesWithRemovedFiles"));
        }
        return collection2;
    }

    @NotNull
    public static final Collection<JvmClassName> getRemovedPackageParts(@JetValueParameter(name="$receiver") IncrementalCache $receiver, @JetValueParameter(name="moduleId") @NotNull String moduleId, @JetValueParameter(name="compiledSourceFiles") @NotNull Collection<? extends JetFile> compiledSourceFiles) {
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/jet/lang/resolve/kotlin/incremental/IncrementalPackage-IncrementalCache-f1dd80fe", "getRemovedPackageParts"));
        }
        if (compiledSourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiledSourceFiles", "org/jetbrains/jet/lang/resolve/kotlin/incremental/IncrementalPackage-IncrementalCache-f1dd80fe", "getRemovedPackageParts"));
        }
        Intrinsics.checkParameterIsNotNull(moduleId, "moduleId");
        Intrinsics.checkParameterIsNotNull(compiledSourceFiles, "compiledSourceFiles");
        HashMap compiledSourceFilesToFqName = new HashMap();
        for (JetFile iterable : compiledSourceFiles) {
            Map map2 = compiledSourceFilesToFqName;
            VirtualFile virtualFile = iterable.getVirtualFile();
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            String string = virtualFile.getPath();
            Intrinsics.checkReturnedValueIsNotNull(string, "VirtualFile", "getPath");
            File file = new File(string);
            FqName fqName = iterable.getPackageFqName();
            Intrinsics.checkReturnedValueIsNotNull(fqName, "JetFile", "getPackageFqName");
            String string2 = fqName.asString();
            Intrinsics.checkReturnedValueIsNotNull(string2, "FqName", "asString");
            KotlinPackage.set(map2, file, string2);
        }
        Iterable iterable = $receiver.getRemovedPackageParts(moduleId, compiledSourceFilesToFqName);
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        Iterator iterator2 = iterable2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            String it = (String)t;
            JvmClassName jvmClassName = JvmClassName.byInternalName(it);
            Intrinsics.checkReturnedValueIsNotNull(jvmClassName, "JvmClassName", "byInternalName");
            collection.add(jvmClassName);
        }
        Collection collection2 = (ArrayList)collection;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/incremental/IncrementalPackage-IncrementalCache-f1dd80fe", "getRemovedPackageParts"));
        }
        return collection2;
    }

    @Nullable
    public static final byte[] getPackageData(@JetValueParameter(name="$receiver") IncrementalCache $receiver, @JetValueParameter(name="moduleId") @NotNull String moduleId, @JetValueParameter(name="fqName") @NotNull FqName fqName) {
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/jet/lang/resolve/kotlin/incremental/IncrementalPackage-IncrementalCache-f1dd80fe", "getPackageData"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/kotlin/incremental/IncrementalPackage-IncrementalCache-f1dd80fe", "getPackageData"));
        }
        Intrinsics.checkParameterIsNotNull(moduleId, "moduleId");
        Intrinsics.checkParameterIsNotNull(fqName, "fqName");
        String string = fqName.asString();
        Intrinsics.checkReturnedValueIsNotNull(string, "FqName", "asString");
        return $receiver.getPackageData(moduleId, string);
    }
}

