/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotatedCallableKind;
import org.jetbrains.jet.descriptors.serialization.descriptors.ConstantLoader;
import org.jetbrains.jet.lang.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.kotlin.BaseDescriptorLoader;
import org.jetbrains.jet.lang.resolve.kotlin.DescriptorLoadersStorage;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinClassFinder;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;

public class ConstantDescriptorLoader
extends BaseDescriptorLoader
implements ConstantLoader {
    @Override
    @Inject
    public void setStorage(@NotNull DescriptorLoadersStorage storage) {
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "setStorage"));
        }
        this.storage = storage;
    }

    @Override
    @Inject
    public void setKotlinClassFinder(@NotNull KotlinClassFinder kotlinClassFinder) {
        if (kotlinClassFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClassFinder", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "setKotlinClassFinder"));
        }
        this.kotlinClassFinder = kotlinClassFinder;
    }

    @Override
    @Inject
    public void setErrorReporter(@NotNull ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "setErrorReporter"));
        }
        this.errorReporter = errorReporter;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> loadPropertyConstant(@NotNull ClassOrPackageFragmentDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotatedCallableKind kind) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "loadPropertyConstant"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "loadPropertyConstant"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "loadPropertyConstant"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "loadPropertyConstant"));
        }
        DescriptorLoadersStorage.MemberSignature signature = ConstantDescriptorLoader.getCallableSignature(proto, nameResolver, kind);
        if (signature == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinClass = this.findClassWithAnnotationsAndInitializers(container, proto, nameResolver, kind);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading property constant is not found: " + container, null);
            return null;
        }
        return ((DescriptorLoadersStorage.Storage)this.storage.getStorage().invoke(kotlinClass)).getPropertyConstants().get(signature);
    }
}

