/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.diagnostics.rendering.Renderers;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.PsiPackage;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TraceEntryFilter;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class DelegatedPropertyResolver {
    @NotNull
    private ExpressionTypingServices expressionTypingServices;
    @NotNull
    private CallResolver callResolver;

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setCallResolver(@NotNull CallResolver callResolver) {
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "setCallResolver"));
        }
        this.callResolver = callResolver;
    }

    @Nullable
    public JetType getDelegatedPropertyGetMethodReturnType(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull BindingTrace trace, @NotNull JetScope scope) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "getDelegatedPropertyGetMethodReturnType"));
        }
        this.resolveDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, delegateType, trace, scope, true);
        ResolvedCall<FunctionDescriptor> resolvedCall = trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, propertyDescriptor.getGetter());
        return resolvedCall != null ? resolvedCall.getResultingDescriptor().getReturnType() : null;
    }

    public void resolveDelegatedPropertyGetMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull BindingTrace trace, @NotNull JetScope scope) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyGetMethod"));
        }
        JetType returnType = this.getDelegatedPropertyGetMethodReturnType(propertyDescriptor, delegateExpression, delegateType, trace, scope);
        JetType propertyType = propertyDescriptor.getType();
        if (!(propertyType instanceof DeferredType) && returnType != null && !JetTypeChecker.DEFAULT.isSubtypeOf(returnType, propertyType)) {
            Call call = trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, propertyDescriptor.getGetter());
            assert (call != null) : "Call should exists for " + propertyDescriptor.getGetter();
            trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH.on(delegateExpression, this.renderCall(call, trace.getBindingContext()), propertyDescriptor.getType(), returnType));
        }
    }

    public void resolveDelegatedPropertySetMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull BindingTrace trace, @NotNull JetScope scope) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertySetMethod"));
        }
        this.resolveDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, delegateType, trace, scope, false);
    }

    private void resolveDelegatedPropertyConventionMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull BindingTrace trace, @NotNull JetScope scope, boolean isGet) {
        PropertyAccessorDescriptor accessor;
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegatedPropertyConventionMethod"));
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        assert (accessor != null) : "Delegated property should have getter/setter " + propertyDescriptor + " " + delegateExpression.getText();
        if (trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor) != null) {
            return;
        }
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.getDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, delegateType, trace, scope, isGet);
        Call call = trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor);
        assert (call != null) : "'getDelegatedPropertyConventionMethod' didn't record a call";
        if (!functionResults.isSuccess()) {
            String expectedFunction = this.renderCall(call, trace.getBindingContext());
            if (functionResults.isIncomplete()) {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.on(delegateExpression, expectedFunction, delegateType));
            } else if (functionResults.isSingleResult() || functionResults.getResultCode() == OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES) {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE.on(delegateExpression, expectedFunction, functionResults.getResultingCalls()));
            } else if (functionResults.isAmbiguity()) {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY.on(delegateExpression, expectedFunction, functionResults.getResultingCalls()));
            } else {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.on(delegateExpression, expectedFunction, delegateType));
            }
            return;
        }
        trace.record(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor, functionResults.getResultingCall());
    }

    public OverloadResolutionResults<FunctionDescriptor> getDelegatedPropertyConventionMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull BindingTrace trace, @NotNull JetScope scope, boolean isGet) {
        PropertyAccessorDescriptor accessor;
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        if (delegateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateType", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "getDelegatedPropertyConventionMethod"));
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        assert (accessor != null) : "Delegated property should have getter/setter " + propertyDescriptor + " " + delegateExpression.getText();
        ExpressionTypingContext context = ExpressionTypingContext.newContext(this.expressionTypingServices, trace, scope, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE);
        boolean hasThis = propertyDescriptor.getReceiverParameter() != null || propertyDescriptor.getExpectedThisObject() != null;
        ArrayList<JetExpression> arguments = Lists.newArrayList();
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(delegateExpression);
        arguments.add(psiFactory.createExpression(hasThis ? "this" : "null"));
        arguments.add(psiFactory.createExpression(KotlinBuiltIns.getInstance().getPropertyMetadataImpl().getName().asString() + "(\"" + propertyDescriptor.getName().asString() + "\")"));
        if (!isGet) {
            JetReferenceExpression fakeArgument = (JetReferenceExpression)ExpressionTypingUtils.createFakeExpressionOfType(this.expressionTypingServices.getProject(), trace, "fakeArgument" + arguments.size(), propertyDescriptor.getType());
            arguments.add(fakeArgument);
            List<ValueParameterDescriptor> valueParameters = accessor.getValueParameters();
            trace.record(BindingContext.REFERENCE_TARGET, fakeArgument, valueParameters.get(0));
        }
        Name functionName = Name.identifier(isGet ? "get" : "set");
        JetSimpleNameExpression fakeCalleeExpression = psiFactory.createSimpleName(functionName.asString());
        ExpressionReceiver receiver = new ExpressionReceiver(delegateExpression, delegateType);
        Call call = CallMaker.makeCallWithExpressions(fakeCalleeExpression, receiver, null, fakeCalleeExpression, arguments, Call.CallType.DEFAULT);
        trace.record(BindingContext.DELEGATED_PROPERTY_CALL, accessor, call);
        return this.callResolver.resolveCallWithGivenName(context, call, fakeCalleeExpression, functionName);
    }

    private String renderCall(@NotNull Call call, @NotNull BindingContext context) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "renderCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "renderCall"));
        }
        JetExpression calleeExpression = call.getCalleeExpression();
        assert (calleeExpression != null) : "CalleeExpression should exists for fake call of convention method";
        StringBuilder builder = new StringBuilder(calleeExpression.getText());
        builder.append("(");
        ArrayList<JetType> argumentTypes = Lists.newArrayList();
        for (ValueArgument valueArgument : call.getValueArguments()) {
            argumentTypes.add(context.get(BindingContext.EXPRESSION_TYPE, valueArgument.getArgumentExpression()));
        }
        builder.append(Renderers.RENDER_COLLECTION_OF_TYPES.render(argumentTypes));
        builder.append(")");
        return builder.toString();
    }

    @Nullable
    public JetType resolveDelegateExpression(@NotNull JetExpression delegateExpression, @NotNull JetProperty jetProperty, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope propertyDeclarationInnerScope, @NotNull JetScope accessorScope, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (jetProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetProperty", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (propertyDeclarationInnerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDeclarationInnerScope", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (accessorScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessorScope", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "resolveDelegateExpression"));
        }
        TemporaryBindingTrace traceToResolveDelegatedProperty = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property");
        JetExpression calleeExpression = CallUtilPackage.getCalleeExpressionIfAny(delegateExpression);
        ConstraintSystemCompleter completer = this.createConstraintSystemCompleter(jetProperty, propertyDescriptor, delegateExpression, accessorScope, trace);
        if (calleeExpression != null) {
            traceToResolveDelegatedProperty.record(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, calleeExpression, completer);
        }
        JetType delegateType = this.expressionTypingServices.safeGetType(propertyDeclarationInnerScope, delegateExpression, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, traceToResolveDelegatedProperty);
        traceToResolveDelegatedProperty.commit(new TraceEntryFilter(){

            @Override
            public boolean accept(@Nullable WritableSlice<?, ?> slice, Object key) {
                return slice != BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
            }
        }, true);
        return delegateType;
    }

    @NotNull
    private ConstraintSystemCompleter createConstraintSystemCompleter(@NotNull JetProperty property2, final @NotNull PropertyDescriptor propertyDescriptor, final @NotNull JetExpression delegateExpression, final @NotNull JetScope accessorScope, final @NotNull BindingTrace trace) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        if (accessorScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessorScope", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        final JetType expectedType = property2.getTypeRef() != null ? propertyDescriptor.getType() : TypeUtils.NO_EXPECTED_TYPE;
        ConstraintSystemCompleter constraintSystemCompleter = new ConstraintSystemCompleter(){

            @Override
            public void completeConstraintSystem(@NotNull ConstraintSystem constraintSystem, @NotNull ResolvedCall<?> resolvedCall) {
                FunctionDescriptor descriptor;
                List<ValueParameterDescriptor> valueParameters;
                if (constraintSystem == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver$2", "completeConstraintSystem"));
                }
                if (resolvedCall == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver$2", "completeConstraintSystem"));
                }
                JetType returnType = resolvedCall.getCandidateDescriptor().getReturnType();
                if (returnType == null) {
                    return;
                }
                TemporaryBindingTrace traceToResolveConventionMethods = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property convention methods");
                OverloadResolutionResults<FunctionDescriptor> getMethodResults = DelegatedPropertyResolver.this.getDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, returnType, traceToResolveConventionMethods, accessorScope, true);
                if (this.conventionMethodFound(getMethodResults)) {
                    FunctionDescriptor descriptor2 = getMethodResults.getResultingDescriptor();
                    JetType returnTypeOfGetMethod = descriptor2.getReturnType();
                    if (returnTypeOfGetMethod != null) {
                        constraintSystem.addSupertypeConstraint(expectedType, returnTypeOfGetMethod, ConstraintPosition.FROM_COMPLETER);
                    }
                    this.addConstraintForThisValue(constraintSystem, descriptor2);
                }
                if (!propertyDescriptor.isVar()) {
                    return;
                }
                if (propertyDescriptor.getReturnType() instanceof DeferredType) {
                    return;
                }
                OverloadResolutionResults<FunctionDescriptor> setMethodResults = DelegatedPropertyResolver.this.getDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, returnType, traceToResolveConventionMethods, accessorScope, false);
                if (this.conventionMethodFound(setMethodResults) && (valueParameters = (descriptor = setMethodResults.getResultingDescriptor()).getValueParameters()).size() == 3) {
                    ValueParameterDescriptor valueParameterForThis = valueParameters.get(2);
                    if (!TypeUtils.noExpectedType(expectedType)) {
                        constraintSystem.addSubtypeConstraint(expectedType, valueParameterForThis.getType(), ConstraintPosition.FROM_COMPLETER);
                    }
                    this.addConstraintForThisValue(constraintSystem, descriptor);
                }
            }

            private boolean conventionMethodFound(@NotNull OverloadResolutionResults<FunctionDescriptor> results) {
                if (results == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver$2", "conventionMethodFound"));
                }
                return results.isSuccess() || results.isSingleResult() && results.getResultCode() == OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH;
            }

            private void addConstraintForThisValue(ConstraintSystem constraintSystem, FunctionDescriptor resultingDescriptor) {
                ReceiverParameterDescriptor receiverParameter = propertyDescriptor.getReceiverParameter();
                ReceiverParameterDescriptor thisObject = propertyDescriptor.getExpectedThisObject();
                JetType typeOfThis = receiverParameter != null ? receiverParameter.getType() : (thisObject != null ? thisObject.getType() : KotlinBuiltIns.getInstance().getNullableNothingType());
                List<ValueParameterDescriptor> valueParameters = resultingDescriptor.getValueParameters();
                if (valueParameters.isEmpty()) {
                    return;
                }
                ValueParameterDescriptor valueParameterForThis = valueParameters.get(0);
                constraintSystem.addSubtypeConstraint(typeOfThis, valueParameterForThis.getType(), ConstraintPosition.FROM_COMPLETER);
            }
        };
        if (constraintSystemCompleter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegatedPropertyResolver", "createConstraintSystemCompleter"));
        }
        return constraintSystemCompleter;
    }
}

