/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeType;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.parsing.AbstractJetParsing;
import org.jetbrains.jet.lang.parsing.AbstractTokenStreamPredicate;
import org.jetbrains.jet.lang.parsing.Consumer;
import org.jetbrains.jet.lang.parsing.JetExpressionParsing;
import org.jetbrains.jet.lang.parsing.LastBefore;
import org.jetbrains.jet.lang.parsing.SemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.jet.lang.parsing.SemanticWhitespaceAwarePsiBuilderForByClause;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;

public class JetParsing
extends AbstractJetParsing {
    public static final Map<String, IElementType> MODIFIER_KEYWORD_MAP = new HashMap<String, IElementType>();
    private static final TokenSet TOPLEVEL_OBJECT_FIRST;
    private static final TokenSet ENUM_MEMBER_FIRST;
    private static final TokenSet CLASS_NAME_RECOVERY_SET;
    private static final TokenSet TYPE_PARAMETER_GT_RECOVERY_SET;
    private static final TokenSet PARAMETER_NAME_RECOVERY_SET;
    private static final TokenSet PACKAGE_NAME_RECOVERY_SET;
    private static final TokenSet IMPORT_RECOVERY_SET;
    static final TokenSet TYPE_REF_FIRST;
    private static final TokenSet RECEIVER_TYPE_TERMINATORS;
    private static final TokenSet VALUE_PARAMETER_FIRST;
    private static final TokenSet LAMBDA_VALUE_PARAMETER_FIRST;
    private JetExpressionParsing myExpressionParsing;

    static JetParsing createForTopLevel(SemanticWhitespaceAwarePsiBuilder builder) {
        JetParsing jetParsing = new JetParsing(builder);
        jetParsing.myExpressionParsing = new JetExpressionParsing(builder, jetParsing);
        return jetParsing;
    }

    private static JetParsing createForByClause(SemanticWhitespaceAwarePsiBuilder builder) {
        final SemanticWhitespaceAwarePsiBuilderForByClause builderForByClause = new SemanticWhitespaceAwarePsiBuilderForByClause(builder);
        JetParsing jetParsing = new JetParsing(builderForByClause);
        jetParsing.myExpressionParsing = new JetExpressionParsing(builderForByClause, jetParsing){

            @Override
            protected boolean parseCallWithClosure() {
                if (builderForByClause.getStackSize() > 0) {
                    return super.parseCallWithClosure();
                }
                return false;
            }

            @Override
            protected JetParsing create(SemanticWhitespaceAwarePsiBuilder builder) {
                return JetParsing.createForByClause(builder);
            }
        };
        return jetParsing;
    }

    private JetParsing(SemanticWhitespaceAwarePsiBuilder builder) {
        super(builder);
    }

    void parseFile() {
        PsiBuilder.Marker fileMarker = this.mark();
        this.parsePreamble();
        while (!this.eof()) {
            this.parseTopLevelObject();
        }
        fileMarker.done(JetNodeTypes.JET_FILE);
    }

    void parseTypeCodeFragment() {
        PsiBuilder.Marker marker = this.mark();
        this.parseTypeRef();
        this.checkForUnexpectedSymbols();
        marker.done(JetNodeTypes.TYPE_CODE_FRAGMENT);
    }

    void parseExpressionCodeFragment() {
        PsiBuilder.Marker marker = this.mark();
        this.myExpressionParsing.parseExpression();
        this.checkForUnexpectedSymbols();
        marker.done(JetNodeTypes.EXPRESSION_CODE_FRAGMENT);
    }

    void parseBlockCodeFragment() {
        PsiBuilder.Marker marker = this.mark();
        PsiBuilder.Marker blockMarker = this.mark();
        if (this.at(JetTokens.PACKAGE_KEYWORD) || this.at(JetTokens.IMPORT_KEYWORD)) {
            PsiBuilder.Marker err = this.mark();
            this.parsePreamble();
            err.error("Package directive and imports are forbidden in code fragments");
        }
        this.myExpressionParsing.parseStatements();
        this.checkForUnexpectedSymbols();
        blockMarker.done(JetNodeTypes.BLOCK);
        marker.done(JetNodeTypes.BLOCK_CODE_FRAGMENT);
    }

    void parseScript() {
        PsiBuilder.Marker fileMarker = this.mark();
        this.parsePreamble();
        PsiBuilder.Marker scriptMarker = this.mark();
        PsiBuilder.Marker blockMarker = this.mark();
        this.myExpressionParsing.parseStatements();
        this.checkForUnexpectedSymbols();
        blockMarker.done(JetNodeTypes.BLOCK);
        scriptMarker.done(JetNodeTypes.SCRIPT);
        fileMarker.done(JetNodeTypes.JET_FILE);
    }

    private void checkForUnexpectedSymbols() {
        while (!this.eof()) {
            this.errorAndAdvance("unexpected symbol");
        }
    }

    private void parsePreamble() {
        PsiBuilder.Marker packageDirective = this.mark();
        PsiBuilder.Marker firstEntry = this.mark();
        this.parseModifierList(JetNodeTypes.MODIFIER_LIST, true);
        if (this.at(JetTokens.PACKAGE_KEYWORD)) {
            this.advance();
            this.parsePackageName();
            if (this.at(JetTokens.LBRACE)) {
                firstEntry.rollbackTo();
                packageDirective.done(JetNodeTypes.PACKAGE_DIRECTIVE);
                return;
            }
            firstEntry.drop();
            this.consumeIf(JetTokens.SEMICOLON);
        } else {
            firstEntry.rollbackTo();
        }
        packageDirective.done(JetNodeTypes.PACKAGE_DIRECTIVE);
        this.parseImportDirectives();
    }

    private void parsePackageName() {
        PsiBuilder.Marker qualifiedExpression = this.mark();
        boolean simpleName = true;
        while (true) {
            if (this.myBuilder.newlineBeforeCurrentToken()) {
                this.errorWithRecovery("Package name must be a '.'-separated identifier list placed on a single line", PACKAGE_NAME_RECOVERY_SET);
                break;
            }
            PsiBuilder.Marker nsName = this.mark();
            if (this.expect(JetTokens.IDENTIFIER, "Package name must be a '.'-separated identifier list", PACKAGE_NAME_RECOVERY_SET)) {
                nsName.done(JetNodeTypes.REFERENCE_EXPRESSION);
            } else {
                nsName.drop();
            }
            if (!simpleName) {
                PsiBuilder.Marker precedingMarker = qualifiedExpression.precede();
                qualifiedExpression.done(JetNodeTypes.DOT_QUALIFIED_EXPRESSION);
                qualifiedExpression = precedingMarker;
            }
            if (!this.at(JetTokens.DOT)) break;
            simpleName = false;
            this.advance();
        }
        qualifiedExpression.drop();
    }

    private void parseImportDirective() {
        assert (this._at(JetTokens.IMPORT_KEYWORD));
        PsiBuilder.Marker importDirective = this.mark();
        this.advance();
        if (this.closeImportWithErrorIfNewline(importDirective, "Expecting qualified name")) {
            return;
        }
        PsiBuilder.Marker qualifiedName = this.mark();
        PsiBuilder.Marker reference = this.mark();
        this.expect(JetTokens.IDENTIFIER, "Expecting qualified name");
        reference.done(JetNodeTypes.REFERENCE_EXPRESSION);
        while (this.at(JetTokens.DOT) && this.lookahead(1) != JetTokens.MUL) {
            this.advance();
            if (this.closeImportWithErrorIfNewline(importDirective, "Import must be placed on a single line")) {
                qualifiedName.drop();
                return;
            }
            reference = this.mark();
            if (this.expect(JetTokens.IDENTIFIER, "Qualified name must be a '.'-separated identifier list", IMPORT_RECOVERY_SET)) {
                reference.done(JetNodeTypes.REFERENCE_EXPRESSION);
            } else {
                reference.drop();
            }
            PsiBuilder.Marker precede = qualifiedName.precede();
            qualifiedName.done(JetNodeTypes.DOT_QUALIFIED_EXPRESSION);
            qualifiedName = precede;
        }
        qualifiedName.drop();
        if (this.at(JetTokens.DOT)) {
            this.advance();
            assert (this._at(JetTokens.MUL));
            this.advance();
            if (this.at(JetTokens.AS_KEYWORD)) {
                PsiBuilder.Marker as = this.mark();
                this.advance();
                if (this.closeImportWithErrorIfNewline(importDirective, "Expecting identifier")) {
                    as.drop();
                    return;
                }
                this.consumeIf(JetTokens.IDENTIFIER);
                as.error("Cannot rename all imported items to one identifier");
            }
        }
        if (this.at(JetTokens.AS_KEYWORD)) {
            this.advance();
            if (this.closeImportWithErrorIfNewline(importDirective, "Expecting identifier")) {
                return;
            }
            this.expect(JetTokens.IDENTIFIER, "Expecting identifier", TokenSet.create(JetTokens.SEMICOLON));
        }
        this.consumeIf(JetTokens.SEMICOLON);
        importDirective.done(JetNodeTypes.IMPORT_DIRECTIVE);
    }

    private boolean closeImportWithErrorIfNewline(PsiBuilder.Marker importDirective, String errorMessage) {
        if (this.myBuilder.newlineBeforeCurrentToken()) {
            this.error(errorMessage);
            importDirective.done(JetNodeTypes.IMPORT_DIRECTIVE);
            return true;
        }
        return false;
    }

    private void parseImportDirectives() {
        if (this.at(JetTokens.IMPORT_KEYWORD)) {
            PsiBuilder.Marker importList = this.mark();
            while (this.at(JetTokens.IMPORT_KEYWORD)) {
                this.parseImportDirective();
            }
            importList.done(JetNodeTypes.IMPORT_LIST);
        }
    }

    private void parseTopLevelObject() {
        PsiBuilder.Marker decl = this.mark();
        TokenDetector detector = new TokenDetector(JetTokens.ENUM_KEYWORD);
        this.parseModifierList(JetNodeTypes.MODIFIER_LIST, detector, true);
        IElementType keywordToken = this.tt();
        IElementType declType = null;
        if (keywordToken == JetTokens.CLASS_KEYWORD || keywordToken == JetTokens.TRAIT_KEYWORD) {
            declType = this.parseClass(detector.isDetected());
        } else if (keywordToken == JetTokens.FUN_KEYWORD) {
            declType = this.parseFunction();
        } else if (keywordToken == JetTokens.VAL_KEYWORD || keywordToken == JetTokens.VAR_KEYWORD) {
            declType = this.parseProperty();
        } else if (keywordToken == JetTokens.TYPE_KEYWORD) {
            declType = this.parseTypeDef();
        } else if (keywordToken == JetTokens.OBJECT_KEYWORD) {
            this.parseObject(true, true);
            declType = JetNodeTypes.OBJECT_DECLARATION;
        }
        if (declType == null) {
            this.errorAndAdvance("Expecting package directive or top level declaration");
            decl.drop();
        } else {
            decl.done(declType);
        }
    }

    boolean parseModifierList(IElementType nodeType, boolean allowShortAnnotations) {
        return this.parseModifierList(nodeType, null, allowShortAnnotations);
    }

    boolean parseModifierList(IElementType nodeType, @Nullable Consumer<IElementType> tokenConsumer, boolean allowShortAnnotations) {
        PsiBuilder.Marker list = this.mark();
        boolean empty = true;
        while (!this.eof()) {
            if (this.atSet(JetTokens.MODIFIER_KEYWORDS)) {
                if (tokenConsumer != null) {
                    tokenConsumer.consume(this.tt());
                }
                this.advance();
            } else {
                if (!this.at(JetTokens.LBRACKET) && (!allowShortAnnotations || !this.at(JetTokens.IDENTIFIER))) break;
                this.parseAnnotation(allowShortAnnotations);
            }
            empty = false;
        }
        if (empty) {
            list.drop();
        } else {
            list.done(nodeType);
        }
        return !empty;
    }

    void parseAnnotations(boolean allowShortAnnotations) {
        while (this.parseAnnotation(allowShortAnnotations)) {
        }
    }

    private boolean parseAnnotation(boolean allowShortAnnotations) {
        if (this.at(JetTokens.LBRACKET)) {
            PsiBuilder.Marker annotation = this.mark();
            this.myBuilder.disableNewlines();
            this.advance();
            if (!this.at(JetTokens.IDENTIFIER)) {
                this.error("Expecting a list of attributes");
            } else {
                this.parseAnnotationEntry();
                while (this.at(JetTokens.COMMA)) {
                    this.errorAndAdvance("No commas needed to separate attributes");
                }
                while (this.at(JetTokens.IDENTIFIER)) {
                    this.parseAnnotationEntry();
                    while (this.at(JetTokens.COMMA)) {
                        this.errorAndAdvance("No commas needed to separate attributes");
                    }
                }
            }
            this.expect(JetTokens.RBRACKET, "Expecting ']' to close an attribute annotation");
            this.myBuilder.restoreNewlinesState();
            annotation.done(JetNodeTypes.ANNOTATION);
            return true;
        }
        if (allowShortAnnotations && this.at(JetTokens.IDENTIFIER)) {
            this.parseAnnotationEntry();
            return true;
        }
        return false;
    }

    private void parseAnnotationEntry() {
        assert (this._at(JetTokens.IDENTIFIER));
        PsiBuilder.Marker attribute = this.mark();
        PsiBuilder.Marker reference = this.mark();
        PsiBuilder.Marker typeReference = this.mark();
        this.parseUserType();
        typeReference.done(JetNodeTypes.TYPE_REFERENCE);
        reference.done(JetNodeTypes.CONSTRUCTOR_CALLEE);
        this.parseTypeArgumentList();
        if (this.at(JetTokens.LPAR)) {
            this.myExpressionParsing.parseValueArgumentList();
        }
        attribute.done(JetNodeTypes.ANNOTATION_ENTRY);
    }

    IElementType parseClass(boolean enumClass) {
        assert (this._atSet(JetTokens.CLASS_KEYWORD, JetTokens.TRAIT_KEYWORD));
        this.advance();
        this.expect(JetTokens.IDENTIFIER, "Class name expected", CLASS_NAME_RECOVERY_SET);
        boolean typeParametersDeclared = this.parseTypeParameterList(TYPE_PARAMETER_GT_RECOVERY_SET);
        PsiBuilder.Marker beforeConstructorModifiers = this.mark();
        boolean hasConstructorModifiers = this.parseModifierList(JetNodeTypes.PRIMARY_CONSTRUCTOR_MODIFIER_LIST, false);
        if (hasConstructorModifiers && !this.atSet(JetTokens.LPAR, JetTokens.LBRACE, JetTokens.COLON)) {
            beforeConstructorModifiers.rollbackTo();
            return JetNodeTypes.CLASS;
        }
        beforeConstructorModifiers.drop();
        if (this.at(JetTokens.LPAR)) {
            this.parseValueParameterList(false, TokenSet.create(JetTokens.COLON, JetTokens.LBRACE));
        } else if (hasConstructorModifiers) {
            this.error("Expecting primary constructor parameter list");
        }
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseDelegationSpecifierList();
        }
        this.parseTypeConstraintsGuarded(typeParametersDeclared);
        if (this.at(JetTokens.LBRACE)) {
            if (enumClass) {
                this.parseEnumClassBody();
            } else {
                this.parseClassBody();
            }
        }
        return JetNodeTypes.CLASS;
    }

    private void parseEnumClassBody() {
        if (!this.at(JetTokens.LBRACE)) {
            return;
        }
        PsiBuilder.Marker classBody = this.mark();
        this.myBuilder.enableNewlines();
        this.advance();
        while (!this.eof() && !this.at(JetTokens.RBRACE)) {
            IElementType type;
            PsiBuilder.Marker entryOrMember = this.mark();
            TokenSet constructorNameFollow = TokenSet.create(JetTokens.SEMICOLON, JetTokens.COLON, JetTokens.LPAR, JetTokens.LT, JetTokens.LBRACE);
            int lastId = this.findLastBefore(ENUM_MEMBER_FIRST, constructorNameFollow, false);
            TokenDetector enumDetector = new TokenDetector(JetTokens.ENUM_KEYWORD);
            this.createTruncatedBuilder(lastId).parseModifierList(JetNodeTypes.MODIFIER_LIST, enumDetector, false);
            if (this.at(JetTokens.IDENTIFIER)) {
                this.parseEnumEntry();
                type = JetNodeTypes.ENUM_ENTRY;
            } else {
                type = this.parseMemberDeclarationRest(enumDetector.isDetected());
            }
            if (type == null) {
                this.errorAndAdvance("Expecting an enum entry or member declaration");
                entryOrMember.drop();
                continue;
            }
            entryOrMember.done(type);
        }
        this.expect(JetTokens.RBRACE, "Expecting '}' to close enum class body");
        this.myBuilder.restoreNewlinesState();
        classBody.done(JetNodeTypes.CLASS_BODY);
    }

    private void parseEnumEntry() {
        assert (this._at(JetTokens.IDENTIFIER));
        PsiBuilder.Marker nameAsDeclaration = this.mark();
        this.advance();
        nameAsDeclaration.done(JetNodeTypes.OBJECT_DECLARATION_NAME);
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseInitializerList();
        }
        if (this.at(JetTokens.LBRACE)) {
            this.parseClassBody();
        }
        this.consumeIf(JetTokens.SEMICOLON);
    }

    private void parseClassBody() {
        PsiBuilder.Marker body = this.mark();
        this.myBuilder.enableNewlines();
        if (this.expect(JetTokens.LBRACE, "Expecting a class body")) {
            while (!this.eof() && !this.at(JetTokens.RBRACE)) {
                this.parseMemberDeclaration();
            }
            this.expect(JetTokens.RBRACE, "Missing '}");
        }
        this.myBuilder.restoreNewlinesState();
        body.done(JetNodeTypes.CLASS_BODY);
    }

    private void parseMemberDeclaration() {
        PsiBuilder.Marker decl = this.mark();
        TokenDetector enumDetector = new TokenDetector(JetTokens.ENUM_KEYWORD);
        this.parseModifierList(JetNodeTypes.MODIFIER_LIST, enumDetector, true);
        IElementType declType = this.parseMemberDeclarationRest(enumDetector.isDetected());
        if (declType == null) {
            this.errorWithRecovery("Expecting member declaration", TokenSet.create(JetTokens.RBRACE));
            decl.drop();
        } else {
            decl.done(declType);
        }
    }

    private IElementType parseMemberDeclarationRest(boolean isEnum) {
        IElementType keywordToken = this.tt();
        IElementType declType = null;
        if (keywordToken == JetTokens.CLASS_KEYWORD) {
            declType = this.lookahead(1) == JetTokens.OBJECT_KEYWORD ? this.parseClassObject() : this.parseClass(isEnum);
        } else if (keywordToken == JetTokens.TRAIT_KEYWORD) {
            declType = this.parseClass(isEnum);
        } else if (keywordToken == JetTokens.FUN_KEYWORD) {
            declType = this.parseFunction();
        } else if (keywordToken == JetTokens.VAL_KEYWORD || keywordToken == JetTokens.VAR_KEYWORD) {
            declType = this.parseProperty();
        } else if (keywordToken == JetTokens.TYPE_KEYWORD) {
            declType = this.parseTypeDef();
        } else if (keywordToken == JetTokens.OBJECT_KEYWORD) {
            this.parseObject(true, true);
            declType = JetNodeTypes.OBJECT_DECLARATION;
        } else if (keywordToken == JetTokens.LBRACE) {
            this.parseBlock();
            declType = JetNodeTypes.ANONYMOUS_INITIALIZER;
        }
        return declType;
    }

    void parseObject(boolean named, boolean optionalBody) {
        assert (this._at(JetTokens.OBJECT_KEYWORD));
        this.advance();
        if (named) {
            PsiBuilder.Marker propertyDeclaration = this.mark();
            this.expect(JetTokens.IDENTIFIER, "Expecting object name", TokenSet.create(JetTokens.LBRACE));
            propertyDeclaration.done(JetNodeTypes.OBJECT_DECLARATION_NAME);
        } else if (this.at(JetTokens.IDENTIFIER)) {
            this.error("An object expression cannot bind a name");
        }
        if (optionalBody) {
            if (this.at(JetTokens.COLON)) {
                this.advance();
                this.parseDelegationSpecifierList();
            }
            if (this.at(JetTokens.LBRACE)) {
                this.parseClassBody();
            }
        } else if (this.at(JetTokens.LBRACE)) {
            this.parseClassBody();
        } else {
            this.expect(JetTokens.COLON, "Expecting ':'", TokenSet.create(JetTokens.IDENTIFIER, JetTokens.PACKAGE_KEYWORD));
            this.parseDelegationSpecifierList();
            this.parseClassBody();
        }
    }

    private void parseInitializerList() {
        PsiBuilder.Marker list = this.mark();
        while (true) {
            if (this.at(JetTokens.COMMA)) {
                this.errorAndAdvance("Expecting a this or super constructor call");
            }
            this.parseInitializer();
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        list.done(JetNodeTypes.INITIALIZER_LIST);
    }

    private void parseInitializer() {
        IElementType type;
        PsiBuilder.Marker initializer = this.mark();
        this.parseAnnotations(false);
        if (this.at(JetTokens.THIS_KEYWORD)) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done(JetNodeTypes.THIS_CONSTRUCTOR_REFERENCE);
            type = JetNodeTypes.THIS_CALL;
        } else if (this.atSet(TYPE_REF_FIRST)) {
            PsiBuilder.Marker reference = this.mark();
            this.parseTypeRef();
            reference.done(JetNodeTypes.CONSTRUCTOR_CALLEE);
            type = JetNodeTypes.DELEGATOR_SUPER_CALL;
        } else {
            this.errorWithRecovery("Expecting constructor call (this(...)) or supertype initializer", TokenSet.orSet(TOPLEVEL_OBJECT_FIRST, TokenSet.create(JetTokens.RBRACE, JetTokens.LBRACE, JetTokens.COMMA, JetTokens.SEMICOLON)));
            initializer.drop();
            return;
        }
        this.myExpressionParsing.parseValueArgumentList();
        initializer.done(type);
    }

    private IElementType parseClassObject() {
        assert (this._at(JetTokens.CLASS_KEYWORD) && this.lookahead(1) == JetTokens.OBJECT_KEYWORD);
        this.advance();
        PsiBuilder.Marker objectDeclaration = this.mark();
        this.parseObject(false, true);
        objectDeclaration.done(JetNodeTypes.OBJECT_DECLARATION);
        return JetNodeTypes.CLASS_OBJECT;
    }

    JetNodeType parseTypeDef() {
        assert (this._at(JetTokens.TYPE_KEYWORD));
        this.advance();
        this.expect(JetTokens.IDENTIFIER, "Type name expected", TokenSet.orSet(TokenSet.create(JetTokens.LT, JetTokens.EQ, JetTokens.SEMICOLON), TOPLEVEL_OBJECT_FIRST));
        if (this.parseTypeParameterList(TYPE_PARAMETER_GT_RECOVERY_SET)) {
            this.parseTypeConstraints();
        }
        this.expect(JetTokens.EQ, "Expecting '='", TokenSet.orSet(TOPLEVEL_OBJECT_FIRST, TokenSet.create(JetTokens.SEMICOLON)));
        this.parseTypeRef();
        this.consumeIf(JetTokens.SEMICOLON);
        return JetNodeTypes.TYPEDEF;
    }

    private IElementType parseProperty() {
        return this.parseProperty(false);
    }

    public IElementType parseProperty(boolean local) {
        if (this.at(JetTokens.VAL_KEYWORD) || this.at(JetTokens.VAR_KEYWORD)) {
            this.advance();
        } else {
            this.errorAndAdvance("Expecting 'val' or 'var'");
        }
        boolean typeParametersDeclared = this.at(JetTokens.LT) && this.parseTypeParameterList(TokenSet.create(JetTokens.IDENTIFIER, JetTokens.EQ, JetTokens.COLON, JetTokens.SEMICOLON));
        TokenSet propertyNameFollow = TokenSet.create(JetTokens.COLON, JetTokens.EQ, JetTokens.LBRACE, JetTokens.RBRACE, JetTokens.SEMICOLON, JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD, JetTokens.FUN_KEYWORD, JetTokens.CLASS_KEYWORD);
        this.myBuilder.disableJoiningComplexTokens();
        int lastDot = this.matchTokenStreamPredicate(new LastBefore((AbstractJetParsing)this.new AbstractJetParsing.AtSet(JetTokens.DOT, JetTokens.SAFE_ACCESS), new AbstractTokenStreamPredicate(){

            @Override
            public boolean matching(boolean topLevel) {
                if (topLevel && (JetParsing.this.at(JetTokens.EQ) || JetParsing.this.at(JetTokens.COLON))) {
                    return true;
                }
                if (topLevel && JetParsing.this.at(JetTokens.IDENTIFIER)) {
                    IElementType lookahead = JetParsing.this.lookahead(1);
                    return lookahead != JetTokens.LT && lookahead != JetTokens.DOT && lookahead != JetTokens.SAFE_ACCESS && lookahead != JetTokens.QUEST;
                }
                return false;
            }
        }));
        PsiBuilder.Marker receiver = this.mark();
        this.parseReceiverType("property", propertyNameFollow, lastDot);
        boolean multiDeclaration = this.at(JetTokens.LPAR);
        boolean receiverTypeDeclared = lastDot != -1;
        JetParsing.errorIf(receiver, multiDeclaration && receiverTypeDeclared, "Receiver type is not allowed on a multi-declaration");
        if (multiDeclaration) {
            PsiBuilder.Marker multiDecl = this.mark();
            this.parseMultiDeclarationName(propertyNameFollow);
            JetParsing.errorIf(multiDecl, !local, "Multi-declarations are only allowed for local variables/values");
        } else {
            this.parseFunctionOrPropertyName(receiverTypeDeclared, "property", propertyNameFollow);
        }
        this.myBuilder.restoreJoiningComplexTokensState();
        if (this.at(JetTokens.COLON)) {
            PsiBuilder.Marker type = this.mark();
            this.advance();
            this.parseTypeRef();
            JetParsing.errorIf(type, multiDeclaration, "Type annotations are not allowed on multi-declarations");
        }
        this.parseTypeConstraintsGuarded(typeParametersDeclared);
        if (local) {
            if (this.at(JetTokens.BY_KEYWORD)) {
                this.parsePropertyDelegate();
            } else if (this.at(JetTokens.EQ)) {
                this.advance();
                this.myExpressionParsing.parseExpression();
            }
        } else {
            if (this.at(JetTokens.BY_KEYWORD)) {
                this.parsePropertyDelegate();
                this.consumeIf(JetTokens.SEMICOLON);
            } else if (this.at(JetTokens.EQ)) {
                this.advance();
                this.myExpressionParsing.parseExpression();
                this.consumeIf(JetTokens.SEMICOLON);
            }
            if (this.parsePropertyGetterOrSetter()) {
                this.parsePropertyGetterOrSetter();
            }
            if (!this.atSet(JetTokens.EOL_OR_SEMICOLON, JetTokens.RBRACE)) {
                if (this.getLastToken() != JetTokens.SEMICOLON) {
                    this.errorUntil("Property getter or setter expected", TokenSet.create(JetTokens.EOL_OR_SEMICOLON));
                }
            } else {
                this.consumeIf(JetTokens.SEMICOLON);
            }
        }
        return multiDeclaration ? JetNodeTypes.MULTI_VARIABLE_DECLARATION : JetNodeTypes.PROPERTY;
    }

    private void parsePropertyDelegate() {
        assert (this._at(JetTokens.BY_KEYWORD));
        PsiBuilder.Marker delegate = this.mark();
        this.advance();
        this.myExpressionParsing.parseExpression();
        delegate.done(JetNodeTypes.PROPERTY_DELEGATE);
    }

    public void parseMultiDeclarationName(TokenSet follow) {
        this.myBuilder.disableNewlines();
        this.advance();
        TokenSet recoverySet = TokenSet.orSet(PARAMETER_NAME_RECOVERY_SET, follow);
        if (!this.atSet(follow)) {
            while (true) {
                if (this.at(JetTokens.COMMA)) {
                    this.errorAndAdvance("Expecting a name");
                } else if (this.at(JetTokens.RPAR)) {
                    this.error("Expecting a name");
                    break;
                }
                PsiBuilder.Marker property2 = this.mark();
                this.expect(JetTokens.IDENTIFIER, "Expecting a name", recoverySet);
                if (this.at(JetTokens.COLON)) {
                    this.advance();
                    this.parseTypeRef(follow);
                }
                property2.done(JetNodeTypes.MULTI_VARIABLE_DECLARATION_ENTRY);
                if (!this.at(JetTokens.COMMA)) break;
                this.advance();
            }
        }
        this.expect(JetTokens.RPAR, "Expecting ')'", follow);
        this.myBuilder.restoreNewlinesState();
    }

    private boolean parsePropertyGetterOrSetter() {
        PsiBuilder.Marker getterOrSetter = this.mark();
        this.parseModifierList(JetNodeTypes.MODIFIER_LIST, false);
        if (!this.at(JetTokens.GET_KEYWORD) && !this.at(JetTokens.SET_KEYWORD)) {
            getterOrSetter.rollbackTo();
            return false;
        }
        boolean setter = this.at(JetTokens.SET_KEYWORD);
        this.advance();
        if (!this.at(JetTokens.LPAR)) {
            TokenSet ACCESSOR_FIRST_OR_PROPERTY_END = TokenSet.orSet(JetTokens.MODIFIER_KEYWORDS, TokenSet.create(JetTokens.LBRACKET, JetTokens.GET_KEYWORD, JetTokens.SET_KEYWORD, JetTokens.EOL_OR_SEMICOLON, JetTokens.RBRACE));
            if (!this.atSet(ACCESSOR_FIRST_OR_PROPERTY_END)) {
                this.errorUntil("Accessor body expected", TokenSet.orSet(ACCESSOR_FIRST_OR_PROPERTY_END, TokenSet.create(JetTokens.LBRACE, JetTokens.LPAR, JetTokens.EQ)));
            } else {
                getterOrSetter.done(JetNodeTypes.PROPERTY_ACCESSOR);
                return true;
            }
        }
        this.myBuilder.disableNewlines();
        this.expect(JetTokens.LPAR, "Expecting '('", TokenSet.create(JetTokens.RPAR, JetTokens.IDENTIFIER, JetTokens.COLON, JetTokens.LBRACE, JetTokens.EQ));
        if (setter) {
            PsiBuilder.Marker parameterList = this.mark();
            PsiBuilder.Marker setterParameter = this.mark();
            this.parseModifierListWithShortAnnotations(JetNodeTypes.MODIFIER_LIST, TokenSet.create(JetTokens.IDENTIFIER), TokenSet.create(JetTokens.RPAR, JetTokens.COMMA, JetTokens.COLON));
            this.expect(JetTokens.IDENTIFIER, "Expecting parameter name", TokenSet.create(JetTokens.RPAR, JetTokens.COLON, JetTokens.LBRACE, JetTokens.EQ));
            if (this.at(JetTokens.COLON)) {
                this.advance();
                this.parseTypeRef();
            }
            setterParameter.done(JetNodeTypes.VALUE_PARAMETER);
            parameterList.done(JetNodeTypes.VALUE_PARAMETER_LIST);
        }
        if (!this.at(JetTokens.RPAR)) {
            this.errorUntil("Expecting ')'", TokenSet.create(JetTokens.RPAR, JetTokens.COLON, JetTokens.LBRACE, JetTokens.EQ, JetTokens.EOL_OR_SEMICOLON));
        }
        this.expect(JetTokens.RPAR, "Expecting ')'", TokenSet.create(JetTokens.RPAR, JetTokens.COLON, JetTokens.LBRACE, JetTokens.EQ));
        this.myBuilder.restoreNewlinesState();
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        this.parseFunctionBody();
        getterOrSetter.done(JetNodeTypes.PROPERTY_ACCESSOR);
        return true;
    }

    IElementType parseFunction() {
        assert (this._at(JetTokens.FUN_KEYWORD));
        this.advance();
        if (this.at(JetTokens.RBRACE)) {
            this.error("Function body expected");
            return JetNodeTypes.FUN;
        }
        boolean typeParameterListOccurred = false;
        if (this.at(JetTokens.LT)) {
            this.parseTypeParameterList(TokenSet.create(JetTokens.LBRACKET, JetTokens.LBRACE, JetTokens.LPAR));
            typeParameterListOccurred = true;
        }
        this.myBuilder.disableJoiningComplexTokens();
        int lastDot = this.findLastBefore(RECEIVER_TYPE_TERMINATORS, TokenSet.create(JetTokens.LPAR), true);
        TokenSet functionNameFollow = TokenSet.create(JetTokens.LT, JetTokens.LPAR, JetTokens.COLON, JetTokens.EQ);
        this.parseReceiverType("function", functionNameFollow, lastDot);
        this.parseFunctionOrPropertyName(lastDot != -1, "function", functionNameFollow);
        this.myBuilder.restoreJoiningComplexTokensState();
        TokenSet valueParametersFollow = TokenSet.create(JetTokens.COLON, JetTokens.EQ, JetTokens.LBRACE, JetTokens.SEMICOLON, JetTokens.RPAR);
        if (this.at(JetTokens.LT)) {
            PsiBuilder.Marker error = this.mark();
            this.parseTypeParameterList(TokenSet.orSet(TokenSet.create(JetTokens.LPAR), valueParametersFollow));
            JetParsing.errorIf(error, typeParameterListOccurred, "Only one type parameter list is allowed for a function");
            typeParameterListOccurred = true;
        }
        if (this.at(JetTokens.LPAR)) {
            this.parseValueParameterList(false, valueParametersFollow);
        } else {
            this.error("Expecting '('");
        }
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        this.parseTypeConstraintsGuarded(typeParameterListOccurred);
        if (this.at(JetTokens.SEMICOLON)) {
            this.advance();
        } else if (this.at(JetTokens.EQ) || this.at(JetTokens.LBRACE)) {
            this.parseFunctionBody();
        }
        return JetNodeTypes.FUN;
    }

    private void parseReceiverType(String title, TokenSet nameFollow, int lastDot) {
        if (lastDot == -1) {
            this.parseAnnotations(false);
        } else {
            this.createTruncatedBuilder(lastDot).parseTypeRef();
            if (this.atSet(RECEIVER_TYPE_TERMINATORS)) {
                this.advance();
            } else {
                this.errorWithRecovery("Expecting '.' before a " + title + " name", nameFollow);
            }
        }
    }

    private void parseFunctionOrPropertyName(boolean receiverFound, String title, TokenSet nameFollow) {
        if (!receiverFound) {
            this.expect(JetTokens.IDENTIFIER, "Expecting " + title + " name or receiver type", nameFollow);
        } else {
            this.expect(JetTokens.IDENTIFIER, "Expecting " + title + " name", nameFollow);
        }
    }

    private void parseFunctionBody() {
        if (this.at(JetTokens.LBRACE)) {
            this.parseBlock();
        } else if (this.at(JetTokens.EQ)) {
            this.advance();
            this.myExpressionParsing.parseExpression();
            this.consumeIf(JetTokens.SEMICOLON);
        } else {
            this.errorAndAdvance("Expecting function body");
        }
    }

    void parseBlock() {
        PsiBuilder.Marker block = this.mark();
        this.myBuilder.enableNewlines();
        this.expect(JetTokens.LBRACE, "Expecting '{' to open a block");
        this.myExpressionParsing.parseStatements();
        this.expect(JetTokens.RBRACE, "Expecting '}");
        this.myBuilder.restoreNewlinesState();
        block.done(JetNodeTypes.BLOCK);
    }

    void parseDelegationSpecifierList() {
        PsiBuilder.Marker list = this.mark();
        while (true) {
            if (this.at(JetTokens.COMMA)) {
                this.errorAndAdvance("Expecting a delegation specifier");
                continue;
            }
            this.parseDelegationSpecifier();
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        list.done(JetNodeTypes.DELEGATION_SPECIFIER_LIST);
    }

    private void parseDelegationSpecifier() {
        PsiBuilder.Marker delegator = this.mark();
        this.parseAnnotations(false);
        PsiBuilder.Marker reference = this.mark();
        this.parseTypeRef();
        if (this.at(JetTokens.BY_KEYWORD)) {
            reference.drop();
            this.advance();
            JetParsing.createForByClause((SemanticWhitespaceAwarePsiBuilder)this.myBuilder).myExpressionParsing.parseExpression();
            delegator.done(JetNodeTypes.DELEGATOR_BY);
        } else if (this.at(JetTokens.LPAR)) {
            reference.done(JetNodeTypes.CONSTRUCTOR_CALLEE);
            this.myExpressionParsing.parseValueArgumentList();
            delegator.done(JetNodeTypes.DELEGATOR_SUPER_CALL);
        } else {
            reference.drop();
            delegator.done(JetNodeTypes.DELEGATOR_SUPER_CLASS);
        }
    }

    private boolean parseTypeParameterList(TokenSet recoverySet) {
        boolean result2 = false;
        if (this.at(JetTokens.LT)) {
            PsiBuilder.Marker list = this.mark();
            this.myBuilder.disableNewlines();
            this.advance();
            while (true) {
                if (this.at(JetTokens.COMMA)) {
                    this.errorAndAdvance("Expecting type parameter declaration");
                }
                this.parseTypeParameter();
                if (!this.at(JetTokens.COMMA)) break;
                this.advance();
            }
            this.expect(JetTokens.GT, "Missing '>'", recoverySet);
            this.myBuilder.restoreNewlinesState();
            result2 = true;
            list.done(JetNodeTypes.TYPE_PARAMETER_LIST);
        }
        return result2;
    }

    private void parseTypeConstraintsGuarded(boolean typeParameterListOccurred) {
        PsiBuilder.Marker error = this.mark();
        boolean constraints = this.parseTypeConstraints();
        JetParsing.errorIf(error, constraints && !typeParameterListOccurred, "Type constraints are not allowed when no type parameters declared");
    }

    private boolean parseTypeConstraints() {
        if (this.at(JetTokens.WHERE_KEYWORD)) {
            this.parseTypeConstraintList();
            return true;
        }
        return false;
    }

    private void parseTypeConstraintList() {
        assert (this._at(JetTokens.WHERE_KEYWORD));
        this.advance();
        PsiBuilder.Marker list = this.mark();
        while (true) {
            if (this.at(JetTokens.COMMA)) {
                this.errorAndAdvance("Type constraint expected");
            }
            this.parseTypeConstraint();
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        list.done(JetNodeTypes.TYPE_CONSTRAINT_LIST);
    }

    private void parseTypeConstraint() {
        PsiBuilder.Marker constraint = this.mark();
        this.parseAnnotations(false);
        if (this.at(JetTokens.CLASS_KEYWORD)) {
            this.advance();
            this.expect(JetTokens.OBJECT_KEYWORD, "Expecting 'object'", TYPE_REF_FIRST);
        }
        PsiBuilder.Marker reference = this.mark();
        if (this.expect(JetTokens.IDENTIFIER, "Expecting type parameter name", TokenSet.orSet(TokenSet.create(JetTokens.COLON, JetTokens.COMMA), TYPE_REF_FIRST))) {
            reference.done(JetNodeTypes.REFERENCE_EXPRESSION);
        } else {
            reference.drop();
        }
        this.expect(JetTokens.COLON, "Expecting ':' before the upper bound", TYPE_REF_FIRST);
        this.parseTypeRef();
        constraint.done(JetNodeTypes.TYPE_CONSTRAINT);
    }

    private void parseTypeParameter() {
        if (this.atSet(TYPE_PARAMETER_GT_RECOVERY_SET)) {
            this.error("Type parameter declaration expected");
            return;
        }
        PsiBuilder.Marker mark = this.mark();
        this.parseModifierListWithShortAnnotations(JetNodeTypes.MODIFIER_LIST, TokenSet.create(JetTokens.IDENTIFIER), TokenSet.create(JetTokens.COMMA, JetTokens.GT, JetTokens.COLON));
        this.expect(JetTokens.IDENTIFIER, "Type parameter name expected", TokenSet.EMPTY);
        if (this.at(JetTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        mark.done(JetNodeTypes.TYPE_PARAMETER);
    }

    void parseTypeRef() {
        this.parseTypeRef(TokenSet.EMPTY);
    }

    void parseTypeRef(TokenSet extraRecoverySet) {
        PsiBuilder.Marker typeRefMarker = this.parseTypeRefContents(extraRecoverySet);
        typeRefMarker.done(JetNodeTypes.TYPE_REFERENCE);
    }

    private PsiBuilder.Marker parseTypeRefContents(TokenSet extraRecoverySet) {
        PsiBuilder.Marker typeRefMarker = this.mark();
        this.parseAnnotations(false);
        if (this.at(JetTokens.IDENTIFIER) || this.at(JetTokens.PACKAGE_KEYWORD)) {
            this.parseUserType();
        } else if (this.at(JetTokens.HASH)) {
            this.parseTupleType();
        } else if (this.at(JetTokens.LPAR)) {
            PsiBuilder.Marker functionOrParenthesizedType = this.mark();
            this.advance();
            this.parseTypeRefContents(TokenSet.EMPTY).drop();
            if (this.at(JetTokens.RPAR)) {
                this.advance();
                if (this.at(JetTokens.ARROW)) {
                    functionOrParenthesizedType.rollbackTo();
                    this.parseFunctionType();
                } else {
                    functionOrParenthesizedType.drop();
                }
            } else {
                functionOrParenthesizedType.rollbackTo();
                this.parseFunctionType();
            }
        } else if (this.at(JetTokens.CAPITALIZED_THIS_KEYWORD)) {
            this.parseSelfType();
        } else {
            this.errorWithRecovery("Type expected", TokenSet.orSet(TOPLEVEL_OBJECT_FIRST, TokenSet.create(JetTokens.EQ, JetTokens.COMMA, JetTokens.GT, JetTokens.RBRACKET, JetTokens.DOT, JetTokens.RPAR, JetTokens.RBRACE, JetTokens.LBRACE, JetTokens.SEMICOLON), extraRecoverySet));
        }
        typeRefMarker = this.parseNullableTypeSuffix(typeRefMarker);
        if (this.at(JetTokens.DOT)) {
            PsiBuilder.Marker functionType = typeRefMarker.precede();
            PsiBuilder.Marker receiverType = typeRefMarker.precede();
            typeRefMarker.done(JetNodeTypes.TYPE_REFERENCE);
            receiverType.done(JetNodeTypes.FUNCTION_TYPE_RECEIVER);
            this.advance();
            if (this.at(JetTokens.LPAR)) {
                this.parseFunctionTypeContents().drop();
            } else {
                this.error("Expecting function type");
            }
            typeRefMarker = functionType.precede();
            functionType.done(JetNodeTypes.FUNCTION_TYPE);
        }
        return typeRefMarker;
    }

    @NotNull
    PsiBuilder.Marker parseNullableTypeSuffix(@NotNull PsiBuilder.Marker typeRefMarker) {
        if (typeRefMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeRefMarker", "org/jetbrains/jet/lang/parsing/JetParsing", "parseNullableTypeSuffix"));
        }
        while (this.at(JetTokens.QUEST)) {
            PsiBuilder.Marker precede = typeRefMarker.precede();
            this.advance();
            typeRefMarker.done(JetNodeTypes.NULLABLE_TYPE);
            typeRefMarker = precede;
        }
        PsiBuilder.Marker marker = typeRefMarker;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/parsing/JetParsing", "parseNullableTypeSuffix"));
        }
        return marker;
    }

    void parseUserType() {
        PsiBuilder.Marker userType = this.mark();
        if (this.at(JetTokens.PACKAGE_KEYWORD)) {
            this.advance();
            this.expect(JetTokens.DOT, "Expecting '.'", TokenSet.create(JetTokens.IDENTIFIER));
        }
        PsiBuilder.Marker reference = this.mark();
        while (true) {
            if (!this.expect(JetTokens.IDENTIFIER, "Expecting type name", TokenSet.orSet(JetExpressionParsing.EXPRESSION_FIRST, JetExpressionParsing.EXPRESSION_FOLLOW))) {
                reference.drop();
                break;
            }
            reference.done(JetNodeTypes.REFERENCE_EXPRESSION);
            this.parseTypeArgumentList();
            if (!this.at(JetTokens.DOT) || this.lookahead(1) == JetTokens.LPAR) break;
            PsiBuilder.Marker precede = userType.precede();
            userType.done(JetNodeTypes.USER_TYPE);
            userType = precede;
            this.advance();
            reference = this.mark();
        }
        userType.done(JetNodeTypes.USER_TYPE);
    }

    private void parseSelfType() {
        assert (this._at(JetTokens.CAPITALIZED_THIS_KEYWORD));
        PsiBuilder.Marker type = this.mark();
        this.advance();
        type.done(JetNodeTypes.SELF_TYPE);
    }

    private PsiBuilder.Marker parseTypeArgumentList() {
        if (!this.at(JetTokens.LT)) {
            return null;
        }
        PsiBuilder.Marker list = this.mark();
        this.tryParseTypeArgumentList(TokenSet.EMPTY);
        list.done(JetNodeTypes.TYPE_ARGUMENT_LIST);
        return list;
    }

    boolean tryParseTypeArgumentList(TokenSet extraRecoverySet) {
        this.myBuilder.disableNewlines();
        this.advance();
        while (true) {
            PsiBuilder.Marker projection = this.mark();
            this.parseModifierList(JetNodeTypes.MODIFIER_LIST, false);
            if (this.at(JetTokens.MUL)) {
                this.advance();
            } else {
                this.parseTypeRef(extraRecoverySet);
            }
            projection.done(JetNodeTypes.TYPE_PROJECTION);
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        boolean atGT = this.at(JetTokens.GT);
        if (!atGT) {
            this.error("Expecting a '>'");
        } else {
            this.advance();
        }
        this.myBuilder.restoreNewlinesState();
        return atGT;
    }

    private void parseModifierListWithShortAnnotations(IElementType modifierList, TokenSet lookFor, TokenSet stopAt) {
        int lastId = this.findLastBefore(lookFor, stopAt, false);
        this.createTruncatedBuilder(lastId).parseModifierList(modifierList, true);
    }

    @Deprecated
    private void parseTupleType() {
        assert (this._at(JetTokens.HASH));
        PsiBuilder.Marker tuple = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        this.consumeIf(JetTokens.LPAR);
        if (!this.at(JetTokens.RPAR)) {
            while (true) {
                if (this.at(JetTokens.COLON)) {
                    this.errorAndAdvance("Expecting a name for tuple entry");
                }
                if (this.at(JetTokens.IDENTIFIER) && this.lookahead(1) == JetTokens.COLON) {
                    this.advance();
                    this.advance();
                    this.parseTypeRef();
                } else if (TYPE_REF_FIRST.contains(this.tt())) {
                    this.parseTypeRef();
                } else {
                    this.error("Type expected");
                    break;
                }
                if (!this.at(JetTokens.COMMA)) break;
                this.advance();
            }
        }
        this.consumeIf(JetTokens.RPAR);
        this.myBuilder.restoreNewlinesState();
        tuple.error("Tuples are not supported. Use data classes instead.");
    }

    private void parseFunctionType() {
        this.parseFunctionTypeContents().done(JetNodeTypes.FUNCTION_TYPE);
    }

    private PsiBuilder.Marker parseFunctionTypeContents() {
        assert (this._at(JetTokens.LPAR)) : this.tt();
        PsiBuilder.Marker functionType = this.mark();
        this.parseValueParameterList(true, TokenSet.EMPTY);
        this.expect(JetTokens.ARROW, "Expecting '->' to specify return type of a function type", TYPE_REF_FIRST);
        this.parseTypeRef();
        return functionType;
    }

    void parseValueParameterList(boolean isFunctionTypeContents, TokenSet recoverySet) {
        assert (this._at(JetTokens.LPAR));
        PsiBuilder.Marker parameters = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        if (!this.at(JetTokens.RPAR) && !this.atSet(recoverySet)) {
            while (true) {
                if (this.at(JetTokens.COMMA)) {
                    this.errorAndAdvance("Expecting a parameter declaration");
                } else if (this.at(JetTokens.RPAR)) {
                    this.error("Expecting a parameter declaration");
                    break;
                }
                if (isFunctionTypeContents) {
                    if (!this.tryParseValueParameter()) {
                        PsiBuilder.Marker valueParameter = this.mark();
                        this.parseModifierList(JetNodeTypes.MODIFIER_LIST, false);
                        this.parseTypeRef();
                        valueParameter.done(JetNodeTypes.VALUE_PARAMETER);
                    }
                } else {
                    this.parseValueParameter();
                }
                if (this.at(JetTokens.COMMA)) {
                    this.advance();
                    continue;
                }
                if (!this.at(JetTokens.RPAR)) {
                    this.error("Expecting comma or ')'");
                }
                if (!this.atSet(isFunctionTypeContents ? LAMBDA_VALUE_PARAMETER_FIRST : VALUE_PARAMETER_FIRST)) break;
            }
        }
        this.expect(JetTokens.RPAR, "Expecting ')'", recoverySet);
        this.myBuilder.restoreNewlinesState();
        parameters.done(JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    private boolean tryParseValueParameter() {
        return this.parseValueParameter(true);
    }

    public void parseValueParameter() {
        this.parseValueParameter(false);
    }

    private boolean parseValueParameter(boolean rollbackOnFailure) {
        PsiBuilder.Marker parameter = this.mark();
        this.parseModifierListWithShortAnnotations(JetNodeTypes.MODIFIER_LIST, TokenSet.create(JetTokens.IDENTIFIER), TokenSet.create(JetTokens.COMMA, JetTokens.RPAR, JetTokens.COLON));
        if (this.at(JetTokens.VAR_KEYWORD) || this.at(JetTokens.VAL_KEYWORD)) {
            this.advance();
        }
        if (!this.parseFunctionParameterRest() && rollbackOnFailure) {
            parameter.rollbackTo();
            return false;
        }
        parameter.done(JetNodeTypes.VALUE_PARAMETER);
        return true;
    }

    private boolean parseFunctionParameterRest() {
        boolean noErrors = true;
        if (this.at(JetTokens.IDENTIFIER) && this.lookahead(1) == JetTokens.LT) {
            this.error("Parameter name expected");
            this.parseTypeRef();
            noErrors = false;
        } else {
            this.expect(JetTokens.IDENTIFIER, "Parameter name expected", PARAMETER_NAME_RECOVERY_SET);
            if (this.at(JetTokens.COLON)) {
                this.advance();
                this.parseTypeRef();
            } else {
                this.errorWithRecovery("Parameters must have type annotation", PARAMETER_NAME_RECOVERY_SET);
                noErrors = false;
            }
        }
        if (this.at(JetTokens.EQ)) {
            this.advance();
            this.myExpressionParsing.parseExpression();
        }
        return noErrors;
    }

    @Override
    protected JetParsing create(SemanticWhitespaceAwarePsiBuilder builder) {
        return JetParsing.createForTopLevel(builder);
    }

    static {
        for (IElementType softKeyword : JetTokens.MODIFIER_KEYWORDS.getTypes()) {
            MODIFIER_KEYWORD_MAP.put(((JetKeywordToken)softKeyword).getValue(), softKeyword);
        }
        TOPLEVEL_OBJECT_FIRST = TokenSet.create(JetTokens.TYPE_KEYWORD, JetTokens.TRAIT_KEYWORD, JetTokens.CLASS_KEYWORD, JetTokens.FUN_KEYWORD, JetTokens.VAL_KEYWORD, JetTokens.PACKAGE_KEYWORD);
        ENUM_MEMBER_FIRST = TokenSet.create(JetTokens.TYPE_KEYWORD, JetTokens.TRAIT_KEYWORD, JetTokens.CLASS_KEYWORD, JetTokens.FUN_KEYWORD, JetTokens.VAL_KEYWORD, JetTokens.IDENTIFIER);
        CLASS_NAME_RECOVERY_SET = TokenSet.orSet(TokenSet.create(JetTokens.LT, JetTokens.LPAR, JetTokens.COLON, JetTokens.LBRACE), TOPLEVEL_OBJECT_FIRST);
        TYPE_PARAMETER_GT_RECOVERY_SET = TokenSet.create(JetTokens.WHERE_KEYWORD, JetTokens.LPAR, JetTokens.COLON, JetTokens.LBRACE, JetTokens.GT);
        PARAMETER_NAME_RECOVERY_SET = TokenSet.create(JetTokens.COLON, JetTokens.EQ, JetTokens.COMMA, JetTokens.RPAR);
        PACKAGE_NAME_RECOVERY_SET = TokenSet.create(JetTokens.DOT, JetTokens.EOL_OR_SEMICOLON);
        IMPORT_RECOVERY_SET = TokenSet.create(JetTokens.AS_KEYWORD, JetTokens.DOT, JetTokens.EOL_OR_SEMICOLON);
        TYPE_REF_FIRST = TokenSet.create(JetTokens.LBRACKET, JetTokens.IDENTIFIER, JetTokens.LPAR, JetTokens.CAPITALIZED_THIS_KEYWORD, JetTokens.HASH);
        RECEIVER_TYPE_TERMINATORS = TokenSet.create(JetTokens.DOT, JetTokens.SAFE_ACCESS);
        VALUE_PARAMETER_FIRST = TokenSet.orSet(TokenSet.create(JetTokens.IDENTIFIER, JetTokens.LBRACKET, JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD), JetTokens.MODIFIER_KEYWORDS);
        LAMBDA_VALUE_PARAMETER_FIRST = TokenSet.orSet(TokenSet.create(JetTokens.IDENTIFIER, JetTokens.LBRACKET), JetTokens.MODIFIER_KEYWORDS);
    }

    static class TokenDetector
    implements Consumer<IElementType> {
        private boolean detected = false;
        private final TokenSet tokens;

        public TokenDetector(JetKeywordToken token) {
            this.tokens = TokenSet.create(token);
        }

        @Override
        public void consume(IElementType item) {
            if (this.tokens.contains(item)) {
                this.detected = true;
            }
        }

        public boolean isDetected() {
            return this.detected;
        }
    }
}

