/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Function0;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.Flags;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.SerializationPackage;
import org.jetbrains.jet.descriptors.serialization.context.ContextPackage;
import org.jetbrains.jet.descriptors.serialization.context.DeserializationContext;
import org.jetbrains.jet.descriptors.serialization.context.DeserializationContextWithTypes;
import org.jetbrains.jet.descriptors.serialization.context.DeserializationGlobalContext;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedMemberScope;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.AbstractClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.EnumClassObjectDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.EnumEntrySyntheticClassDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.AbstractClassTypeConstructor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.NullableLazyValue;
import org.jetbrains.jet.storage.StorageManager;

public class DeserializedClassDescriptor
extends AbstractClassDescriptor
implements ClassDescriptor {
    private final ClassId classId;
    private final ProtoBuf.Class classProto;
    private final DeserializedMemberScope memberScope;
    private final NullableLazyValue<ConstructorDescriptor> primaryConstructor;
    private final NotNullLazyValue<Annotations> annotations;
    private final NullableLazyValue<ClassDescriptor> classObjectDescriptor;
    private final NestedClassDescriptors nestedClasses;
    private final NotNullLazyValue<DeclarationDescriptor> containingDeclaration;
    private final DeserializedClassTypeConstructor typeConstructor;
    private final Modality modality;
    private final Visibility visibility;
    private final ClassKind kind;
    private final boolean isInner;
    private final DeserializationContextWithTypes context;

    public DeserializedClassDescriptor(@NotNull DeserializationGlobalContext globalContext, @NotNull ClassData classData) {
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        if (classData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classData", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        this(globalContext.withNameResolver(classData.getNameResolver()), classData.getClassProto());
    }

    public DeserializedClassDescriptor(@NotNull DeserializationContext outerContext, @NotNull ProtoBuf.Class classProto) {
        if (outerContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerContext", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        if (classProto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProto", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        super(outerContext.getStorageManager(), outerContext.getNameResolver().getClassId(classProto.getFqName()).getRelativeClassName().shortName());
        this.classProto = classProto;
        this.classId = outerContext.getNameResolver().getClassId(classProto.getFqName());
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(classProto.getTypeParameterCount());
        this.context = outerContext.withTypes(this).childContext(this, classProto.getTypeParameterList(), typeParameters);
        this.containingDeclaration = outerContext.getStorageManager().createLazyValue(new Function0<DeclarationDescriptor>(){

            @Override
            public DeclarationDescriptor invoke() {
                return DeserializedClassDescriptor.this.computeContainingDeclaration();
            }
        });
        this.typeConstructor = new DeserializedClassTypeConstructor(typeParameters);
        this.memberScope = new DeserializedClassMemberScope();
        int flags = classProto.getFlags();
        this.modality = SerializationPackage.modality(Flags.MODALITY.get(flags));
        this.visibility = SerializationPackage.visibility(Flags.VISIBILITY.get(flags));
        this.kind = SerializationPackage.classKind(Flags.CLASS_KIND.get(flags));
        this.isInner = Flags.INNER.get(flags);
        this.annotations = this.context.getStorageManager().createLazyValue(new Function0<Annotations>(){

            @Override
            public Annotations invoke() {
                return DeserializedClassDescriptor.this.computeAnnotations();
            }
        });
        this.primaryConstructor = this.context.getStorageManager().createNullableLazyValue(new Function0<ConstructorDescriptor>(){

            @Override
            public ConstructorDescriptor invoke() {
                return DeserializedClassDescriptor.this.computePrimaryConstructor();
            }
        });
        this.classObjectDescriptor = this.context.getStorageManager().createNullableLazyValue(new Function0<ClassDescriptor>(){

            @Override
            public ClassDescriptor invoke() {
                return DeserializedClassDescriptor.this.computeClassObjectDescriptor();
            }
        });
        this.nestedClasses = new NestedClassDescriptors();
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.containingDeclaration.invoke();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @NotNull
    private DeclarationDescriptor computeContainingDeclaration() {
        if (this.classId.isTopLevelClass()) {
            List<PackageFragmentDescriptor> fragments = this.context.getPackageFragmentProvider().getPackageFragments(this.classId.getPackageFqName());
            assert (fragments.size() == 1) : "there should be exactly one package: " + fragments;
            DeclarationDescriptor declarationDescriptor = fragments.iterator().next();
            if (declarationDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "computeContainingDeclaration"));
            }
            return declarationDescriptor;
        }
        ClassDescriptor result2 = ContextPackage.deserializeClass(this.context, this.classId.getOuterClassId());
        DeclarationDescriptor declarationDescriptor = result2 != null ? result2 : ErrorUtils.getErrorModule();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "computeContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        DeserializedClassTypeConstructor deserializedClassTypeConstructor = this.typeConstructor;
        if (deserializedClassTypeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getTypeConstructor"));
        }
        return deserializedClassTypeConstructor;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getKind"));
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    private Annotations computeAnnotations() {
        if (!Flags.HAS_ANNOTATIONS.get(this.classProto.getFlags()).booleanValue()) {
            return Annotations.EMPTY;
        }
        return this.context.getAnnotationLoader().loadClassAnnotations(this, this.classProto);
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations = (Annotations)this.annotations.invoke();
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getAnnotations"));
        }
        return annotations;
    }

    @Override
    @NotNull
    protected JetScope getScopeForMemberLookup() {
        DeserializedMemberScope deserializedMemberScope = this.memberScope;
        if (deserializedMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getScopeForMemberLookup"));
        }
        return deserializedMemberScope;
    }

    @Nullable
    private ConstructorDescriptor computePrimaryConstructor() {
        if (!this.classProto.hasPrimaryConstructor()) {
            return null;
        }
        ProtoBuf.Class.PrimaryConstructor constructorProto = this.classProto.getPrimaryConstructor();
        if (!constructorProto.hasData()) {
            ConstructorDescriptorImpl descriptor = DescriptorFactory.createPrimaryConstructorForObject(this, SourceElement.NO_SOURCE);
            descriptor.setReturnType(this.getDefaultType());
            return descriptor;
        }
        return (ConstructorDescriptor)this.context.getDeserializer().loadCallable(constructorProto.getData());
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return (ConstructorDescriptor)this.primaryConstructor.invoke();
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        ConstructorDescriptor constructor = this.getUnsubstitutedPrimaryConstructor();
        if (constructor == null) {
            List<ConstructorDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getConstructors"));
            }
            return list;
        }
        List<ConstructorDescriptor> list = Collections.singletonList(constructor);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getConstructors"));
        }
        return list;
    }

    @Nullable
    private ClassDescriptor computeClassObjectDescriptor() {
        if (!this.classProto.hasClassObject()) {
            return null;
        }
        if (this.getKind() == ClassKind.ENUM_CLASS) {
            return new EnumClassObjectDescriptor(this.context.getStorageManager(), this);
        }
        if (this.getKind() == ClassKind.OBJECT) {
            ProtoBuf.Class.ClassObject classObjectProto = this.classProto.getClassObject();
            if (!classObjectProto.hasData()) {
                throw new IllegalStateException("Object should have a serialized class object: " + this.classId);
            }
            return new DeserializedClassDescriptor(this.context, classObjectProto.getData());
        }
        return ContextPackage.deserializeClass(this.context, this.classId.createNestedClassId(SpecialNames.getClassObjectName(this.getName())));
    }

    @Override
    @Nullable
    public ClassDescriptor getClassObjectDescriptor() {
        return (ClassDescriptor)this.classObjectDescriptor.invoke();
    }

    private Collection<JetType> computeSuperTypes() {
        ArrayList<JetType> supertypes = new ArrayList<JetType>(this.classProto.getSupertypeCount());
        for (ProtoBuf.Type supertype : this.classProto.getSupertypeList()) {
            supertypes.add(this.context.getTypeDeserializer().type(supertype));
        }
        return supertypes;
    }

    public String toString() {
        return "deserialized class " + this.getName().toString();
    }

    @Override
    @NotNull
    public SourceElement getSource() {
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        if (sourceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getSource"));
        }
        return sourceElement;
    }

    private class NestedClassDescriptors {
        private final Set<Name> nestedClassNames = this.nestedClassNames();
        private final MemoizedFunctionToNullable<Name, ClassDescriptor> findClass;
        private final Set<Name> enumEntryNames = this.enumEntryNames();

        public NestedClassDescriptors() {
            final StorageManager storageManager = DeserializedClassDescriptor.this.context.getStorageManager();
            final NotNullLazyValue<Collection<Name>> enumMemberNames = storageManager.createLazyValue(new Function0<Collection<Name>>(){

                @Override
                public Collection<Name> invoke() {
                    return NestedClassDescriptors.this.computeEnumMemberNames();
                }
            });
            this.findClass = storageManager.createMemoizedFunctionWithNullableValues(new Function1<Name, ClassDescriptor>(){

                @Override
                public ClassDescriptor invoke(Name name) {
                    if (NestedClassDescriptors.this.enumEntryNames.contains(name)) {
                        return EnumEntrySyntheticClassDescriptor.create(storageManager, DeserializedClassDescriptor.this, name, enumMemberNames, SourceElement.NO_SOURCE);
                    }
                    if (NestedClassDescriptors.this.nestedClassNames.contains(name)) {
                        return ContextPackage.deserializeClass(DeserializedClassDescriptor.this.context, DeserializedClassDescriptor.this.classId.createNestedClassId(name));
                    }
                    return null;
                }
            });
        }

        @NotNull
        private Set<Name> nestedClassNames() {
            HashSet<Name> result2 = new HashSet<Name>();
            NameResolver nameResolver = DeserializedClassDescriptor.this.context.getNameResolver();
            for (Integer index : DeserializedClassDescriptor.this.classProto.getNestedClassNameList()) {
                result2.add(nameResolver.getName(index));
            }
            HashSet<Name> hashSet = result2;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors", "nestedClassNames"));
            }
            return hashSet;
        }

        @NotNull
        private Set<Name> enumEntryNames() {
            if (DeserializedClassDescriptor.this.getKind() != ClassKind.ENUM_CLASS) {
                Set<Name> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors", "enumEntryNames"));
                }
                return set;
            }
            HashSet<Name> result2 = new HashSet<Name>();
            NameResolver nameResolver = DeserializedClassDescriptor.this.context.getNameResolver();
            for (Integer index : DeserializedClassDescriptor.this.classProto.getEnumEntryList()) {
                result2.add(nameResolver.getName(index));
            }
            HashSet<Name> hashSet = result2;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors", "enumEntryNames"));
            }
            return hashSet;
        }

        @NotNull
        private Collection<Name> computeEnumMemberNames() {
            HashSet<Name> result2 = new HashSet<Name>();
            for (JetType supertype : DeserializedClassDescriptor.this.getTypeConstructor().getSupertypes()) {
                for (DeclarationDescriptor descriptor : supertype.getMemberScope().getAllDescriptors()) {
                    if (!(descriptor instanceof SimpleFunctionDescriptor) && !(descriptor instanceof PropertyDescriptor)) continue;
                    result2.add(descriptor.getName());
                }
            }
            final NameResolver nameResolver = DeserializedClassDescriptor.this.context.getNameResolver();
            HashSet<Name> hashSet = KotlinPackage.mapTo(DeserializedClassDescriptor.this.classProto.getMemberList(), result2, new Function1<ProtoBuf.Callable, Name>(){

                @Override
                public Name invoke(@NotNull ProtoBuf.Callable callable2) {
                    if (callable2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors$3", "invoke"));
                    }
                    return nameResolver.getName(callable2.getName());
                }
            });
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors", "computeEnumMemberNames"));
            }
            return hashSet;
        }

        @NotNull
        public Collection<ClassDescriptor> getAllDescriptors() {
            ClassDescriptor descriptor;
            ArrayList<ClassDescriptor> result2 = new ArrayList<ClassDescriptor>(this.nestedClassNames.size() + this.enumEntryNames.size());
            for (Name name : this.nestedClassNames) {
                descriptor = (ClassDescriptor)this.findClass.invoke(name);
                if (descriptor == null) continue;
                result2.add(descriptor);
            }
            for (Name name : this.enumEntryNames) {
                descriptor = (ClassDescriptor)this.findClass.invoke(name);
                if (descriptor == null) continue;
                result2.add(descriptor);
            }
            ArrayList<ClassDescriptor> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors", "getAllDescriptors"));
            }
            return arrayList;
        }
    }

    private class DeserializedClassMemberScope
    extends DeserializedMemberScope {
        private final DeserializedClassDescriptor classDescriptor;

        public DeserializedClassMemberScope() {
            super(DeserializedClassDescriptor.this.context, DeserializedClassDescriptor.this.classProto.getMemberList());
            this.classDescriptor = DeserializedClassDescriptor.this;
        }

        @Override
        protected void computeNonDeclaredFunctions(@NotNull Name name, @NotNull Collection<FunctionDescriptor> functions2) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "computeNonDeclaredFunctions"));
            }
            if (functions2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "computeNonDeclaredFunctions"));
            }
            ArrayList<FunctionDescriptor> fromSupertypes = new ArrayList<FunctionDescriptor>();
            for (JetType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                fromSupertypes.addAll(supertype.getMemberScope().getFunctions(name));
            }
            this.generateFakeOverrides(name, fromSupertypes, functions2);
        }

        @Override
        protected void computeNonDeclaredProperties(@NotNull Name name, @NotNull Collection<PropertyDescriptor> property2) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "computeNonDeclaredProperties"));
            }
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "computeNonDeclaredProperties"));
            }
            ArrayList<VariableDescriptor> fromSupertypes = new ArrayList<VariableDescriptor>();
            for (JetType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                fromSupertypes.addAll(supertype.getMemberScope().getProperties(name));
            }
            this.generateFakeOverrides(name, fromSupertypes, property2);
        }

        private <D extends CallableMemberDescriptor> void generateFakeOverrides(@NotNull Name name, @NotNull Collection<D> fromSupertypes, final @NotNull Collection<D> result2) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "generateFakeOverrides"));
            }
            if (fromSupertypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromSupertypes", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "generateFakeOverrides"));
            }
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "generateFakeOverrides"));
            }
            ArrayList<D> fromCurrent = new ArrayList<D>(result2);
            OverridingUtil.generateOverridesInFunctionGroup(name, fromSupertypes, fromCurrent, this.classDescriptor, new OverridingUtil.DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    if (fakeOverride == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeOverride", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope$1", "addToScope"));
                    }
                    OverridingUtil.resolveUnknownVisibilityForMember(fakeOverride, null);
                    result2.add(fakeOverride);
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                    if (fromSuper == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromSuper", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope$1", "conflict"));
                    }
                    if (fromCurrent == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromCurrent", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope$1", "conflict"));
                    }
                }
            });
        }

        @Override
        protected void addNonDeclaredDescriptors(@NotNull Collection<DeclarationDescriptor> result2) {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "addNonDeclaredDescriptors"));
            }
            for (JetType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                for (DeclarationDescriptor descriptor : supertype.getMemberScope().getAllDescriptors()) {
                    if (descriptor instanceof FunctionDescriptor) {
                        result2.addAll(this.getFunctions(descriptor.getName()));
                        continue;
                    }
                    if (!(descriptor instanceof PropertyDescriptor)) continue;
                    result2.addAll(this.getProperties(descriptor.getName()));
                }
            }
        }

        @Override
        @Nullable
        protected ReceiverParameterDescriptor getImplicitReceiver() {
            return this.classDescriptor.getThisAsReceiverParameter();
        }

        @Override
        @Nullable
        protected ClassifierDescriptor getClassDescriptor(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "getClassDescriptor"));
            }
            return (ClassifierDescriptor)this.classDescriptor.nestedClasses.findClass.invoke(name);
        }

        @Override
        protected void addAllClassDescriptors(@NotNull Collection<DeclarationDescriptor> result2) {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "addAllClassDescriptors"));
            }
            result2.addAll(this.classDescriptor.nestedClasses.getAllDescriptors());
        }
    }

    private class DeserializedClassTypeConstructor
    extends AbstractClassTypeConstructor {
        private final Collection<JetType> supertypes;
        private final List<TypeParameterDescriptor> parameters;

        public DeserializedClassTypeConstructor(@NotNull List<TypeParameterDescriptor> typeParameters) {
            if (typeParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassTypeConstructor", "<init>"));
            }
            this.supertypes = DeserializedClassDescriptor.this.computeSuperTypes();
            this.parameters = typeParameters;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List<TypeParameterDescriptor> list = this.parameters;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassTypeConstructor", "getParameters"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<JetType> getSupertypes() {
            for (JetType supertype : this.supertypes) {
                if (!supertype.isError()) continue;
                List<JetType> list = KotlinPackage.filter(this.supertypes, new Function1<JetType, Boolean>(){

                    @Override
                    public Boolean invoke(JetType type) {
                        return !type.isError();
                    }
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassTypeConstructor", "getSupertypes"));
                }
                return list;
            }
            Collection<JetType> collection = this.supertypes;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassTypeConstructor", "getSupertypes"));
            }
            return collection;
        }

        @Override
        public boolean isFinal() {
            return !DeserializedClassDescriptor.this.getModality().isOverridable();
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getDeclarationDescriptor() {
            return DeserializedClassDescriptor.this;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations = Annotations.EMPTY;
            if (annotations == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassTypeConstructor", "getAnnotations"));
            }
            return annotations;
        }

        public String toString() {
            return DeserializedClassDescriptor.this.getName().toString();
        }
    }
}

