/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.Flags;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.SerializationPackage;
import org.jetbrains.jet.descriptors.serialization.TypeDeserializer;
import org.jetbrains.jet.descriptors.serialization.context.DeserializationContextWithTypes;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotatedCallableKind;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationLoader;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedTypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;

public class MemberDeserializer {
    private final DeserializationContextWithTypes context;

    public MemberDeserializer(@NotNull DeserializationContextWithTypes context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "<init>"));
        }
        this.context = context;
    }

    @NotNull
    public CallableMemberDescriptor loadCallable(@NotNull ProtoBuf.Callable proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "loadCallable"));
        }
        ProtoBuf.Callable.CallableKind callableKind = Flags.CALLABLE_KIND.get(proto.getFlags());
        switch (callableKind) {
            case FUN: {
                CallableMemberDescriptor callableMemberDescriptor = this.loadFunction(proto);
                if (callableMemberDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "loadCallable"));
                }
                return callableMemberDescriptor;
            }
            case VAL: 
            case VAR: {
                PropertyDescriptor propertyDescriptor = this.loadProperty(proto);
                if (propertyDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "loadCallable"));
                }
                return propertyDescriptor;
            }
            case CONSTRUCTOR: {
                CallableMemberDescriptor callableMemberDescriptor = this.loadConstructor(proto);
                if (callableMemberDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "loadCallable"));
                }
                return callableMemberDescriptor;
            }
        }
        throw new IllegalArgumentException("Unsupported callable kind: " + callableKind);
    }

    @NotNull
    private PropertyDescriptor loadProperty(final @NotNull ProtoBuf.Callable proto) {
        boolean isNotDefault;
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "loadProperty"));
        }
        int flags = proto.getFlags();
        DeserializedPropertyDescriptor property2 = new DeserializedPropertyDescriptor(this.context.getContainingDeclaration(), null, this.getAnnotations(proto, flags, AnnotatedCallableKind.PROPERTY), SerializationPackage.modality(Flags.MODALITY.get(flags)), SerializationPackage.visibility(Flags.VISIBILITY.get(flags)), Flags.CALLABLE_KIND.get(flags) == ProtoBuf.Callable.CallableKind.VAR, this.context.getNameResolver().getName(proto.getName()), SerializationPackage.memberKind(Flags.MEMBER_KIND.get(flags)), proto, this.context.getNameResolver());
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(proto.getTypeParameterCount());
        DeserializationContextWithTypes local = this.context.childContext(property2, proto.getTypeParameterList(), typeParameters);
        property2.setType(local.getTypeDeserializer().type(proto.getReturnType()), typeParameters, this.getExpectedThisObject(), local.getTypeDeserializer().typeOrNull(proto.hasReceiverType() ? proto.getReceiverType() : null));
        PropertyGetterDescriptorImpl getter = null;
        PropertySetterDescriptorImpl setter = null;
        if (Flags.HAS_GETTER.get(flags).booleanValue()) {
            int getterFlags = proto.getGetterFlags();
            boolean bl = isNotDefault = proto.hasGetterFlags() && Flags.IS_NOT_DEFAULT.get(getterFlags) != false;
            getter = isNotDefault ? new PropertyGetterDescriptorImpl(property2, this.getAnnotations(proto, getterFlags, AnnotatedCallableKind.PROPERTY_GETTER), SerializationPackage.modality(Flags.MODALITY.get(getterFlags)), SerializationPackage.visibility(Flags.VISIBILITY.get(getterFlags)), isNotDefault, !isNotDefault, property2.getKind(), null, SourceElement.NO_SOURCE) : DescriptorFactory.createDefaultGetter(property2);
            getter.initialize(property2.getReturnType());
        }
        if (Flags.HAS_SETTER.get(flags).booleanValue()) {
            int setterFlags = proto.getSetterFlags();
            boolean bl = isNotDefault = proto.hasSetterFlags() && Flags.IS_NOT_DEFAULT.get(setterFlags) != false;
            if (isNotDefault) {
                setter = new PropertySetterDescriptorImpl(property2, this.getAnnotations(proto, setterFlags, AnnotatedCallableKind.PROPERTY_SETTER), SerializationPackage.modality(Flags.MODALITY.get(setterFlags)), SerializationPackage.visibility(Flags.VISIBILITY.get(setterFlags)), isNotDefault, !isNotDefault, property2.getKind(), null, SourceElement.NO_SOURCE);
                DeserializationContextWithTypes setterLocal = local.childContext(setter, Collections.emptyList(), Collections.<TypeParameterDescriptor>emptyList());
                List<ValueParameterDescriptor> valueParameters = setterLocal.getDeserializer().valueParameters(proto, AnnotatedCallableKind.PROPERTY_SETTER);
                assert (valueParameters.size() == 1) : "Property setter should have a single value parameter: " + setter;
                setter.initialize(valueParameters.get(0));
            } else {
                setter = DescriptorFactory.createDefaultSetter(property2);
            }
        }
        if (Flags.HAS_CONSTANT.get(flags).booleanValue()) {
            property2.setCompileTimeInitializer(this.context.getStorageManager().createNullableLazyValue(new Function0<CompileTimeConstant<?>>(){

                @Override
                @Nullable
                public CompileTimeConstant<?> invoke() {
                    DeclarationDescriptor containingDeclaration = MemberDeserializer.this.context.getContainingDeclaration();
                    assert (containingDeclaration instanceof ClassOrPackageFragmentDescriptor) : "Only members in classes or package fragments should be serialized: " + containingDeclaration;
                    return MemberDeserializer.this.context.getConstantLoader().loadPropertyConstant((ClassOrPackageFragmentDescriptor)containingDeclaration, proto, MemberDeserializer.this.context.getNameResolver(), AnnotatedCallableKind.PROPERTY);
                }
            }));
        }
        property2.initialize(getter, setter);
        DeserializedPropertyDescriptor deserializedPropertyDescriptor = property2;
        if (deserializedPropertyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "loadProperty"));
        }
        return deserializedPropertyDescriptor;
    }

    @NotNull
    private CallableMemberDescriptor loadFunction(@NotNull ProtoBuf.Callable proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "loadFunction"));
        }
        int flags = proto.getFlags();
        DeserializedSimpleFunctionDescriptor function = DeserializedSimpleFunctionDescriptor.create(this.context.getContainingDeclaration(), proto, this.context.getAnnotationLoader(), this.context.getNameResolver());
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(proto.getTypeParameterCount());
        DeserializationContextWithTypes local = this.context.childContext(function, proto.getTypeParameterList(), typeParameters);
        function.initialize(local.getTypeDeserializer().typeOrNull(proto.hasReceiverType() ? proto.getReceiverType() : null), this.getExpectedThisObject(), typeParameters, (List)local.getDeserializer().valueParameters(proto, AnnotatedCallableKind.FUNCTION), local.getTypeDeserializer().type(proto.getReturnType()), SerializationPackage.modality(Flags.MODALITY.get(flags)), SerializationPackage.visibility(Flags.VISIBILITY.get(flags)));
        DeserializedSimpleFunctionDescriptor deserializedSimpleFunctionDescriptor = function;
        if (deserializedSimpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "loadFunction"));
        }
        return deserializedSimpleFunctionDescriptor;
    }

    @Nullable
    private ReceiverParameterDescriptor getExpectedThisObject() {
        DeclarationDescriptor containingDeclaration = this.context.getContainingDeclaration();
        return containingDeclaration instanceof ClassDescriptor ? ((ClassDescriptor)containingDeclaration).getThisAsReceiverParameter() : null;
    }

    @NotNull
    private CallableMemberDescriptor loadConstructor(@NotNull ProtoBuf.Callable proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "loadConstructor"));
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)this.context.getContainingDeclaration();
        ConstructorDescriptorImpl descriptor = ConstructorDescriptorImpl.create(classDescriptor, this.getAnnotations(proto, proto.getFlags(), AnnotatedCallableKind.FUNCTION), true, SourceElement.NO_SOURCE);
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(proto.getTypeParameterCount());
        DeserializationContextWithTypes local = this.context.childContext(descriptor, Collections.emptyList(), typeParameters);
        descriptor.initialize(classDescriptor.getTypeConstructor().getParameters(), local.getDeserializer().valueParameters(proto, AnnotatedCallableKind.FUNCTION), SerializationPackage.visibility(Flags.VISIBILITY.get(proto.getFlags())));
        descriptor.setReturnType(local.getTypeDeserializer().type(proto.getReturnType()));
        ConstructorDescriptorImpl constructorDescriptorImpl = descriptor;
        if (constructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "loadConstructor"));
        }
        return constructorDescriptorImpl;
    }

    @NotNull
    private Annotations getAnnotations(@NotNull ProtoBuf.Callable proto, int flags, @NotNull AnnotatedCallableKind kind) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "getAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "getAnnotations"));
        }
        Annotations annotations = MemberDeserializer.getAnnotations(this.context.getContainingDeclaration(), proto, flags, kind, this.context.getAnnotationLoader(), this.context.getNameResolver());
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "getAnnotations"));
        }
        return annotations;
    }

    public static Annotations getAnnotations(@NotNull DeclarationDescriptor containingDeclaration, @NotNull ProtoBuf.Callable proto, int flags, @NotNull AnnotatedCallableKind kind, @NotNull AnnotationLoader annotationLoader, @NotNull NameResolver nameResolver) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "getAnnotations"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "getAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "getAnnotations"));
        }
        if (annotationLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationLoader", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "getAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "getAnnotations"));
        }
        assert (containingDeclaration instanceof ClassOrPackageFragmentDescriptor) : "Only members in classes or package fragments should be serialized: " + containingDeclaration;
        return Flags.HAS_ANNOTATIONS.get(flags) != false ? annotationLoader.loadCallableAnnotations((ClassOrPackageFragmentDescriptor)containingDeclaration, proto, nameResolver, kind) : Annotations.EMPTY;
    }

    @NotNull
    public List<DeserializedTypeParameterDescriptor> typeParameters(@NotNull List<ProtoBuf.TypeParameter> protos, @NotNull TypeDeserializer typeDeserializer) {
        if (protos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protos", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "typeParameters"));
        }
        if (typeDeserializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDeserializer", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "typeParameters"));
        }
        ArrayList<DeserializedTypeParameterDescriptor> result2 = new ArrayList<DeserializedTypeParameterDescriptor>(protos.size());
        for (int i = 0; i < protos.size(); ++i) {
            ProtoBuf.TypeParameter proto = protos.get(i);
            DeserializedTypeParameterDescriptor descriptor = new DeserializedTypeParameterDescriptor(this.context.getStorageManager(), typeDeserializer, proto, this.context.getContainingDeclaration(), this.context.getNameResolver().getName(proto.getName()), SerializationPackage.variance(proto.getVariance()), proto.getReified(), i);
            result2.add(descriptor);
        }
        ArrayList<DeserializedTypeParameterDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "typeParameters"));
        }
        return arrayList;
    }

    @NotNull
    private List<ValueParameterDescriptor> valueParameters(@NotNull ProtoBuf.Callable callable2, @NotNull AnnotatedCallableKind kind) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "valueParameters"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "valueParameters"));
        }
        DeclarationDescriptor containerOfCallable = this.context.getContainingDeclaration().getContainingDeclaration();
        assert (containerOfCallable instanceof ClassOrPackageFragmentDescriptor) : "Only members in classes or package fragments should be serialized: " + containerOfCallable;
        ClassOrPackageFragmentDescriptor classOrPackage = (ClassOrPackageFragmentDescriptor)containerOfCallable;
        List<ProtoBuf.Callable.ValueParameter> protos = callable2.getValueParameterList();
        ArrayList<ValueParameterDescriptor> result2 = new ArrayList<ValueParameterDescriptor>(protos.size());
        for (int i = 0; i < protos.size(); ++i) {
            ProtoBuf.Callable.ValueParameter proto = protos.get(i);
            result2.add(new ValueParameterDescriptorImpl(this.context.getContainingDeclaration(), null, i, this.getAnnotations(classOrPackage, callable2, kind, proto), this.context.getNameResolver().getName(proto.getName()), this.context.getTypeDeserializer().type(proto.getType()), Flags.DECLARES_DEFAULT_VALUE.get(proto.getFlags()), this.context.getTypeDeserializer().typeOrNull(proto.hasVarargElementType() ? proto.getVarargElementType() : null), SourceElement.NO_SOURCE));
        }
        ArrayList<ValueParameterDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "valueParameters"));
        }
        return arrayList;
    }

    @NotNull
    private Annotations getAnnotations(@NotNull ClassOrPackageFragmentDescriptor classOrPackage, @NotNull ProtoBuf.Callable callable2, @NotNull AnnotatedCallableKind kind, @NotNull ProtoBuf.Callable.ValueParameter valueParameter) {
        if (classOrPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrPackage", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "getAnnotations"));
        }
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "getAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "getAnnotations"));
        }
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "getAnnotations"));
        }
        Annotations annotations = Flags.HAS_ANNOTATIONS.get(valueParameter.getFlags()) != false ? this.context.getAnnotationLoader().loadValueParameterAnnotations(classOrPackage, callable2, this.context.getNameResolver(), kind, valueParameter) : Annotations.EMPTY;
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/MemberDeserializer", "getAnnotations"));
        }
        return annotations;
    }
}

