/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.optimization.boxing;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.RangeCodegenUtil;
import org.jetbrains.jet.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.jet.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.jet.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

public class BoxingInterpreter
extends OptimizationBasicInterpreter {
    private static final ImmutableSet<String> UNBOXING_METHOD_NAMES = ImmutableSet.of("booleanValue", "charValue", "byteValue", "shortValue", "intValue", "floatValue", new String[]{"longValue", "doubleValue"});
    private final Map<Integer, BoxedBasicValue> boxingPlaces = new HashMap<Integer, BoxedBasicValue>();
    private final InsnList insnList;

    public BoxingInterpreter(InsnList insnList) {
        this.insnList = insnList;
    }

    @NotNull
    private BoxedBasicValue createNewBoxing(@NotNull AbstractInsnNode insn, @NotNull Type type, @Nullable ProgressionIteratorBasicValue progressionIterator) {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "createNewBoxing"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "createNewBoxing"));
        }
        int index = this.insnList.indexOf(insn);
        if (!this.boxingPlaces.containsKey(index)) {
            BoxedBasicValue boxedBasicValue = new BoxedBasicValue(type, insn, progressionIterator);
            this.onNewBoxedValue(boxedBasicValue);
            this.boxingPlaces.put(index, boxedBasicValue);
        }
        BoxedBasicValue boxedBasicValue = this.boxingPlaces.get(index);
        if (boxedBasicValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "createNewBoxing"));
        }
        return boxedBasicValue;
    }

    @Override
    @Nullable
    public BasicValue naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends BasicValue> values) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "naryOperation"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "naryOperation"));
        }
        Value value = super.naryOperation(insn, (List)values);
        if (values.isEmpty()) {
            return value;
        }
        BasicValue firstArg = values.get(0);
        if (BoxingInterpreter.isBoxing(insn)) {
            return this.createNewBoxing(insn, ((BasicValue)value).getType(), null);
        }
        if (BoxingInterpreter.isUnboxing(insn) && firstArg instanceof BoxedBasicValue) {
            this.onUnboxing(insn, (BoxedBasicValue)firstArg, ((BasicValue)value).getType());
        } else {
            if (BoxingInterpreter.isIteratorMethodCallOfProgression(insn, values)) {
                return new ProgressionIteratorBasicValue(BoxingInterpreter.getValuesTypeOfProgressionClass(firstArg.getType().getInternalName()));
            }
            if (BoxingInterpreter.isNextMethodCallOfProgressionIterator(insn, values)) {
                assert (firstArg instanceof ProgressionIteratorBasicValue) : "firstArg should be progression iterator";
                ProgressionIteratorBasicValue progressionIterator = (ProgressionIteratorBasicValue)firstArg;
                return this.createNewBoxing(insn, AsmUtil.boxType(progressionIterator.getValuesPrimitiveType()), progressionIterator);
            }
            for (BasicValue basicValue : values) {
                if (!(basicValue instanceof BoxedBasicValue)) continue;
                this.onMethodCallWithBoxedValue((BoxedBasicValue)basicValue);
            }
        }
        return value;
    }

    private static boolean isWrapperClassNameOrNumber(@NotNull String internalClassName) {
        if (internalClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalClassName", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "isWrapperClassNameOrNumber"));
        }
        return BoxingInterpreter.isWrapperClassName(internalClassName) || internalClassName.equals(Type.getInternalName(Number.class));
    }

    private static boolean isWrapperClassName(@NotNull String internalClassName) {
        if (internalClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalClassName", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "isWrapperClassName"));
        }
        return JvmPrimitiveType.isWrapperClassName(BoxingInterpreter.buildFqNameByInternal(internalClassName));
    }

    @NotNull
    private static FqName buildFqNameByInternal(@NotNull String internalClassName) {
        if (internalClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalClassName", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "buildFqNameByInternal"));
        }
        FqName fqName = new FqName(Type.getObjectType(internalClassName).getClassName());
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "buildFqNameByInternal"));
        }
        return fqName;
    }

    private static boolean isUnboxing(@NotNull AbstractInsnNode insn) {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "isUnboxing"));
        }
        if (insn.getOpcode() != 182) {
            return false;
        }
        MethodInsnNode methodInsn = (MethodInsnNode)insn;
        return BoxingInterpreter.isWrapperClassNameOrNumber(methodInsn.owner) && BoxingInterpreter.isUnboxingMethodName(methodInsn.name);
    }

    private static boolean isUnboxingMethodName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "isUnboxingMethodName"));
        }
        return UNBOXING_METHOD_NAMES.contains(name);
    }

    private static boolean isBoxing(@NotNull AbstractInsnNode insn) {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "isBoxing"));
        }
        if (insn.getOpcode() != 184) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)insn;
        return BoxingInterpreter.isWrapperClassName(methodInsnNode.owner) && "valueOf".equals(methodInsnNode.name);
    }

    private static boolean isNextMethodCallOfProgressionIterator(@NotNull AbstractInsnNode insn, @NotNull List<? extends BasicValue> values) {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "isNextMethodCallOfProgressionIterator"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "isNextMethodCallOfProgressionIterator"));
        }
        return insn.getOpcode() == 185 && values.get(0) instanceof ProgressionIteratorBasicValue && "next".equals(((MethodInsnNode)insn).name);
    }

    private static boolean isIteratorMethodCallOfProgression(@NotNull AbstractInsnNode insn, @NotNull List<? extends BasicValue> values) {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "isIteratorMethodCallOfProgression"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "isIteratorMethodCallOfProgression"));
        }
        return insn.getOpcode() == 185 && values.get(0).getType() != null && BoxingInterpreter.isProgressionClass(values.get(0).getType().getInternalName()) && "iterator".equals(((MethodInsnNode)insn).name);
    }

    private static boolean isProgressionClass(String internalClassName) {
        return RangeCodegenUtil.isRangeOrProgression(BoxingInterpreter.buildFqNameByInternal(internalClassName));
    }

    @NotNull
    private static String getValuesTypeOfProgressionClass(String progressionClassInternalName) {
        PrimitiveType type = RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(BoxingInterpreter.buildFqNameByInternal(progressionClassInternalName));
        assert (type != null) : "type should be not null";
        String string = type.getTypeName().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "getValuesTypeOfProgressionClass"));
        }
        return string;
    }

    @Override
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "unaryOperation"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "unaryOperation"));
        }
        if (insn.getOpcode() == 192 && BoxingInterpreter.isExactValue(value)) {
            return value;
        }
        return super.unaryOperation(insn, value);
    }

    private static boolean isExactValue(@NotNull BasicValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "isExactValue"));
        }
        return value instanceof ProgressionIteratorBasicValue || value instanceof BoxedBasicValue || value.getType() != null && BoxingInterpreter.isProgressionClass(value.getType().getInternalName());
    }

    @Override
    @NotNull
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "merge"));
        }
        if (w == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "w", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "merge"));
        }
        if (v instanceof BoxedBasicValue && ((BoxedBasicValue)v).typeEquals(w)) {
            this.onMergeSuccess((BoxedBasicValue)v, (BoxedBasicValue)w);
            BasicValue basicValue = v;
            if (basicValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "merge"));
            }
            return basicValue;
        }
        if (v instanceof BoxedBasicValue && w == BasicValue.UNINITIALIZED_VALUE) {
            BasicValue basicValue = v;
            if (basicValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "merge"));
            }
            return basicValue;
        }
        if (w instanceof BoxedBasicValue && v == BasicValue.UNINITIALIZED_VALUE) {
            BasicValue basicValue = w;
            if (basicValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "merge"));
            }
            return basicValue;
        }
        if (v instanceof BoxedBasicValue) {
            this.onMergeFail((BoxedBasicValue)v);
            BasicValue basicValue = MIXED_VALUE;
            if (basicValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "merge"));
            }
            return basicValue;
        }
        if (w instanceof BoxedBasicValue) {
            this.onMergeFail((BoxedBasicValue)w);
            BasicValue basicValue = MIXED_VALUE;
            if (basicValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "merge"));
            }
            return basicValue;
        }
        BasicValue basicValue = super.merge(v, w);
        if (basicValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "merge"));
        }
        return basicValue;
    }

    protected void onNewBoxedValue(@NotNull BoxedBasicValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "onNewBoxedValue"));
        }
    }

    protected void onUnboxing(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value, @NotNull Type resultType) {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "onUnboxing"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "onUnboxing"));
        }
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "onUnboxing"));
        }
    }

    protected void onMethodCallWithBoxedValue(@NotNull BoxedBasicValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "onMethodCallWithBoxedValue"));
        }
    }

    protected void onMergeFail(@NotNull BoxedBasicValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "onMergeFail"));
        }
    }

    protected void onMergeSuccess(@NotNull BoxedBasicValue v, @NotNull BoxedBasicValue w) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "onMergeSuccess"));
        }
        if (w == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "w", "org/jetbrains/jet/codegen/optimization/boxing/BoxingInterpreter", "onMergeSuccess"));
        }
    }
}

