/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.JvmCodegenUtil;
import org.jetbrains.jet.codegen.intrinsics.ArrayGet;
import org.jetbrains.jet.codegen.intrinsics.ArrayIndices;
import org.jetbrains.jet.codegen.intrinsics.ArrayIterator;
import org.jetbrains.jet.codegen.intrinsics.ArraySet;
import org.jetbrains.jet.codegen.intrinsics.ArraySize;
import org.jetbrains.jet.codegen.intrinsics.BinaryOp;
import org.jetbrains.jet.codegen.intrinsics.Clone;
import org.jetbrains.jet.codegen.intrinsics.CompareTo;
import org.jetbrains.jet.codegen.intrinsics.Concat;
import org.jetbrains.jet.codegen.intrinsics.CopyToArray;
import org.jetbrains.jet.codegen.intrinsics.EnumValueOf;
import org.jetbrains.jet.codegen.intrinsics.EnumValues;
import org.jetbrains.jet.codegen.intrinsics.Equals;
import org.jetbrains.jet.codegen.intrinsics.HashCode;
import org.jetbrains.jet.codegen.intrinsics.IdentityEquals;
import org.jetbrains.jet.codegen.intrinsics.Increment;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicsMap;
import org.jetbrains.jet.codegen.intrinsics.Inv;
import org.jetbrains.jet.codegen.intrinsics.IteratorNext;
import org.jetbrains.jet.codegen.intrinsics.JavaClassArray;
import org.jetbrains.jet.codegen.intrinsics.JavaClassFunction;
import org.jetbrains.jet.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.jet.codegen.intrinsics.MonitorInstruction;
import org.jetbrains.jet.codegen.intrinsics.NewArray;
import org.jetbrains.jet.codegen.intrinsics.Not;
import org.jetbrains.jet.codegen.intrinsics.NumberCast;
import org.jetbrains.jet.codegen.intrinsics.RangeTo;
import org.jetbrains.jet.codegen.intrinsics.StringGetChar;
import org.jetbrains.jet.codegen.intrinsics.StringLength;
import org.jetbrains.jet.codegen.intrinsics.StringPlus;
import org.jetbrains.jet.codegen.intrinsics.ToString;
import org.jetbrains.jet.codegen.intrinsics.UnaryMinus;
import org.jetbrains.jet.codegen.intrinsics.UnaryPlus;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.CompileTimeConstantUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;

public class IntrinsicMethods {
    private static final IntrinsicMethod UNARY_MINUS = new UnaryMinus();
    private static final IntrinsicMethod UNARY_PLUS = new UnaryPlus();
    private static final IntrinsicMethod NUMBER_CAST = new NumberCast();
    private static final IntrinsicMethod INV = new Inv();
    private static final IntrinsicMethod RANGE_TO = new RangeTo();
    private static final IntrinsicMethod INC = new Increment(1);
    private static final IntrinsicMethod DEC = new Increment(-1);
    private static final IntrinsicMethod HASH_CODE = new HashCode();
    private static final IntrinsicMethod ARRAY_SIZE = new ArraySize();
    private static final IntrinsicMethod ARRAY_INDICES = new ArrayIndices();
    private static final Equals EQUALS = new Equals();
    private static final IdentityEquals IDENTITY_EQUALS = new IdentityEquals();
    private static final IteratorNext ITERATOR_NEXT = new IteratorNext();
    private static final ArraySet ARRAY_SET = new ArraySet();
    private static final ArrayGet ARRAY_GET = new ArrayGet();
    private static final StringPlus STRING_PLUS = new StringPlus();
    private static final EnumValues ENUM_VALUES = new EnumValues();
    private static final EnumValueOf ENUM_VALUE_OF = new EnumValueOf();
    private static final ToString TO_STRING = new ToString();
    private static final Clone CLONE = new Clone();
    private static final FqNameUnsafe KOTLIN_ANY_FQ_NAME = DescriptorUtils.getFqName(KotlinBuiltIns.getInstance().getAny());
    private static final FqNameUnsafe KOTLIN_STRING_FQ_NAME = DescriptorUtils.getFqName(KotlinBuiltIns.getInstance().getString());
    private final Map<String, IntrinsicMethod> namedMethods = new HashMap<String, IntrinsicMethod>();
    private static final IntrinsicMethod ARRAY_ITERATOR = new ArrayIterator();
    private final IntrinsicsMap intrinsicsMap = new IntrinsicsMap();

    public IntrinsicMethods() {
        String typeName;
        this.namedMethods.put("kotlin.javaClass.function", new JavaClassFunction());
        this.namedMethods.put("kotlin.javaClass.property", new JavaClassProperty());
        this.namedMethods.put("kotlin.arrays.array", new JavaClassArray());
        this.namedMethods.put("kotlin.collections.copyToArray", new CopyToArray());
        this.namedMethods.put("kotlin.jvm.internal.unsafe.monitorEnter", MonitorInstruction.MONITOR_ENTER);
        this.namedMethods.put("kotlin.jvm.internal.unsafe.monitorExit", MonitorInstruction.MONITOR_EXIT);
        ImmutableList primitiveCastMethods = OperatorConventions.NUMBER_CONVERSIONS.asList();
        for (Name method : primitiveCastMethods) {
            String methodName = method.asString();
            this.declareIntrinsicFunction("Number", methodName, 0, NUMBER_CAST);
            for (PrimitiveType type : PrimitiveType.NUMBER_TYPES) {
                this.declareIntrinsicFunction(type.getTypeName().asString(), methodName, 0, NUMBER_CAST);
            }
        }
        for (PrimitiveType type : PrimitiveType.NUMBER_TYPES) {
            String typeName2 = type.getTypeName().asString();
            this.declareIntrinsicFunction(typeName2, "plus", 0, UNARY_PLUS);
            this.declareIntrinsicFunction(typeName2, "minus", 0, UNARY_MINUS);
            this.declareIntrinsicFunction(typeName2, "inv", 0, INV);
            this.declareIntrinsicFunction(typeName2, "rangeTo", 1, RANGE_TO);
            this.declareIntrinsicFunction(typeName2, "inc", 0, INC);
            this.declareIntrinsicFunction(typeName2, "dec", 0, DEC);
        }
        for (PrimitiveType type : PrimitiveType.values()) {
            typeName = type.getTypeName().asString();
            this.declareIntrinsicFunction(typeName, "equals", 1, EQUALS);
            this.declareIntrinsicFunction(typeName, "hashCode", 0, HASH_CODE);
            this.declareIntrinsicFunction(typeName, "toString", 0, TO_STRING);
        }
        this.declareBinaryOp("plus", 96);
        this.declareBinaryOp("minus", 100);
        this.declareBinaryOp("times", 104);
        this.declareBinaryOp("div", 108);
        this.declareBinaryOp("mod", 112);
        this.declareBinaryOp("shl", 120);
        this.declareBinaryOp("shr", 122);
        this.declareBinaryOp("ushr", 124);
        this.declareBinaryOp("and", 126);
        this.declareBinaryOp("or", 128);
        this.declareBinaryOp("xor", 130);
        this.declareIntrinsicFunction("Boolean", "not", 0, new Not());
        this.declareIntrinsicFunction("String", "plus", 1, new Concat());
        this.declareIntrinsicFunction("CharSequence", "get", 1, new StringGetChar());
        this.declareIntrinsicFunction("String", "get", 1, new StringGetChar());
        this.declareIntrinsicFunction("Cloneable", "clone", 0, CLONE);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, KOTLIN_ANY_FQ_NAME, "toString", 0, TO_STRING);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, KOTLIN_ANY_FQ_NAME, "equals", 1, EQUALS);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, KOTLIN_ANY_FQ_NAME, "identityEquals", 1, IDENTITY_EQUALS);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, KOTLIN_STRING_FQ_NAME, "plus", 1, STRING_PLUS);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, null, "arrayOfNulls", 1, new NewArray());
        for (PrimitiveType type : PrimitiveType.values()) {
            typeName = type.getTypeName().asString();
            this.declareIntrinsicFunction(typeName, "compareTo", 1, new CompareTo());
            this.declareIntrinsicFunction(typeName + "Iterator", "next", 0, ITERATOR_NEXT);
        }
        this.declareIntrinsicProperty("CharSequence", "length", new StringLength());
        this.declareIntrinsicProperty("String", "length", new StringLength());
        this.declareArrayMethods();
    }

    private void declareArrayMethods() {
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            this.declareArrayMethodsForPrimitive(jvmPrimitiveType);
        }
        this.declareIntrinsicProperty("Array", "size", ARRAY_SIZE);
        this.declareIntrinsicProperty("Array", "indices", ARRAY_INDICES);
        this.declareIntrinsicFunction("Array", "set", 2, ARRAY_SET);
        this.declareIntrinsicFunction("Array", "get", 1, ARRAY_GET);
        this.declareIntrinsicFunction("Array", "clone", 0, CLONE);
        this.declareIterator("Array");
    }

    private void declareArrayMethodsForPrimitive(@NotNull JvmPrimitiveType jvmPrimitiveType) {
        if (jvmPrimitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmPrimitiveType", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "declareArrayMethodsForPrimitive"));
        }
        String arrayTypeName = jvmPrimitiveType.getPrimitiveType().getArrayTypeName().asString();
        this.declareIntrinsicProperty(arrayTypeName, "size", ARRAY_SIZE);
        this.declareIntrinsicProperty(arrayTypeName, "indices", ARRAY_INDICES);
        this.declareIntrinsicFunction(arrayTypeName, "set", 2, ARRAY_SET);
        this.declareIntrinsicFunction(arrayTypeName, "get", 1, ARRAY_GET);
        this.declareIntrinsicFunction(arrayTypeName, "clone", 0, CLONE);
        this.declareIterator(arrayTypeName);
    }

    private void declareIterator(@NotNull String arrayClassName) {
        if (arrayClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayClassName", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "declareIterator"));
        }
        this.declareIntrinsicFunction(arrayClassName, "iterator", 0, ARRAY_ITERATOR);
    }

    private void declareBinaryOp(@NotNull String methodName, int opcode) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "declareBinaryOp"));
        }
        BinaryOp op = new BinaryOp(opcode);
        for (PrimitiveType type : PrimitiveType.values()) {
            this.declareIntrinsicFunction(type.getTypeName().asString(), methodName, 1, op);
        }
    }

    private void declareIntrinsicProperty(@NotNull String className, @NotNull String methodName, @NotNull IntrinsicMethod implementation) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "declareIntrinsicProperty"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "declareIntrinsicProperty"));
        }
        if (implementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementation", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "declareIntrinsicProperty"));
        }
        this.declareIntrinsicFunction(className, methodName, -1, implementation);
    }

    private void declareIntrinsicFunction(@NotNull String className, @NotNull String methodName, int arity, @NotNull IntrinsicMethod implementation) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "declareIntrinsicFunction"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "declareIntrinsicFunction"));
        }
        if (implementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementation", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "declareIntrinsicFunction"));
        }
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(className)), null, methodName, arity, implementation);
    }

    @Nullable
    public IntrinsicMethod getIntrinsic(@NotNull CallableMemberDescriptor descriptor) {
        String value;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "getIntrinsic"));
        }
        IntrinsicMethod intrinsicMethod = this.intrinsicsMap.getIntrinsic(descriptor);
        if (intrinsicMethod != null) {
            return intrinsicMethod;
        }
        if (descriptor instanceof SimpleFunctionDescriptor) {
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)descriptor;
            DeclarationDescriptor container = descriptor.getContainingDeclaration();
            if (DescriptorUtils.isClassObject(container) && DescriptorUtils.isEnumClass(container.getContainingDeclaration())) {
                if (JvmCodegenUtil.isEnumValuesMethod(functionDescriptor)) {
                    return ENUM_VALUES;
                }
                if (JvmCodegenUtil.isEnumValueOfMethod(functionDescriptor)) {
                    return ENUM_VALUE_OF;
                }
            }
        }
        if ((value = CompileTimeConstantUtils.getIntrinsicAnnotationArgument(descriptor)) == null) {
            return null;
        }
        return this.namedMethods.get(value);
    }
}

