/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.binding;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilderFactories;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetStubbedPsiUtil;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.kotlin.PackagePartClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.org.objectweb.asm.Type;

public final class PsiCodegenPredictor {
    private PsiCodegenPredictor() {
    }

    public static boolean checkPredictedNameFromPsi(@NotNull DeclarationDescriptor descriptor, @Nullable Type nameFromDescriptors) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "checkPredictedNameFromPsi"));
        }
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor);
        if (element instanceof JetDeclaration) {
            String classNameFromPsi = PsiCodegenPredictor.getPredefinedJvmInternalName((JetDeclaration)element);
            assert (classNameFromPsi == null || Type.getObjectType(classNameFromPsi).equals(nameFromDescriptors)) : String.format("Invalid algorithm for getting qualified name from psi! Predicted: %s, actual %s\nElement: %s", classNameFromPsi, nameFromDescriptors, element.getText());
        }
        return true;
    }

    @Nullable
    public static String getPredefinedJvmInternalName(@NotNull JetDeclaration declaration) {
        String parentInternalName;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getPredefinedJvmInternalName"));
        }
        JetDeclaration parentDeclaration = JetStubbedPsiUtil.getContainingDeclaration(declaration);
        if (parentDeclaration instanceof JetClassObject) {
            assert (declaration instanceof JetObjectDeclaration) : "Only object declarations can be children of JetClassObject: " + declaration;
            return PsiCodegenPredictor.getPredefinedJvmInternalName(parentDeclaration);
        }
        if (parentDeclaration != null) {
            parentInternalName = PsiCodegenPredictor.getPredefinedJvmInternalName(parentDeclaration);
            if (parentInternalName == null) {
                return null;
            }
        } else {
            FqName packageFqName = declaration.getContainingJetFile().getPackageFqName();
            if (declaration instanceof JetNamedFunction) {
                Name name = ((JetNamedFunction)declaration).getNameAsName();
                return name == null ? null : PackageClassUtils.getPackageClassInternalName(packageFqName) + "$" + name.asString();
            }
            parentInternalName = AsmUtil.internalNameByFqNameWithoutInnerClasses(packageFqName);
        }
        if (declaration instanceof JetClassObject) {
            return parentInternalName + "$object";
        }
        if (!PsiTreeUtil.instanceOf(declaration, JetClass.class, JetObjectDeclaration.class, JetNamedFunction.class, JetProperty.class) || declaration instanceof JetEnumEntry) {
            return null;
        }
        Name name = ((JetNamedDeclaration)declaration).getNameAsName();
        if (name == null) {
            return null;
        }
        if (declaration instanceof JetNamedFunction && !(parentDeclaration instanceof JetClass) && !(parentDeclaration instanceof JetObjectDeclaration)) {
            return null;
        }
        if (declaration instanceof JetProperty) {
            return parentInternalName + "$" + name.asString();
        }
        if (parentInternalName.isEmpty()) {
            return name.asString();
        }
        return parentInternalName + (parentDeclaration == null ? "/" : "$") + name.asString();
    }

    @Nullable
    public static JetFile getFileForPackagePartName(@NotNull Collection<JetFile> allPackageFiles, @NotNull JvmClassName className) {
        if (allPackageFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPackageFiles", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForPackagePartName"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForPackagePartName"));
        }
        for (JetFile file : allPackageFiles) {
            String internalName = PackagePartClassUtils.getPackagePartInternalName(file);
            JvmClassName jvmClassName = JvmClassName.byInternalName(internalName);
            if (!jvmClassName.equals(className)) continue;
            return file;
        }
        return null;
    }

    @Nullable
    public static JetFile getFileForCodegenNamedClass(@NotNull ModuleDescriptor module, @NotNull BindingContext context, @NotNull Collection<JetFile> allPackageFiles, @NotNull String classInternalName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForCodegenNamedClass"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForCodegenNamedClass"));
        }
        if (allPackageFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPackageFiles", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForCodegenNamedClass"));
        }
        if (classInternalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classInternalName", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForCodegenNamedClass"));
        }
        Project project = allPackageFiles.iterator().next().getProject();
        GenerationState state = new GenerationState(project, ClassBuilderFactories.THROW_EXCEPTION, module, context, new ArrayList<JetFile>(allPackageFiles));
        state.beforeCompile();
        BindingTrace trace = state.getBindingTrace();
        for (ClassDescriptor classDescriptor : trace.getKeys(CodegenBinding.ASM_TYPE)) {
            Type type = trace.get(CodegenBinding.ASM_TYPE, classDescriptor);
            if (type == null || !classInternalName.equals(type.getInternalName())) continue;
            return DescriptorToSourceUtils.getContainingFile(classDescriptor);
        }
        return null;
    }
}

