/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Stack;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.context.PackageContext;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.codeFragmentUtil.CodeFragmentUtilPackage;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaPackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.java.lazy.descriptors.LazyPackageFragmentScopeForJavaPackage;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileKotlinClass;
import org.jetbrains.jet.lang.resolve.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class JvmCodegenUtil {
    private JvmCodegenUtil() {
    }

    public static boolean isInterface(DeclarationDescriptor descriptor) {
        if (descriptor instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor).getKind();
            return kind == ClassKind.TRAIT || kind == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isInterface(JetType type) {
        return JvmCodegenUtil.isInterface(type.getConstructor().getDeclarationDescriptor());
    }

    public static boolean isConst(@NotNull CalculatedClosure closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isConst"));
        }
        return closure.getCaptureThis() == null && closure.getCaptureReceiverType() == null && closure.getCaptureVariables().isEmpty();
    }

    public static <T> T peekFromStack(Stack<T> stack) {
        return stack.empty() ? null : (T)stack.peek();
    }

    @Nullable
    public static FunctionDescriptor getDeclaredFunctionByRawSignature(@NotNull ClassDescriptor owner, @NotNull Name name, @NotNull ClassifierDescriptor returnedClassifier, ClassifierDescriptor ... valueParameterClassifiers) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (returnedClassifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnedClassifier", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (valueParameterClassifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterClassifiers", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        Collection<FunctionDescriptor> functions2 = owner.getDefaultType().getMemberScope().getFunctions(name);
        for (FunctionDescriptor function : functions2) {
            if (CallResolverUtil.isOrOverridesSynthesized(function) || !function.getTypeParameters().isEmpty() || !JvmCodegenUtil.valueParameterClassesMatch(function.getValueParameters(), Arrays.asList(valueParameterClassifiers)) || !JvmCodegenUtil.rawTypeMatches(function.getReturnType(), returnedClassifier)) continue;
            return function;
        }
        return null;
    }

    private static boolean valueParameterClassesMatch(@NotNull List<ValueParameterDescriptor> parameters, @NotNull List<ClassifierDescriptor> classifiers) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/jet/codegen/JvmCodegenUtil", "valueParameterClassesMatch"));
        }
        if (classifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifiers", "org/jetbrains/jet/codegen/JvmCodegenUtil", "valueParameterClassesMatch"));
        }
        if (parameters.size() != classifiers.size()) {
            return false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            ValueParameterDescriptor parameterDescriptor = parameters.get(i);
            ClassifierDescriptor classDescriptor = classifiers.get(i);
            if (JvmCodegenUtil.rawTypeMatches(parameterDescriptor.getType(), classDescriptor)) continue;
            return false;
        }
        return true;
    }

    private static boolean rawTypeMatches(JetType type, ClassifierDescriptor classifier2) {
        return type.getConstructor().getDeclarationDescriptor().getOriginal() == classifier2.getOriginal();
    }

    private static boolean isCallInsideSameClassAsDeclared(@NotNull CallableMemberDescriptor descriptor, @NotNull CodegenContext context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isCallInsideSameClassAsDeclared"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isCallInsideSameClassAsDeclared"));
        }
        boolean isFakeOverride = descriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        boolean isDelegate = descriptor.getKind() == CallableMemberDescriptor.Kind.DELEGATION;
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration().getOriginal();
        return !isFakeOverride && !isDelegate && (context.hasThisDescriptor() && containingDeclaration == context.getThisDescriptor() || context.getParentContext() instanceof PackageContext && JvmCodegenUtil.isSamePackageInSameModule(context.getParentContext().getContextDescriptor(), containingDeclaration)) && context.getContextKind() != OwnerKind.TRAIT_IMPL;
    }

    private static boolean isSamePackageInSameModule(@NotNull DeclarationDescriptor callerOwner, @NotNull DeclarationDescriptor calleeOwner) {
        if (callerOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callerOwner", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isSamePackageInSameModule"));
        }
        if (calleeOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeOwner", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isSamePackageInSameModule"));
        }
        if (callerOwner instanceof PackageFragmentDescriptor && calleeOwner instanceof PackageFragmentDescriptor) {
            PackageFragmentDescriptor callerFragment = (PackageFragmentDescriptor)callerOwner;
            PackageFragmentDescriptor calleeFragment = (PackageFragmentDescriptor)calleeOwner;
            if (callerFragment == calleeFragment) {
                return true;
            }
            return callerFragment.getFqName().equals(calleeFragment.getFqName()) && calleeFragment instanceof IncrementalPackageFragmentProvider.IncrementalPackageFragment;
        }
        return false;
    }

    public static boolean isCallInsideSameModuleAsDeclared(@NotNull CallableMemberDescriptor declarationDescriptor, @NotNull CodegenContext context, @Nullable File outDirectory) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isCallInsideSameModuleAsDeclared"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isCallInsideSameModuleAsDeclared"));
        }
        if (context == CodegenContext.STATIC) {
            return true;
        }
        Object contextDescriptor = context.getContextDescriptor();
        CallableMemberDescriptor directMember = JvmCodegenUtil.getDirectMember(declarationDescriptor);
        if (directMember instanceof DeserializedCallableMemberDescriptor) {
            return JvmCodegenUtil.isContainedByCompiledPartOfOurModule((DeserializedCallableMemberDescriptor)directMember, outDirectory);
        }
        return DescriptorUtils.areInSameModule(directMember, contextDescriptor);
    }

    private static boolean isContainedByCompiledPartOfOurModule(@NotNull DeserializedCallableMemberDescriptor descriptor, @Nullable File outDirectory) {
        VirtualFile file;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isContainedByCompiledPartOfOurModule"));
        }
        if (descriptor.getContainingDeclaration() instanceof IncrementalPackageFragmentProvider.IncrementalPackageFragment) {
            return true;
        }
        if (outDirectory == null) {
            return false;
        }
        if (!(descriptor.getContainingDeclaration() instanceof JavaPackageFragmentDescriptor)) {
            return false;
        }
        JavaPackageFragmentDescriptor packageFragment = (JavaPackageFragmentDescriptor)descriptor.getContainingDeclaration();
        JetScope packageScope = packageFragment.getMemberScope();
        if (!(packageScope instanceof LazyPackageFragmentScopeForJavaPackage)) {
            return false;
        }
        KotlinJvmBinaryClass binaryClass = ((LazyPackageFragmentScopeForJavaPackage)packageScope).getKotlinBinaryClass();
        if (binaryClass instanceof VirtualFileKotlinClass && (file = ((VirtualFileKotlinClass)binaryClass).getFile()).getFileSystem().getProtocol() == "file") {
            File ioFile = VfsUtilCore.virtualToIoFile(file);
            return ioFile.getAbsolutePath().startsWith(outDirectory.getAbsolutePath() + File.separator);
        }
        return false;
    }

    public static boolean hasAbstractMembers(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "hasAbstractMembers"));
        }
        return KotlinPackage.any(classDescriptor.getDefaultType().getMemberScope().getAllDescriptors(), new Function1<DeclarationDescriptor, Boolean>(){

            @Override
            public Boolean invoke(DeclarationDescriptor descriptor) {
                return descriptor instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor).getModality() == Modality.ABSTRACT;
            }
        });
    }

    public static boolean couldUseDirectAccessToProperty(@NotNull PropertyDescriptor property2, boolean forGetter, boolean isDelegated, @NotNull MethodContext context) {
        PropertyAccessorDescriptor accessor;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/codegen/JvmCodegenUtil", "couldUseDirectAccessToProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/JvmCodegenUtil", "couldUseDirectAccessToProperty"));
        }
        if (JetTypeMapper.isAccessor(property2)) {
            return false;
        }
        if (context.isInlineFunction()) {
            return false;
        }
        if (!JvmCodegenUtil.isCallInsideSameClassAsDeclared(property2, context) && !JvmCodegenUtil.isDebuggerContext(context)) {
            return false;
        }
        if (isDelegated || property2.getReceiverParameter() != null) {
            return false;
        }
        if (DescriptorUtils.isClassObject(property2.getContainingDeclaration())) {
            return false;
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = forGetter ? property2.getGetter() : property2.getSetter();
        if (accessor == null) {
            return true;
        }
        if (accessor.hasBody()) {
            return false;
        }
        return property2.getVisibility() == Visibilities.PRIVATE || accessor.getModality() == Modality.FINAL;
    }

    private static boolean isDebuggerContext(@NotNull MethodContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isDebuggerContext"));
        }
        JetFile file = DescriptorToSourceUtils.getContainingFile(context.getContextDescriptor());
        return file != null && CodeFragmentUtilPackage.getSkipVisibilityCheck(file);
    }

    @NotNull
    public static ImplementationBodyCodegen getParentBodyCodegen(@Nullable MemberCodegen<?> classBodyCodegen) {
        assert (classBodyCodegen != null && classBodyCodegen.getParentCodegen() instanceof ImplementationBodyCodegen) : "Class object should have appropriate parent BodyCodegen";
        ImplementationBodyCodegen implementationBodyCodegen = (ImplementationBodyCodegen)classBodyCodegen.getParentCodegen();
        if (implementationBodyCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getParentBodyCodegen"));
        }
        return implementationBodyCodegen;
    }

    @Nullable
    public static ClassDescriptor getExpectedThisObjectForConstructorCall(@NotNull ConstructorDescriptor descriptor, @Nullable CalculatedClosure closure) {
        ClassDescriptor expectedThisClass;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getExpectedThisObjectForConstructorCall"));
        }
        if (closure != null) {
            return closure.getCaptureThis();
        }
        ReceiverParameterDescriptor expectedThisObject = descriptor.getExpectedThisObject();
        if (expectedThisObject != null && !(expectedThisClass = (ClassDescriptor)expectedThisObject.getContainingDeclaration()).getKind().isSingleton()) {
            return expectedThisClass;
        }
        return null;
    }

    public static boolean isEnumValueOfMethod(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isEnumValueOfMethod"));
        }
        List<ValueParameterDescriptor> methodTypeParameters = functionDescriptor.getValueParameters();
        JetType nullableString = TypeUtils.makeNullable(KotlinBuiltIns.getInstance().getStringType());
        return "valueOf".equals(functionDescriptor.getName().asString()) && methodTypeParameters.size() == 1 && JetTypeChecker.DEFAULT.isSubtypeOf(methodTypeParameters.get(0).getType(), nullableString);
    }

    public static boolean isEnumValuesMethod(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isEnumValuesMethod"));
        }
        List<ValueParameterDescriptor> methodTypeParameters = functionDescriptor.getValueParameters();
        return "values".equals(functionDescriptor.getName().asString()) && methodTypeParameters.isEmpty();
    }

    @NotNull
    public static CallableMemberDescriptor getDirectMember(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getDirectMember"));
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor instanceof PropertyAccessorDescriptor ? ((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty() : descriptor;
        if (callableMemberDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getDirectMember"));
        }
        return callableMemberDescriptor;
    }
}

