/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.bridges.BridgesPackage;
import org.jetbrains.jet.codegen.context.ClassContext;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;

public abstract class ClassBodyCodegen
extends MemberCodegen<JetClassOrObject> {
    protected final JetClassOrObject myClass;
    protected final OwnerKind kind;
    protected final ClassDescriptor descriptor;

    protected ClassBodyCodegen(@NotNull JetClassOrObject aClass, @NotNull ClassContext context, @NotNull ClassBuilder v, @NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/jet/codegen/ClassBodyCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/ClassBodyCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/ClassBodyCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/ClassBodyCodegen", "<init>"));
        }
        super(state, parentCodegen, context, aClass, v);
        this.myClass = aClass;
        this.kind = context.getContextKind();
        this.descriptor = this.bindingContext.get(BindingContext.CLASS, aClass);
    }

    @Override
    protected void generateBody() {
        if (this.kind != OwnerKind.TRAIT_IMPL) {
            for (JetDeclaration declaration : this.myClass.getDeclarations()) {
                if (!ClassBodyCodegen.shouldProcessFirst(declaration)) continue;
                this.generateDeclaration(this.propertyCodegen, declaration);
            }
        }
        for (JetDeclaration declaration : this.myClass.getDeclarations()) {
            if (ClassBodyCodegen.shouldProcessFirst(declaration)) continue;
            this.generateDeclaration(this.propertyCodegen, declaration);
        }
        if (!DescriptorUtils.isTrait(this.descriptor)) {
            for (DeclarationDescriptor memberDescriptor : this.descriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
                FunctionDescriptor member;
                if (!(memberDescriptor instanceof FunctionDescriptor) || (member = (FunctionDescriptor)memberDescriptor).getKind().isReal() || BridgesPackage.findTraitImplementation(member) != null) continue;
                this.functionCodegen.generateBridges(member);
            }
        }
        this.generatePrimaryConstructorProperties(this.propertyCodegen, this.myClass);
    }

    private static boolean shouldProcessFirst(JetDeclaration declaration) {
        return !(declaration instanceof JetProperty) && !(declaration instanceof JetNamedFunction);
    }

    protected void generateDeclaration(PropertyCodegen propertyCodegen, JetDeclaration declaration) {
        if (declaration instanceof JetProperty || declaration instanceof JetNamedFunction) {
            this.genFunctionOrProperty(declaration);
        } else if (declaration instanceof JetClassOrObject) {
            if (declaration instanceof JetEnumEntry && !CodegenBinding.enumEntryNeedSubclass(this.state.getBindingContext(), (JetEnumEntry)declaration)) {
                return;
            }
            this.genClassOrObject((JetClassOrObject)declaration);
        } else if (declaration instanceof JetClassObject) {
            this.genClassOrObject(((JetClassObject)declaration).getObjectDeclaration());
        }
    }

    private void generatePrimaryConstructorProperties(PropertyCodegen propertyCodegen, JetClassOrObject origin) {
        boolean isAnnotation = origin instanceof JetClass && ((JetClass)origin).isAnnotation();
        for (JetParameter p : this.getPrimaryConstructorParameters()) {
            PropertyDescriptor propertyDescriptor;
            if (!p.hasValOrVarNode() || (propertyDescriptor = this.state.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, p)) == null) continue;
            if (!isAnnotation) {
                propertyCodegen.generatePrimaryConstructorProperty(p, propertyDescriptor);
                continue;
            }
            propertyCodegen.generateConstructorPropertyAsMethodForAnnotationClass(p, propertyDescriptor);
        }
    }

    @NotNull
    protected List<JetParameter> getPrimaryConstructorParameters() {
        if (this.myClass instanceof JetClass) {
            List<JetParameter> list = ((JetClass)this.myClass).getPrimaryConstructorParameters();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassBodyCodegen", "getPrimaryConstructorParameters"));
            }
            return list;
        }
        List<JetParameter> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassBodyCodegen", "getPrimaryConstructorParameters"));
        }
        return list;
    }
}

