/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MethodSignatureBase
implements MethodSignature {
    private final PsiSubstitutor mySubstitutor;
    private final PsiType[] myParameterTypes;
    private volatile PsiType[] myErasedParameterTypes;
    protected final PsiTypeParameter[] myTypeParameters;

    protected MethodSignatureBase(@NotNull PsiSubstitutor substitutor, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameters) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/MethodSignatureBase", "<init>"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "com/intellij/psi/util/MethodSignatureBase", "<init>"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/util/MethodSignatureBase", "<init>"));
        }
        this.mySubstitutor = substitutor;
        assert (substitutor.isValid());
        this.myParameterTypes = PsiType.createArray(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            PsiType type = parameterTypes[i];
            if (type != null) {
                PsiUtil.ensureValidType(type);
            }
            if (type instanceof PsiEllipsisType) {
                type = ((PsiEllipsisType)type).toArrayType();
            }
            this.myParameterTypes[i] = substitutor.substitute(type);
        }
        this.myTypeParameters = typeParameters;
    }

    protected MethodSignatureBase(@NotNull PsiSubstitutor substitutor, @Nullable PsiParameterList parameterList, @Nullable PsiTypeParameterList typeParameterList) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/MethodSignatureBase", "<init>"));
        }
        this.mySubstitutor = substitutor;
        if (parameterList == null) {
            this.myParameterTypes = PsiType.EMPTY_ARRAY;
        } else {
            PsiParameter[] parameters = parameterList.getParameters();
            this.myParameterTypes = PsiType.createArray(parameters.length);
            for (int i = 0; i < parameters.length; ++i) {
                PsiType type = parameters[i].getType();
                if (type instanceof PsiEllipsisType) {
                    type = ((PsiEllipsisType)type).toArrayType();
                }
                this.myParameterTypes[i] = substitutor.substitute(type);
            }
        }
        this.myTypeParameters = typeParameterList == null ? PsiTypeParameter.EMPTY_ARRAY : typeParameterList.getTypeParameters();
    }

    @Override
    @NotNull
    public PsiType[] getParameterTypes() {
        if (this.myParameterTypes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureBase", "getParameterTypes"));
        }
        return this.myParameterTypes;
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        if (this.myTypeParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureBase", "getTypeParameters"));
        }
        return this.myTypeParameters;
    }

    public PsiType[] getErasedParameterTypes() {
        PsiType[] result2 = this.myErasedParameterTypes;
        if (result2 == null) {
            result2 = MethodSignatureUtil.calcErasedParameterTypes(this);
            this.myErasedParameterTypes = result2;
        }
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature methodSignature = (MethodSignature)o;
        return MethodSignatureUtil.areSignaturesEqual(methodSignature, this);
    }

    public int hashCode() {
        int result2 = this.getName().hashCode();
        PsiType[] parameterTypes = this.getErasedParameterTypes();
        result2 = 31 * result2 + parameterTypes.length;
        int length = Math.min(3, parameterTypes.length);
        for (int i = 0; i < length; ++i) {
            PsiType type = parameterTypes[i];
            if (type == null) continue;
            result2 = 31 * result2 + type.hashCode();
        }
        return result2;
    }

    public String toString() {
        String s = this.getClass().getSimpleName() + ": ";
        PsiTypeParameter[] typeParameters = this.getTypeParameters();
        if (typeParameters.length != 0) {
            String sep = "<";
            for (PsiTypeParameter typeParameter : typeParameters) {
                s = s + sep + typeParameter.getName();
                sep = ", ";
            }
            s = s + ">";
        }
        s = s + this.getName() + "(" + Arrays.asList(this.getParameterTypes()) + ")";
        return s;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureBase", "getSubstitutor"));
        }
        return psiSubstitutor;
    }
}

