/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodReferenceUtil {
    public static ThreadLocal<Map<PsiMethodReferenceExpression, PsiType>> ourRefs = new ThreadLocal();
    public static final Logger LOG = Logger.getInstance("#" + PsiMethodReferenceUtil.class.getName());

    public static boolean hasReceiver(PsiType[] parameterTypes, QualifierResolveResult qualifierResolveResult, PsiMethodReferenceExpression methodRef) {
        return parameterTypes.length > 0 && !methodRef.isConstructor() && PsiMethodReferenceUtil.isReceiverType(parameterTypes[0], qualifierResolveResult.getContainingClass(), qualifierResolveResult.getSubstitutor()) && PsiMethodReferenceUtil.isStaticallyReferenced(methodRef);
    }

    public static String checkReturnType(PsiMethodReferenceExpression expression, JavaResolveResult result2, PsiType functionalInterfaceType) {
        PsiElement resolve2 = result2.getElement();
        if (resolve2 instanceof PsiMethod) {
            PsiClass containingClass = ((PsiMethod)resolve2).getContainingClass();
            LOG.assertTrue(containingClass != null);
            PsiSubstitutor subst = result2.getSubstitutor();
            PsiClass qContainingClass = PsiMethodReferenceUtil.getQualifierResolveResult(expression).getContainingClass();
            if (qContainingClass != null && InheritanceUtil.isInheritorOrSelf(qContainingClass, containingClass, true)) {
                LOG.assertTrue((subst = TypeConversionUtil.getClassSubstitutor(containingClass, qContainingClass, subst)) != null);
            }
            PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
            PsiType returnType = PsiTypesUtil.patchMethodGetClassReturnType(expression, expression, (PsiMethod)resolve2, null, PsiUtil.getLanguageLevel(expression));
            if (returnType == null) {
                returnType = ((PsiMethod)resolve2).getReturnType();
            }
            PsiType methodReturnType = subst.substitute(returnType);
            if (interfaceReturnType != null && interfaceReturnType != PsiType.VOID) {
                if (methodReturnType == null) {
                    methodReturnType = JavaPsiFacade.getElementFactory(expression.getProject()).createType(containingClass, subst);
                }
                if (!TypeConversionUtil.isAssignable(interfaceReturnType, methodReturnType, false)) {
                    return "Bad return type in method reference: cannot convert " + methodReturnType.getCanonicalText() + " to " + interfaceReturnType.getCanonicalText();
                }
            }
        }
        return null;
    }

    public static boolean isCorrectAssignment(PsiType[] signatureParameterTypes2, PsiType[] parameterTypes, boolean varargs, int offset) {
        int min = Math.min(signatureParameterTypes2.length, parameterTypes.length - offset);
        for (int i = 0; i < min; ++i) {
            PsiType type1 = parameterTypes[i + offset];
            PsiType type2 = signatureParameterTypes2[i];
            if (!(varargs && i == signatureParameterTypes2.length - 1 ? !TypeConversionUtil.isAssignable(type2, type1) && !TypeConversionUtil.isAssignable(((PsiArrayType)type2).getComponentType(), type1) : !TypeConversionUtil.isAssignable(type2, type1))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Map<PsiMethodReferenceExpression, PsiType> getFunctionalTypeMap() {
        Map<PsiMethodReferenceExpression, PsiType> map2 = ourRefs.get();
        if (map2 == null) {
            map2 = new HashMap<PsiMethodReferenceExpression, PsiType>();
            ourRefs.set(map2);
        }
        Map<PsiMethodReferenceExpression, PsiType> map3 = map2;
        if (map3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiMethodReferenceUtil", "getFunctionalTypeMap"));
        }
        return map3;
    }

    public static boolean isValidQualifier(PsiMethodReferenceExpression expression) {
        PsiElement referenceNameElement = expression.getReferenceNameElement();
        if (referenceNameElement instanceof PsiKeyword) {
            PsiElement qualifier = expression.getQualifier();
            if (qualifier instanceof PsiTypeElement) {
                return true;
            }
            if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static QualifierResolveResult getQualifierResolveResult(@NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReferenceExpression", "com/intellij/psi/PsiMethodReferenceUtil", "getQualifierResolveResult"));
        }
        PsiClass containingClass = null;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiExpression expression = methodReferenceExpression.getQualifierExpression();
        if (expression != null) {
            JavaResolveResult resolveResult;
            PsiElement resolve2;
            PsiType expressionType = PsiMethodReferenceUtil.getExpandedType(expression.getType(), expression);
            PsiClassType.ClassResolveResult result2 = PsiUtil.resolveGenericsClassInType(expressionType);
            containingClass = result2.getElement();
            if (containingClass != null) {
                substitutor = result2.getSubstitutor();
            }
            if (containingClass == null && expression instanceof PsiReferenceExpression && (resolve2 = (resolveResult = ((PsiReferenceExpression)expression).advancedResolve(false)).getElement()) instanceof PsiClass) {
                containingClass = (PsiClass)resolve2;
                substitutor = resolveResult.getSubstitutor();
                boolean isRawSubst = !methodReferenceExpression.isConstructor() && PsiTreeUtil.isAncestor(containingClass, methodReferenceExpression, true) && PsiUtil.isRawSubstitutor(containingClass, substitutor);
                QualifierResolveResult qualifierResolveResult = new QualifierResolveResult(containingClass, isRawSubst ? PsiSubstitutor.EMPTY : substitutor, true);
                if (qualifierResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiMethodReferenceUtil", "getQualifierResolveResult"));
                }
                return qualifierResolveResult;
            }
        } else {
            PsiType type;
            PsiClassType.ClassResolveResult result3;
            PsiTypeElement typeElement = methodReferenceExpression.getQualifierType();
            if (typeElement != null && (containingClass = (result3 = PsiUtil.resolveGenericsClassInType(type = PsiMethodReferenceUtil.getExpandedType(typeElement.getType(), typeElement))).getElement()) != null) {
                substitutor = result3.getSubstitutor();
            }
        }
        QualifierResolveResult qualifierResolveResult = new QualifierResolveResult(containingClass, substitutor, false);
        if (qualifierResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiMethodReferenceUtil", "getQualifierResolveResult"));
        }
        return qualifierResolveResult;
    }

    public static boolean isStaticallyReferenced(@NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReferenceExpression", "com/intellij/psi/PsiMethodReferenceUtil", "isStaticallyReferenced"));
        }
        PsiExpression qualifierExpression = methodReferenceExpression.getQualifierExpression();
        if (qualifierExpression != null) {
            return qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).resolve() instanceof PsiClass;
        }
        return true;
    }

    public static boolean isReceiverType(@Nullable PsiClass aClass, @Nullable PsiClass containingClass) {
        return InheritanceUtil.isInheritorOrSelf(aClass, containingClass, true);
    }

    public static boolean isReceiverType(PsiType receiverType, @Nullable PsiClass containingClass, PsiSubstitutor psiSubstitutor) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass receiverClass;
        if (containingClass != null) {
            receiverType = PsiMethodReferenceUtil.getExpandedType(receiverType, containingClass);
        }
        if ((receiverClass = (resolveResult = PsiUtil.resolveGenericsClassInType(receiverType)).getElement()) != null && PsiMethodReferenceUtil.isReceiverType(receiverClass, containingClass)) {
            LOG.assertTrue(containingClass != null);
            return PsiMethodReferenceUtil.emptyOrRaw(containingClass, psiSubstitutor) || TypeConversionUtil.isAssignable(JavaPsiFacade.getElementFactory(containingClass.getProject()).createType(containingClass, psiSubstitutor), receiverType);
        }
        return false;
    }

    private static boolean emptyOrRaw(PsiClass containingClass, PsiSubstitutor psiSubstitutor) {
        return PsiUtil.isRawSubstitutor(containingClass, psiSubstitutor) || psiSubstitutor.getSubstitutionMap().isEmpty();
    }

    public static boolean isReceiverType(PsiType functionalInterfaceType, PsiClass containingClass, @Nullable PsiMethod referencedMethod) {
        PsiType firstParamType;
        boolean isReceiver;
        int interfaceMethodParamsLength;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        MethodSignature function = LambdaUtil.getFunction(resolveResult.getElement());
        if (function != null && (interfaceMethodParamsLength = function.getParameterTypes().length) > 0 && (isReceiver = PsiMethodReferenceUtil.isReceiverType(firstParamType = resolveResult.getSubstitutor().substitute(function.getParameterTypes()[0]), containingClass, PsiUtil.resolveGenericsClassInType(firstParamType).getSubstitutor()))) {
            if (referencedMethod == null) {
                return interfaceMethodParamsLength == 1;
            }
            return referencedMethod.getParameterList().getParametersCount() == interfaceMethodParamsLength - 1;
        }
        return false;
    }

    private static PsiType getExpandedType(PsiType type, @NotNull PsiElement typeElement) {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/intellij/psi/PsiMethodReferenceUtil", "getExpandedType"));
        }
        if (type instanceof PsiArrayType) {
            type = JavaPsiFacade.getElementFactory(typeElement.getProject()).getArrayClassType(((PsiArrayType)type).getComponentType(), PsiUtil.getLanguageLevel(typeElement));
        }
        return type;
    }

    public static String checkMethodReferenceContext(PsiMethodReferenceExpression methodRef) {
        PsiElement resolve2 = methodRef.resolve();
        if (resolve2 == null) {
            return null;
        }
        return PsiMethodReferenceUtil.checkMethodReferenceContext(methodRef, resolve2, methodRef.getFunctionalInterfaceType());
    }

    public static String checkMethodReferenceContext(PsiMethodReferenceExpression methodRef, PsiElement resolve2, PsiType functionalInterfaceType) {
        PsiClass outerClass;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement referenceElement;
        PsiClass containingClass = resolve2 instanceof PsiMethod ? ((PsiMethod)resolve2).getContainingClass() : (PsiClass)resolve2;
        boolean isStaticSelector = PsiMethodReferenceUtil.isStaticallyReferenced(methodRef);
        PsiElement qualifier = methodRef.getQualifier();
        boolean isMethodStatic = false;
        boolean receiverReferenced = false;
        boolean isConstructor = true;
        if (resolve2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolve2;
            isMethodStatic = method.hasModifierProperty("static");
            isConstructor = method.isConstructor();
            receiverReferenced = PsiMethodReferenceUtil.hasReceiver(methodRef, method, functionalInterfaceType);
            if (method.hasModifierProperty("abstract") && qualifier instanceof PsiSuperExpression) {
                return "Abstract method '" + method.getName() + "' cannot be accessed directly";
            }
        }
        if (!receiverReferenced && isStaticSelector && !isMethodStatic && !isConstructor) {
            return "Non-static method cannot be referenced from a static context";
        }
        if (!receiverReferenced && !isStaticSelector && isMethodStatic) {
            return "Static method referenced through non-static qualifier";
        }
        if (receiverReferenced && isStaticSelector && isMethodStatic && !isConstructor) {
            return "Static method referenced through receiver";
        }
        if (isMethodStatic && isStaticSelector && qualifier instanceof PsiTypeElement && (referenceElement = PsiTreeUtil.getChildOfType(qualifier, PsiJavaCodeReferenceElement.class)) != null && (parameterList = referenceElement.getParameterList()) != null && parameterList.getTypeArguments().length > 0) {
            return "Parameterized qualifier on static method reference";
        }
        if (isConstructor && containingClass != null && PsiUtil.isInnerClass(containingClass) && containingClass.isPhysical() && (outerClass = containingClass.getContainingClass()) != null && !InheritanceUtil.hasEnclosingInstanceInScope(outerClass, methodRef, true, false)) {
            return "An enclosing instance of type " + PsiFormatUtil.formatClass(outerClass, 1) + " is not in scope";
        }
        return null;
    }

    public static boolean hasReceiver(@NotNull PsiMethodReferenceExpression methodRef, @NotNull PsiMethod method) {
        if (methodRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodRef", "com/intellij/psi/PsiMethodReferenceUtil", "hasReceiver"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/PsiMethodReferenceUtil", "hasReceiver"));
        }
        return PsiMethodReferenceUtil.hasReceiver(methodRef, method, methodRef.getFunctionalInterfaceType());
    }

    private static boolean hasReceiver(@NotNull PsiMethodReferenceExpression methodRef, @NotNull PsiMethod method, PsiType functionalInterfaceType) {
        if (methodRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodRef", "com/intellij/psi/PsiMethodReferenceUtil", "hasReceiver"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/PsiMethodReferenceUtil", "hasReceiver"));
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        MethodSignature signature = interfaceMethod != null ? interfaceMethod.getSignature(LambdaUtil.getSubstitutor(interfaceMethod, resolveResult)) : null;
        LOG.assertTrue(signature != null);
        PsiType[] parameterTypes = signature.getParameterTypes();
        QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(methodRef);
        return (method.getParameterList().getParametersCount() + 1 == parameterTypes.length || method.isVarArgs() && parameterTypes.length > 0) && PsiMethodReferenceUtil.hasReceiver(parameterTypes, qualifierResolveResult, methodRef);
    }

    public static String checkTypeArguments(PsiTypeElement qualifier, PsiType psiType) {
        PsiJavaCodeReferenceElement referenceElement;
        if (psiType instanceof PsiClassType && (referenceElement = qualifier.getInnermostComponentReferenceElement()) != null) {
            PsiType[] typeParameters;
            for (PsiType typeParameter : typeParameters = referenceElement.getTypeParameters()) {
                if (!(typeParameter instanceof PsiWildcardType)) continue;
                return "Unexpected wildcard";
            }
        }
        return null;
    }

    public static class QualifierResolveResult {
        private final PsiClass myContainingClass;
        private final PsiSubstitutor mySubstitutor;
        private final boolean myReferenceTypeQualified;

        public QualifierResolveResult(PsiClass containingClass, PsiSubstitutor substitutor, boolean referenceTypeQualified) {
            this.myContainingClass = containingClass;
            this.mySubstitutor = substitutor;
            this.myReferenceTypeQualified = referenceTypeQualified;
        }

        @Nullable
        public PsiClass getContainingClass() {
            return this.myContainingClass;
        }

        public PsiSubstitutor getSubstitutor() {
            return this.mySubstitutor;
        }

        public boolean isReferenceTypeQualified() {
            return this.myReferenceTypeQualified;
        }
    }
}

