/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TemporaryConstVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class TranslationUtils {
    public static final Comparator<FunctionDescriptor> OVERLOADED_FUNCTION_COMPARATOR = new OverloadedFunctionComparator();

    private TranslationUtils() {
    }

    @NotNull
    public static JsPropertyInitializer translateFunctionAsEcma5PropertyDescriptor(@NotNull JsFunction function, @NotNull FunctionDescriptor descriptor, @NotNull TranslationContext context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        if (JsDescriptorUtils.isExtension(descriptor)) {
            JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateExtensionFunctionAsEcma5DataDescriptor(function, descriptor, context);
            if (jsPropertyInitializer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
            }
            return jsPropertyInitializer;
        }
        JsStringLiteral getOrSet = context.program().getStringLiteral(descriptor instanceof PropertyGetterDescriptor ? "get" : "set");
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(getOrSet, function);
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        return jsPropertyInitializer;
    }

    @NotNull
    public static JsFunction simpleReturnFunction(@NotNull JsScope functionScope, @NotNull JsExpression returnExpression) {
        if (functionScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionScope", "org/jetbrains/k2js/translate/utils/TranslationUtils", "simpleReturnFunction"));
        }
        if (returnExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnExpression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "simpleReturnFunction"));
        }
        JsFunction jsFunction = new JsFunction(functionScope, new JsBlock((JsStatement)new JsReturn(returnExpression)));
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "simpleReturnFunction"));
        }
        return jsFunction;
    }

    @NotNull
    private static JsPropertyInitializer translateExtensionFunctionAsEcma5DataDescriptor(@NotNull JsFunction function, @NotNull FunctionDescriptor descriptor, @NotNull TranslationContext context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        JsObjectLiteral meta = JsAstUtils.createDataDescriptor(function, descriptor.getModality().isOverridable(), false);
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(context.getNameForDescriptor(descriptor).makeRef(), meta);
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        return jsPropertyInitializer;
    }

    @NotNull
    public static JsExpression translateExclForBinaryEqualLikeExpr(@NotNull JsBinaryOperation baseBinaryExpression) {
        if (baseBinaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBinaryExpression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExclForBinaryEqualLikeExpr"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(TranslationUtils.notOperator(baseBinaryExpression.getOperator()), baseBinaryExpression.getArg1(), baseBinaryExpression.getArg2());
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExclForBinaryEqualLikeExpr"));
        }
        return jsBinaryOperation;
    }

    public static boolean isEqualLikeOperator(@NotNull JsBinaryOperator operator) {
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/k2js/translate/utils/TranslationUtils", "isEqualLikeOperator"));
        }
        return TranslationUtils.notOperator(operator) != null;
    }

    @Nullable
    private static JsBinaryOperator notOperator(@NotNull JsBinaryOperator operator) {
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/k2js/translate/utils/TranslationUtils", "notOperator"));
        }
        switch (operator) {
            case REF_EQ: {
                return JsBinaryOperator.REF_NEQ;
            }
            case REF_NEQ: {
                return JsBinaryOperator.REF_EQ;
            }
            case EQ: {
                return JsBinaryOperator.NEQ;
            }
            case NEQ: {
                return JsBinaryOperator.EQ;
            }
        }
        return null;
    }

    @NotNull
    public static JsBinaryOperation isNullCheck(@NotNull JsExpression expressionToCheck) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/k2js/translate/utils/TranslationUtils", "isNullCheck"));
        }
        JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(expressionToCheck, false);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "isNullCheck"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation isNotNullCheck(@NotNull JsExpression expressionToCheck) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/k2js/translate/utils/TranslationUtils", "isNotNullCheck"));
        }
        JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(expressionToCheck, true);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "isNotNullCheck"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation nullCheck(@NotNull JsExpression expressionToCheck, boolean isNegated) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/k2js/translate/utils/TranslationUtils", "nullCheck"));
        }
        JsBinaryOperator operator = isNegated ? JsBinaryOperator.NEQ : JsBinaryOperator.EQ;
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(operator, expressionToCheck, JsLiteral.NULL);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "nullCheck"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsConditional notNullConditional(@NotNull JsExpression expression, @NotNull JsExpression elseExpression, @NotNull TranslationContext context) {
        JsExpression thenExpression;
        JsBinaryOperation testExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        if (elseExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elseExpression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        if (TranslationUtils.isCacheNeeded(expression)) {
            TemporaryConstVariable tempVar = context.getOrDeclareTemporaryConstVariable(expression);
            testExpression = TranslationUtils.isNotNullCheck(tempVar.value());
            thenExpression = tempVar.value();
        } else {
            testExpression = TranslationUtils.isNotNullCheck(expression);
            thenExpression = expression;
        }
        JsConditional jsConditional = new JsConditional(testExpression, thenExpression, elseExpression);
        if (jsConditional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        return jsConditional;
    }

    @NotNull
    public static String getMangledName(@NotNull PropertyDescriptor descriptor, @NotNull String suggestedName) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getMangledName"));
        }
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getMangledName"));
        }
        String string = TranslationUtils.getStableMangledName(suggestedName, DescriptorUtils.getFqName(descriptor).asString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getMangledName"));
        }
        return string;
    }

    @NotNull
    public static String getSuggestedName(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getSuggestedName"));
        }
        String suggestedName = descriptor.getName().asString();
        if (descriptor instanceof FunctionDescriptor) {
            suggestedName = TranslationUtils.getMangledName((FunctionDescriptor)descriptor);
        }
        String string = suggestedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getSuggestedName"));
        }
        return string;
    }

    @NotNull
    private static String getMangledName(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getMangledName"));
        }
        if (TranslationUtils.needsStableMangling(descriptor)) {
            String string = TranslationUtils.getStableMangledName(descriptor);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getMangledName"));
            }
            return string;
        }
        String string = TranslationUtils.getSimpleMangledName(descriptor);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getMangledName"));
        }
        return string;
    }

    private static boolean needsStableMangling(FunctionDescriptor descriptor) {
        if (JsDescriptorUtils.isOverride(descriptor)) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            return descriptor.getVisibility().isPublicAPI();
        }
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            if (classDescriptor.getModality().isOverridable()) {
                return true;
            }
            if (!classDescriptor.getVisibility().isPublicAPI()) {
                return false;
            }
            return descriptor.getVisibility() == Visibilities.PUBLIC;
        }
        assert (containingDeclaration instanceof CallableMemberDescriptor) : "containingDeclaration for descriptor have unsupported type for mangling, descriptor: " + descriptor + ", containingDeclaration: " + containingDeclaration;
        return false;
    }

    @NotNull
    private static String getStableMangledName(@NotNull String suggestedName, String forCalculateId) {
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getStableMangledName"));
        }
        int absHashCode = Math.abs(forCalculateId.hashCode());
        String suffix = absHashCode == 0 ? "" : "_" + Integer.toString(absHashCode, 36) + "$";
        String string = suggestedName + suffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getStableMangledName"));
        }
        return string;
    }

    @NotNull
    private static String getStableMangledName(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getStableMangledName"));
        }
        String string = TranslationUtils.getStableMangledName(descriptor.getName().asString(), TranslationUtils.getArgumentTypesAsString(descriptor));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getStableMangledName"));
        }
        return string;
    }

    @NotNull
    private static String getSimpleMangledName(final @NotNull FunctionDescriptor descriptor) {
        Collection<DeclarationDescriptor> declarations;
        List<FunctionDescriptor> overloadedFunctions;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getSimpleMangledName"));
        }
        DeclarationDescriptor declaration = descriptor.getContainingDeclaration();
        JetScope jetScope = null;
        if (declaration instanceof PackageFragmentDescriptor) {
            jetScope = ((PackageFragmentDescriptor)declaration).getMemberScope();
        } else if (declaration instanceof ClassDescriptor) {
            jetScope = ((ClassDescriptor)declaration).getDefaultType().getMemberScope();
        }
        int counter = 0;
        if (jetScope != null && (overloadedFunctions = ContainerUtil.mapNotNull(declarations = jetScope.getAllDescriptors(), new Function<DeclarationDescriptor, FunctionDescriptor>(){

            @Override
            public FunctionDescriptor fun(DeclarationDescriptor declarationDescriptor) {
                if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                    return null;
                }
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                String name = AnnotationsUtils.getNameForAnnotatedObjectWithOverrides(functionDescriptor);
                if (name == null) {
                    if (TranslationUtils.needsStableMangling(functionDescriptor) && !functionDescriptor.getValueParameters().isEmpty()) {
                        return null;
                    }
                    name = declarationDescriptor.getName().asString();
                }
                return descriptor.getName().asString().equals(name) ? functionDescriptor : null;
            }
        })).size() > 1) {
            Collections.sort(overloadedFunctions, OVERLOADED_FUNCTION_COMPARATOR);
            counter = ContainerUtil.indexOfIdentity(overloadedFunctions, descriptor);
            assert (counter >= 0);
        }
        String name = descriptor.getName().asString();
        String string = counter == 0 ? name : name + '_' + counter;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getSimpleMangledName"));
        }
        return string;
    }

    private static String getArgumentTypesAsString(FunctionDescriptor descriptor) {
        StringBuilder argTypes = new StringBuilder();
        ReceiverParameterDescriptor receiverParameter = descriptor.getReceiverParameter();
        if (receiverParameter != null) {
            argTypes.append(TranslationUtils.getJetTypeFqName(receiverParameter.getType())).append(".");
        }
        argTypes.append(StringUtil.join(descriptor.getValueParameters(), new Function<ValueParameterDescriptor, String>(){

            @Override
            public String fun(ValueParameterDescriptor descriptor) {
                return TranslationUtils.getJetTypeFqName(descriptor.getType());
            }
        }, ","));
        return argTypes.toString();
    }

    @NotNull
    public static String getJetTypeFqName(@NotNull JetType jetType) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getJetTypeFqName"));
        }
        ClassifierDescriptor declaration = jetType.getConstructor().getDeclarationDescriptor();
        assert (declaration != null);
        if (declaration instanceof TypeParameterDescriptor) {
            String string = TranslationUtils.getJetTypeFqName(((TypeParameterDescriptor)declaration).getUpperBoundsAsType());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getJetTypeFqName"));
            }
            return string;
        }
        String string = DescriptorUtils.getFqName(declaration).asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getJetTypeFqName"));
        }
        return string;
    }

    @NotNull
    public static JsNameRef backingFieldReference(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "backingFieldReference"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "backingFieldReference"));
        }
        JsName backingFieldName = context.getNameForDescriptor(descriptor);
        if (!JsDescriptorUtils.isSimpleFinalProperty(descriptor)) {
            String backingFieldMangledName = descriptor.getVisibility() != Visibilities.PRIVATE ? TranslationUtils.getMangledName(descriptor, Namer.getKotlinBackingFieldName(backingFieldName.getIdent())) : Namer.getKotlinBackingFieldName(backingFieldName.getIdent());
            backingFieldName = context.declarePropertyOrPropertyAccessorName(descriptor, backingFieldMangledName, false);
        }
        JsNameRef jsNameRef = new JsNameRef(backingFieldName, (JsExpression)JsLiteral.THIS);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "backingFieldReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsExpression assignmentToBackingField(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor, @NotNull JsExpression assignTo) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        if (assignTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignTo", "org/jetbrains/k2js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        JsNameRef backingFieldReference = TranslationUtils.backingFieldReference(context, descriptor);
        JsExpression jsExpression = JsAstUtils.assignment(backingFieldReference, assignTo);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        return jsExpression;
    }

    @Nullable
    public static JsExpression translateInitializerForProperty(@NotNull JetProperty declaration, @NotNull TranslationContext context) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateInitializerForProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateInitializerForProperty"));
        }
        JsExpression jsInitExpression = null;
        JetExpression initializer = declaration.getInitializer();
        if (initializer != null) {
            jsInitExpression = Translation.translateAsExpression(initializer, context);
        }
        return jsInitExpression;
    }

    @NotNull
    public static JsExpression translateBaseExpression(@NotNull TranslationContext context, @NotNull JetUnaryExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateBaseExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateBaseExpression"));
        }
        JetExpression baseExpression = PsiUtils.getBaseExpression(expression);
        JsExpression jsExpression = Translation.translateAsExpression(baseExpression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateBaseExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateLeftExpression(@NotNull TranslationContext context, @NotNull JetBinaryExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        JetExpression left = expression.getLeft();
        assert (left != null) : "Binary expression should have a left expression: " + expression.getText();
        JsExpression jsExpression = Translation.translateAsExpression(left, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateRightExpression(@NotNull TranslationContext context, @NotNull JetBinaryExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        JetExpression rightExpression = expression.getRight();
        assert (rightExpression != null) : "Binary expression should have a right expression";
        JsExpression jsExpression = Translation.translateAsExpression(rightExpression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        return jsExpression;
    }

    public static boolean hasCorrespondingFunctionIntrinsic(@NotNull TranslationContext context, @NotNull JetOperationExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "hasCorrespondingFunctionIntrinsic"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "hasCorrespondingFunctionIntrinsic"));
        }
        CallableDescriptor operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression);
        if (operationDescriptor == null || !(operationDescriptor instanceof FunctionDescriptor)) {
            return true;
        }
        return context.intrinsics().getFunctionIntrinsics().getIntrinsic((FunctionDescriptor)operationDescriptor).exists();
    }

    @NotNull
    public static List<JsExpression> generateInvocationArguments(@NotNull JsExpression receiver, @NotNull List<JsExpression> arguments) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/k2js/translate/utils/TranslationUtils", "generateInvocationArguments"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/utils/TranslationUtils", "generateInvocationArguments"));
        }
        if (arguments.isEmpty()) {
            List<JsExpression> list = Collections.singletonList(receiver);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "generateInvocationArguments"));
            }
            return list;
        }
        ArrayList<JsExpression> argumentList = new ArrayList<JsExpression>(1 + arguments.size());
        argumentList.add(receiver);
        argumentList.addAll(arguments);
        ArrayList<JsExpression> arrayList = argumentList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "generateInvocationArguments"));
        }
        return arrayList;
    }

    public static boolean isCacheNeeded(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "isCacheNeeded"));
        }
        return !(expression instanceof JsLiteral) && (!(expression instanceof JsNameRef) || ((JsNameRef)expression).getQualifier() != null);
    }

    @NotNull
    public static Pair<JsVars.JsVar, JsExpression> createTemporaryIfNeed(@NotNull JsExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "createTemporaryIfNeed"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "createTemporaryIfNeed"));
        }
        if (TranslationUtils.isCacheNeeded(expression)) {
            Pair<JsVars.JsVar, JsExpression> pair = context.dynamicContext().createTemporary(expression);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "createTemporaryIfNeed"));
            }
            return pair;
        }
        Pair<Object, JsExpression> pair = Pair.create(null, expression);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "createTemporaryIfNeed"));
        }
        return pair;
    }

    @NotNull
    public static JsConditional sure(@NotNull JsExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "sure"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "sure"));
        }
        JsInvocation throwNPE = new JsInvocation(context.namer().throwNPEFunctionRef());
        JsConditional ensureNotNull = TranslationUtils.notNullConditional(expression, throwNPE, context);
        JsExpression thenExpression = ensureNotNull.getThenExpression();
        if (thenExpression instanceof JsNameRef) {
            context.associateExpressionToLazyValue(ensureNotNull, new TemporaryConstVariable(((JsNameRef)thenExpression).getName(), ensureNotNull));
        }
        JsConditional jsConditional = ensureNotNull;
        if (jsConditional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "sure"));
        }
        return jsConditional;
    }

    @NotNull
    public static String getSuggestedNameForInnerDeclaration(TranslationContext context, DeclarationDescriptor descriptor) {
        String suggestedName = "";
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration != null && !(containingDeclaration instanceof ClassOrPackageFragmentDescriptor) && !(containingDeclaration instanceof AnonymousFunctionDescriptor)) {
            suggestedName = context.getNameForDescriptor(containingDeclaration).getIdent();
        }
        if (!suggestedName.isEmpty() && !suggestedName.endsWith("$")) {
            suggestedName = suggestedName + "$";
        }
        suggestedName = descriptor.getName().isSpecial() ? suggestedName + "f" : suggestedName + context.getNameForDescriptor(descriptor).getIdent();
        String string = suggestedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getSuggestedNameForInnerDeclaration"));
        }
        return string;
    }

    private static class OverloadedFunctionComparator
    implements Comparator<FunctionDescriptor> {
        private OverloadedFunctionComparator() {
        }

        @Override
        public int compare(@NotNull FunctionDescriptor a, @NotNull FunctionDescriptor b) {
            int bArity;
            Integer result2;
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/k2js/translate/utils/TranslationUtils$OverloadedFunctionComparator", "compare"));
            }
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/k2js/translate/utils/TranslationUtils$OverloadedFunctionComparator", "compare"));
            }
            if (OverloadedFunctionComparator.isNativeOrOverrideNative(a)) {
                if (!OverloadedFunctionComparator.isNativeOrOverrideNative(b)) {
                    return -1;
                }
            } else if (OverloadedFunctionComparator.isNativeOrOverrideNative(b)) {
                return 1;
            }
            if ((result2 = Visibilities.compare(b.getVisibility(), a.getVisibility())) != null && result2 != 0) {
                return result2;
            }
            int aArity = OverloadedFunctionComparator.arity(a);
            if (aArity != (bArity = OverloadedFunctionComparator.arity(b))) {
                return aArity - bArity;
            }
            String aArguments = TranslationUtils.getArgumentTypesAsString(a);
            String bArguments = TranslationUtils.getArgumentTypesAsString(b);
            assert (aArguments != bArguments);
            return aArguments.compareTo(bArguments);
        }

        private static int arity(FunctionDescriptor descriptor) {
            return descriptor.getValueParameters().size() + (descriptor.getReceiverParameter() == null ? 0 : 1);
        }

        private static boolean isNativeOrOverrideNative(FunctionDescriptor descriptor) {
            if (AnnotationsUtils.isNativeObject(descriptor)) {
                return true;
            }
            Set<FunctionDescriptor> declarations = OverrideResolver.getAllOverriddenDeclarations(descriptor);
            for (FunctionDescriptor memberDescriptor : declarations) {
                if (!AnnotationsUtils.isNativeObject(memberDescriptor)) continue;
                return true;
            }
            return false;
        }
    }
}

