/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.factories;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;
import org.jetbrains.k2js.translate.callTranslator.CallInfo;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.KotlinFunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.DescriptorPredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.PatternBuilder;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class TopLevelFIF
extends CompositeFIF {
    public static final DescriptorPredicate EQUALS_IN_ANY = PatternBuilder.pattern("kotlin", "Any", "equals");
    @NotNull
    public static final KotlinFunctionIntrinsic KOTLIN_EQUALS = new KotlinFunctionIntrinsic("equals");
    @NotNull
    public static final FunctionIntrinsic IDENTITY_EQUALS = new FunctionIntrinsic(){

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
            if (arguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            assert (arguments.size() == 1) : "Unexpected argument size for kotlin.identityEquals: " + arguments.size();
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.REF_EQ, receiver, arguments.get(0));
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            return jsBinaryOperation;
        }
    };
    @NotNull
    public static final DescriptorPredicate HASH_CODE_IN_ANY = PatternBuilder.pattern("kotlin", "Any", "hashCode");
    @NotNull
    public static final KotlinFunctionIntrinsic KOTLIN_HASH_CODE = new KotlinFunctionIntrinsic("hashCode");
    @NotNull
    private static final FunctionIntrinsic RETURN_RECEIVER_INTRINSIC = new FunctionIntrinsic(){

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
            if (arguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$2", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$2", "apply"));
            }
            assert (receiver != null);
            JsExpression jsExpression = receiver;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$2", "apply"));
            }
            return jsExpression;
        }
    };
    private static final FunctionIntrinsic NATIVE_MAP_GET = new NativeMapGetSet(){

        @Override
        @NotNull
        protected String operationName() {
            if ("get" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$3", "operationName"));
            }
            return "get";
        }

        @Override
        @Nullable
        protected ExpressionReceiver getExpressionReceiver(@NotNull ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$3", "getExpressionReceiver"));
            }
            ReceiverValue result2 = resolvedCall.getThisObject();
            return result2 instanceof ExpressionReceiver ? (ExpressionReceiver)result2 : null;
        }

        @Override
        protected JsExpression asArrayAccess(@NotNull JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$3", "asArrayAccess"));
            }
            if (arguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$3", "asArrayAccess"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$3", "asArrayAccess"));
            }
            return ArrayFIF.GET_INTRINSIC.apply(receiver, arguments, context);
        }
    };
    private static final FunctionIntrinsic NATIVE_MAP_SET = new NativeMapGetSet(){

        @Override
        @NotNull
        protected String operationName() {
            if ("put" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$4", "operationName"));
            }
            return "put";
        }

        @Override
        @Nullable
        protected ExpressionReceiver getExpressionReceiver(@NotNull ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$4", "getExpressionReceiver"));
            }
            ReceiverValue result2 = resolvedCall.getReceiverArgument();
            return result2 instanceof ExpressionReceiver ? (ExpressionReceiver)result2 : null;
        }

        @Override
        protected JsExpression asArrayAccess(@NotNull JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$4", "asArrayAccess"));
            }
            if (arguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$4", "asArrayAccess"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$4", "asArrayAccess"));
            }
            return ArrayFIF.SET_INTRINSIC.apply(receiver, arguments, context);
        }
    };
    private static final FunctionIntrinsic PROPERTY_METADATA_IMPL = new FunctionIntrinsic(){

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
            if (arguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$5", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$5", "apply"));
            }
            JsNameRef functionRef2 = new JsNameRef("PropertyMetadata", "Kotlin");
            JsNew jsNew = new JsNew(functionRef2, arguments);
            if (jsNew == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$5", "apply"));
            }
            return jsNew;
        }
    };
    @NotNull
    public static final KotlinFunctionIntrinsic TO_STRING = new KotlinFunctionIntrinsic("toString");
    @NotNull
    public static final FunctionIntrinsicFactory INSTANCE = new TopLevelFIF();

    @NotNull
    private static String getStableMangledBuiltInName(@NotNull ClassDescriptor descriptor, @NotNull String functionName) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF", "getStableMangledBuiltInName"));
        }
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF", "getStableMangledBuiltInName"));
        }
        Collection<FunctionDescriptor> functions2 = descriptor.getDefaultType().getMemberScope().getFunctions(Name.identifier(functionName));
        assert (functions2.size() == 1) : "Can't select a single function: " + functionName + " in " + descriptor;
        String string = TranslationUtils.getSuggestedName(functions2.iterator().next());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF", "getStableMangledBuiltInName"));
        }
        return string;
    }

    private TopLevelFIF() {
        this.add(EQUALS_IN_ANY, KOTLIN_EQUALS);
        this.add(PatternBuilder.pattern("kotlin", "toString").isExtensionOf("kotlin.Any"), TO_STRING);
        this.add(PatternBuilder.pattern("kotlin", "equals").isExtensionOf("kotlin.Any"), KOTLIN_EQUALS);
        this.add(PatternBuilder.pattern("kotlin", "identityEquals").isExtensionOf("kotlin.Any"), IDENTITY_EQUALS);
        this.add(HASH_CODE_IN_ANY, KOTLIN_HASH_CODE);
        this.add(PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS, "equals"), KOTLIN_EQUALS);
        this.add(PatternBuilder.pattern("String|Boolean|Char|Number.equals"), KOTLIN_EQUALS);
        this.add(PatternBuilder.pattern("kotlin", "arrayOfNulls"), new KotlinFunctionIntrinsic("nullArray"));
        this.add(PatternBuilder.pattern("kotlin", "PropertyMetadataImpl", "<init>"), PROPERTY_METADATA_IMPL);
        this.add(PatternBuilder.pattern("kotlin", "iterator").isExtensionOf("kotlin.Iterator"), RETURN_RECEIVER_INTRINSIC);
        this.add(PatternBuilder.pattern("kotlin", "Map", "get").checkOverridden(), NATIVE_MAP_GET);
        this.add(PatternBuilder.pattern("js", "set").isExtensionOf("kotlin.MutableMap"), NATIVE_MAP_SET);
        this.add(PatternBuilder.pattern("java.util", "HashMap", "<init>"), new MapSelectImplementationIntrinsic(false));
        this.add(PatternBuilder.pattern("java.util", "HashSet", "<init>"), new MapSelectImplementationIntrinsic(true));
        this.add(PatternBuilder.pattern("js", "Json", "get"), ArrayFIF.GET_INTRINSIC);
        this.add(PatternBuilder.pattern("js", "Json", "set"), ArrayFIF.SET_INTRINSIC);
    }

    private static class MapSelectImplementationIntrinsic
    extends FunctionIntrinsic.CallParametersAwareFunctionIntrinsic {
        private final boolean isSet;

        private MapSelectImplementationIntrinsic(boolean isSet) {
            this.isSet = isSet;
        }

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
            if (callInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callInfo", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$MapSelectImplementationIntrinsic", "apply"));
            }
            if (arguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$MapSelectImplementationIntrinsic", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$MapSelectImplementationIntrinsic", "apply"));
            }
            JetType keyType = callInfo.getResolvedCall().getTypeArguments().values().iterator().next();
            Name keyTypeName = JsDescriptorUtils.getNameIfStandardType(keyType);
            String collectionClassName = keyTypeName != null && (NamePredicate.PRIMITIVE_NUMBERS.apply(keyTypeName) || keyTypeName.asString().equals("String") || PrimitiveType.BOOLEAN.getTypeName().equals(keyTypeName)) ? (this.isSet ? "PrimitiveHashSet" : "PrimitiveHashMap") : (this.isSet ? "ComplexHashSet" : "ComplexHashMap");
            JsNew jsNew = new JsNew(context.namer().kotlin(collectionClassName), arguments);
            if (jsNew == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$MapSelectImplementationIntrinsic", "apply"));
            }
            return jsNew;
        }
    }

    private static abstract class NativeMapGetSet
    extends FunctionIntrinsic.CallParametersAwareFunctionIntrinsic {
        private NativeMapGetSet() {
        }

        @NotNull
        protected abstract String operationName();

        @Nullable
        protected abstract ExpressionReceiver getExpressionReceiver(@NotNull ResolvedCall<?> var1);

        protected abstract JsExpression asArrayAccess(@NotNull JsExpression var1, @NotNull List<JsExpression> var2, @NotNull TranslationContext var3);

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
            if (callInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callInfo", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
            }
            if (arguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
            }
            ExpressionReceiver expressionReceiver = this.getExpressionReceiver(callInfo.getResolvedCall());
            JsExpression thisOrReceiver = NativeMapGetSet.getThisOrReceiverOrNull(callInfo);
            assert (thisOrReceiver != null);
            if (expressionReceiver != null) {
                Object candidate;
                JetExpression expression = expressionReceiver.getExpression();
                JetReferenceExpression referenceExpression = null;
                if (expression instanceof JetReferenceExpression) {
                    referenceExpression = (JetReferenceExpression)expression;
                } else if (expression instanceof JetQualifiedExpression && (candidate = ((JetQualifiedExpression)expression).getReceiverExpression()) instanceof JetReferenceExpression) {
                    referenceExpression = (JetReferenceExpression)candidate;
                }
                if (referenceExpression != null && (candidate = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), referenceExpression)) instanceof PropertyDescriptor && AnnotationsUtils.isNativeObject((DeclarationDescriptor)candidate)) {
                    JsExpression jsExpression = this.asArrayAccess(thisOrReceiver, arguments, context);
                    if (jsExpression == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
                    }
                    return jsExpression;
                }
            }
            String mangledName = TopLevelFIF.getStableMangledBuiltInName(KotlinBuiltIns.getInstance().getMutableMap(), this.operationName());
            JsInvocation jsInvocation = new JsInvocation((JsExpression)new JsNameRef(mangledName, thisOrReceiver), arguments);
            if (jsInvocation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
            }
            return jsInvocation;
        }
    }
}

