/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;

public class TypeUnifier {
    @NotNull
    public static UnificationResult unify(@NotNull TypeProjection knownProjection, @NotNull TypeProjection projectWithVariables, @NotNull Predicate<TypeConstructor> isVariable) {
        if (knownProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "knownProjection", "org/jetbrains/jet/lang/types/TypeUnifier", "unify"));
        }
        if (projectWithVariables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectWithVariables", "org/jetbrains/jet/lang/types/TypeUnifier", "unify"));
        }
        if (isVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isVariable", "org/jetbrains/jet/lang/types/TypeUnifier", "unify"));
        }
        UnificationResultImpl result2 = new UnificationResultImpl();
        TypeUnifier.doUnify(knownProjection, projectWithVariables, isVariable, result2);
        UnificationResultImpl unificationResultImpl = result2;
        if (unificationResultImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUnifier", "unify"));
        }
        return unificationResultImpl;
    }

    private static void doUnify(TypeProjection knownProjection, TypeProjection projectWithVariables, Predicate<TypeConstructor> isVariable, UnificationResultImpl result2) {
        boolean structuralMismatch;
        Variance withVariablesProjectionKind;
        JetType known = knownProjection.getType();
        JetType withVariables = projectWithVariables.getType();
        Variance knownProjectionKind = knownProjection.getProjectionKind();
        if (knownProjectionKind == (withVariablesProjectionKind = projectWithVariables.getProjectionKind()) && knownProjectionKind != Variance.INVARIANT) {
            TypeUnifier.doUnify(new TypeProjectionImpl(known), new TypeProjectionImpl(withVariables), isVariable, result2);
            return;
        }
        if (known.isNullable() && withVariables.isNullable()) {
            TypeUnifier.doUnify(new TypeProjectionImpl(knownProjectionKind, TypeUtils.makeNotNullable(known)), new TypeProjectionImpl(withVariablesProjectionKind, TypeUtils.makeNotNullable(withVariables)), isVariable, result2);
            return;
        }
        if (knownProjectionKind != withVariablesProjectionKind && withVariablesProjectionKind != Variance.INVARIANT) {
            result2.fail();
            return;
        }
        if (!known.isNullable() && withVariables.isNullable()) {
            result2.fail();
            return;
        }
        TypeConstructor maybeVariable = withVariables.getConstructor();
        if (isVariable.apply(maybeVariable)) {
            result2.put(maybeVariable, new TypeProjectionImpl(knownProjectionKind, known));
            return;
        }
        boolean bl = structuralMismatch = known.isNullable() != withVariables.isNullable() || knownProjectionKind != withVariablesProjectionKind || !known.getConstructor().equals(withVariables.getConstructor());
        if (structuralMismatch) {
            result2.fail();
            return;
        }
        if (known.getArguments().size() != withVariables.getArguments().size()) {
            result2.fail();
            return;
        }
        if (known.getArguments().isEmpty()) {
            return;
        }
        List<TypeProjection> knownArguments = known.getArguments();
        List<TypeProjection> withVariablesArguments = withVariables.getArguments();
        for (int i = 0; i < knownArguments.size(); ++i) {
            TypeProjection knownArg = knownArguments.get(i);
            TypeProjection withVariablesArg = withVariablesArguments.get(i);
            TypeUnifier.doUnify(knownArg, withVariablesArg, isVariable, result2);
        }
    }

    private static class UnificationResultImpl
    implements UnificationResult {
        private boolean success = true;
        private final Map<TypeConstructor, TypeProjection> substitution = Maps.newHashMapWithExpectedSize(1);
        private final Set<TypeConstructor> failedVariables = Sets.newHashSetWithExpectedSize(0);

        private UnificationResultImpl() {
        }

        @Override
        public boolean isSuccess() {
            return this.success;
        }

        public void fail() {
            this.success = false;
        }

        @Override
        @NotNull
        public Map<TypeConstructor, TypeProjection> getSubstitution() {
            Map<TypeConstructor, TypeProjection> map2 = this.substitution;
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUnifier$UnificationResultImpl", "getSubstitution"));
            }
            return map2;
        }

        public void put(TypeConstructor key, TypeProjection value) {
            if (this.failedVariables.contains(key)) {
                return;
            }
            TypeProjection oldValue = this.substitution.put(key, value);
            if (oldValue != null && !oldValue.equals(value)) {
                this.substitution.remove(key);
                this.failedVariables.add(key);
                this.fail();
            }
        }
    }

    public static interface UnificationResult {
        public boolean isSuccess();

        @NotNull
        public Map<TypeConstructor, TypeProjection> getSubstitution();
    }
}

