/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Function0;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ScriptDescriptorImpl;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.data.JetScriptInfo;
import org.jetbrains.jet.lang.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassMemberScope;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.storage.NotNullLazyValue;

public class LazyScriptClassMemberScope
extends LazyClassMemberScope {
    private final NotNullLazyValue<PropertyDescriptor> scriptResultProperty;

    protected LazyScriptClassMemberScope(@NotNull ResolveSession _resolveSession, @NotNull ClassMemberDeclarationProvider _declarationProvider, @NotNull LazyClassDescriptor thisClass, @NotNull BindingTrace trace) {
        if (_resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_resolveSession", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyScriptClassMemberScope", "<init>"));
        }
        if (_declarationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_declarationProvider", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyScriptClassMemberScope", "<init>"));
        }
        if (thisClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisClass", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyScriptClassMemberScope", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyScriptClassMemberScope", "<init>"));
        }
        super(_resolveSession, _declarationProvider, thisClass, trace);
        this.scriptResultProperty = _resolveSession.getStorageManager().createLazyValue(new Function0<PropertyDescriptor>(){

            @Override
            public PropertyDescriptor invoke() {
                JetScriptInfo scriptInfo = (JetScriptInfo)((ClassMemberDeclarationProvider)LazyScriptClassMemberScope.this.declarationProvider).getOwnerInfo();
                return ScriptDescriptorImpl.createScriptResultProperty(LazyScriptClassMemberScope.this.resolveSession.getScriptDescriptor(scriptInfo.getScript()));
            }
        });
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> computeExtraDescriptors() {
        List<DeclarationDescriptor> list = KotlinPackage.plus(super.computeExtraDescriptors(), KotlinPackage.plus(this.getProperties(Name.identifier("rv")), this.getPropertiesForScriptParameters()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyScriptClassMemberScope", "computeExtraDescriptors"));
        }
        return list;
    }

    private Collection<VariableDescriptor> getPropertiesForScriptParameters() {
        return KotlinPackage.flatMap(this.getPrimaryConstructor().getValueParameters(), new Function1<ValueParameterDescriptor, Iterable<? extends VariableDescriptor>>(){

            @Override
            public Iterable<? extends VariableDescriptor> invoke(ValueParameterDescriptor descriptor) {
                return LazyScriptClassMemberScope.this.getProperties(descriptor.getName());
            }
        });
    }

    @Override
    protected void getNonDeclaredProperties(@NotNull Name name, @NotNull Set<VariableDescriptor> result2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyScriptClassMemberScope", "getNonDeclaredProperties"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyScriptClassMemberScope", "getNonDeclaredProperties"));
        }
        super.getNonDeclaredProperties(name, result2);
        if (name.asString().equals("rv")) {
            result2.add((VariableDescriptor)this.scriptResultProperty.invoke());
        }
    }

    @NotNull
    public PropertyDescriptor getScriptResultProperty() {
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.scriptResultProperty.invoke();
        if (propertyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyScriptClassMemberScope", "getScriptResultProperty"));
        }
        return propertyDescriptor;
    }

    @Override
    protected void createPropertiesFromPrimaryConstructorParameters(@NotNull Name name, @NotNull Set<VariableDescriptor> result2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyScriptClassMemberScope", "createPropertiesFromPrimaryConstructorParameters"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyScriptClassMemberScope", "createPropertiesFromPrimaryConstructorParameters"));
        }
        JetScriptInfo scriptInfo = (JetScriptInfo)((ClassMemberDeclarationProvider)this.declarationProvider).getOwnerInfo();
        ConstructorDescriptor primaryConstructor = this.getPrimaryConstructor();
        if (primaryConstructor == null) {
            return;
        }
        for (ValueParameterDescriptor valueParameterDescriptor : primaryConstructor.getValueParameters()) {
            if (!name.equals(valueParameterDescriptor.getName())) continue;
            result2.add(ScriptDescriptorImpl.createPropertyFromScriptParameter(this.resolveSession.getScriptDescriptor(scriptInfo.getScript()), valueParameterDescriptor));
        }
    }

    @Override
    @Nullable
    protected ConstructorDescriptor resolvePrimaryConstructor() {
        JetScriptInfo scriptInfo = (JetScriptInfo)((ClassMemberDeclarationProvider)this.declarationProvider).getOwnerInfo();
        ScriptDescriptor scriptDescriptor = this.resolveSession.getScriptDescriptor(scriptInfo.getScript());
        ConstructorDescriptorImpl constructor = ScriptDescriptorImpl.createConstructor(scriptDescriptor, scriptDescriptor.getScriptCodeDescriptor().getValueParameters());
        this.setDeferredReturnType(constructor);
        return constructor;
    }
}

