/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.declarations;

import java.util.Collection;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.lazy.declarations.AbstractPsiBasedDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.StorageManager;

public class FileBasedPackageMemberDeclarationProvider
extends AbstractPsiBasedDeclarationProvider
implements PackageMemberDeclarationProvider {
    private final FqName fqName;
    private final FileBasedDeclarationProviderFactory factory;
    private final Collection<JetFile> packageFiles;
    private final NotNullLazyValue<Collection<FqName>> allDeclaredSubPackages;

    FileBasedPackageMemberDeclarationProvider(@NotNull StorageManager storageManager, @NotNull FqName _fqName2, @NotNull FileBasedDeclarationProviderFactory _factory, @NotNull Collection<JetFile> packageFiles) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider", "<init>"));
        }
        if (_fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_fqName", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider", "<init>"));
        }
        if (_factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_factory", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider", "<init>"));
        }
        if (packageFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFiles", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider", "<init>"));
        }
        super(storageManager);
        this.fqName = _fqName2;
        this.factory = _factory;
        this.packageFiles = packageFiles;
        this.allDeclaredSubPackages = storageManager.createLazyValue(new Function0<Collection<FqName>>(){

            @Override
            public Collection<FqName> invoke() {
                return FileBasedPackageMemberDeclarationProvider.this.factory.getAllDeclaredSubPackagesOf(FileBasedPackageMemberDeclarationProvider.this.fqName);
            }
        });
    }

    @Override
    protected void doCreateIndex(@NotNull AbstractPsiBasedDeclarationProvider.Index index) {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider", "doCreateIndex"));
        }
        for (JetFile file : this.packageFiles) {
            for (JetDeclaration declaration : file.getDeclarations()) {
                assert (this.fqName.equals(file.getPackageFqName())) : "Files declaration utils contains file with invalid package";
                index.putToIndex(declaration);
            }
        }
    }

    @Override
    @NotNull
    public Collection<FqName> getAllDeclaredSubPackages() {
        Collection collection = (Collection)this.allDeclaredSubPackages.invoke();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider", "getAllDeclaredSubPackages"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JetFile> getPackageFiles() {
        Collection<JetFile> collection = this.packageFiles;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider", "getPackageFiles"));
        }
        return collection;
    }

    public String toString() {
        return "Declarations for package " + this.fqName;
    }
}

