/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;

public class DeserializedResolverUtils {
    private DeserializedResolverUtils() {
    }

    @NotNull
    public static FqName kotlinFqNameToJavaFqName(@NotNull FqNameUnsafe kotlinFqName) {
        if (kotlinFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinFqName", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "kotlinFqNameToJavaFqName"));
        }
        List<Name> segments = kotlinFqName.pathSegments();
        ArrayList<String> correctedSegments = new ArrayList<String>(segments.size());
        for (Name segment : segments) {
            correctedSegments.add(SpecialNames.isClassObjectName(segment) ? "object" : segment.getIdentifier());
        }
        FqName fqName = FqName.fromSegments(correctedSegments);
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "kotlinFqNameToJavaFqName"));
        }
        return fqName;
    }

    @NotNull
    public static FqNameUnsafe javaFqNameToKotlinFqName(@NotNull FqName javaFqName) {
        if (javaFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaFqName", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "javaFqNameToKotlinFqName"));
        }
        if (javaFqName.isRoot()) {
            FqNameUnsafe fqNameUnsafe = javaFqName.toUnsafe();
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "javaFqNameToKotlinFqName"));
            }
            return fqNameUnsafe;
        }
        List<Name> segments = javaFqName.pathSegments();
        ArrayList<Name> correctedSegments = new ArrayList<Name>(segments.size());
        correctedSegments.add(segments.get(0));
        for (int i = 1; i < segments.size(); ++i) {
            Name segment = segments.get(i);
            boolean isClassObjectName = segment.asString().equals("object");
            Name correctedSegment = isClassObjectName ? SpecialNames.getClassObjectName(segments.get(i - 1)) : segment;
            correctedSegments.add(correctedSegment);
        }
        FqNameUnsafe fqNameUnsafe = FqNameUnsafe.fromSegments(correctedSegments);
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "javaFqNameToKotlinFqName"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    public static FqNameUnsafe naiveKotlinFqName(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "naiveKotlinFqName"));
        }
        DeclarationDescriptor containing = descriptor.getContainingDeclaration();
        if (containing instanceof ClassDescriptor) {
            FqNameUnsafe fqNameUnsafe = DeserializedResolverUtils.naiveKotlinFqName((ClassDescriptor)containing).child(descriptor.getName());
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "naiveKotlinFqName"));
            }
            return fqNameUnsafe;
        }
        if (containing instanceof PackageFragmentDescriptor) {
            FqNameUnsafe fqNameUnsafe = ((PackageFragmentDescriptor)containing).getFqName().child(descriptor.getName()).toUnsafe();
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "naiveKotlinFqName"));
            }
            return fqNameUnsafe;
        }
        throw new IllegalArgumentException("Class doesn't have a FQ name: " + descriptor);
    }
}

